/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.refactor;

import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.refactor.ResourceRefactorCommand;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ObjectDeleteCommand
extends ResourceRefactorCommand {
    public static final int ERROR_MISSING_OBJECT = 3001;
    public static final int ERROR_MULTIPLE_FILES = 3002;
    public static final int ERROR_DELETE_NULL = 3003;
    public static final int EXCEPTION_CALCULATING_DEPENDENCIES = 3004;
    public static final int ERROR_READONLY_RESOURCES = 3006;
    public static final int EXCEPTION_DURING_DELETE = 3007;
    public static final int ERROR_SIBLING_NAME = 3008;
    public static final int ERROR_SAME_NAME = 3008;
    private IStatus currentStatus;
    private EObject[] objectsToDelete;
    private String objectName;
    private boolean moreThanOneResource = false;
    private boolean deleteArrayContainsNull = false;

    public ObjectDeleteCommand() {
        super(ModelerCore.Util.getString("ObjectDeleteCommand.label"));
    }

    public void setObjectsToDelete(EObject[] objects) throws ModelWorkspaceException {
        this.objectsToDelete = objects;
        this.deleteArrayContainsNull = false;
        this.moreThanOneResource = false;
        if (objects != null && objects.length > 0 && objects[0] != null) {
            Resource firstResource = objects[0].eResource();
            ModelResource modelResource = ModelerCore.getModelEditor().findModelResource(firstResource);
            super.setResource(modelResource.getResource());
            if (objects.length > 1) {
                for (int i2 = 1; i2 < objects.length; ++i2) {
                    if (objects[i2] == null) {
                        this.deleteArrayContainsNull = true;
                        break;
                    }
                    if (objects[i2].eResource().equals(firstResource)) continue;
                    this.moreThanOneResource = true;
                    break;
                }
            }
        }
        if (objects.length == 1) {
            this.objectName = ModelerCore.getModelEditor().getName(objects[0]);
        } else {
            String objectCount = new Integer(objects.length).toString();
            this.objectName = ModelerCore.Util.getString("ObjectDeleteCommand.Number_of_objects", objectCount);
        }
    }

    private void checkStatus() {
        if (this.objectsToDelete == null || this.objectsToDelete.length == 0) {
            String msg = ModelerCore.Util.getString("ObjectDeleteCommand.No_delete_target_selected");
            this.currentStatus = new Status(4, "com.metamatrix.modeler.core", 3001, msg, null);
            return;
        }
        if (this.moreThanOneResource) {
            String msg = ModelerCore.Util.getString("ObjectDeleteCommand.Delete_from_more_than_one_file");
            this.currentStatus = new Status(4, "com.metamatrix.modeler.core", 3002, msg, null);
            return;
        }
        if (this.deleteArrayContainsNull) {
            String msg = ModelerCore.Util.getString("ObjectDeleteCommand.Delete_array_contains_null");
            this.currentStatus = new Status(4, "com.metamatrix.modeler.core", 3003, msg, null);
            return;
        }
        Object[] params = new Object[]{this.objectName};
        String msg = ModelerCore.Util.getString("ObjectDeleteCommand.Ready_to_delete", params);
        this.currentStatus = new Status(0, "com.metamatrix.modeler.core", 1000, msg, null);
    }

    protected IStatus getCanExecuteStatus() {
        this.checkStatus();
        return this.currentStatus;
    }

    protected IStatus modifyResource(IResource resource, IProgressMonitor monitor) {
        try {
            super.setModifiedResource(resource);
            ModelerCore.getModelEditor().delete(Arrays.asList(this.objectsToDelete));
        }
        catch (ModelerCoreException e2) {
            Object[] params = new Object[]{this.objectName};
            String msg = ModelerCore.Util.getString("ObjectDeleteCommand.Error_attempting_to_delete", params);
            return new Status(4, "com.metamatrix.modeler.core", 3007, msg, e2);
        }
        return null;
    }

    public Collection getDependentResources() {
        HashSet<ModelResource> result = new HashSet<ModelResource>();
        HashSet<Resource> emfResourceList = new HashSet<Resource>();
        for (int i2 = 0; i2 < this.objectsToDelete.length; ++i2) {
            try {
                Collection list = ModelerCore.getModelEditor().findOtherObjectsToBeDeleted(this.objectsToDelete[i2]);
                list = ModelerCore.getModelEditor().findExternalReferencesToObjectsBeingDeleted(this.objectsToDelete[i2], list);
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    Resource resource = ((EObject)iter.next()).eResource();
                    if (emfResourceList.contains(resource)) continue;
                    emfResourceList.add(resource);
                    result.add(ModelerCore.getModelEditor().findModelResource(resource));
                }
                continue;
            }
            catch (ModelerCoreException e2) {
                String msg = ModelerCore.Util.getString("ObjectDeleteCommand.Error_attempting_calculate_dependencies", this.objectsToDelete[i2]);
                super.addProblem(new Status(4, "com.metamatrix.modeler.core", 3004, msg, e2));
            }
        }
        return result;
    }

    public IStatus undoResourceModification(IProgressMonitor monitor) {
        return null;
    }

    public IStatus redoResourceModification(IProgressMonitor monitor) {
        return null;
    }

    public String getLabel() {
        return ModelerCore.Util.getString("ObjectDeleteCommand.delete_label", this.objectName);
    }

    public String getDescription() {
        Object[] params = new Object[]{this.objectName};
        return ModelerCore.Util.getString("ObjectDeleteCommand.delete_description", params);
    }

    public boolean canRedo() {
        return false;
    }

    public boolean canUndo() {
        return false;
    }

    protected Map getMovedResourcePathMap(boolean isUndo) {
        return new HashMap();
    }

    protected boolean shouldRebuildImports() {
        return false;
    }
}

