/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.refactor;

import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.plugin.PluginUtilities;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelImport;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.refactor.RefactorCommand;
import com.metamatrix.modeler.core.refactor.ReferenceUpdator;
import com.metamatrix.modeler.core.util.ConcurrentModelVisitorProcessor;
import com.metamatrix.modeler.core.util.ModelVisitor;
import com.metamatrix.modeler.core.validation.ValidationProblem;
import com.metamatrix.modeler.core.validation.rules.CoreValidationRulesUtil;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.w3c.dom.Element;

public class ModelCopyCommand
implements RefactorCommand {
    public static final int ERROR_MISSING_RESOURCE = 1800;
    public static final int ERROR_MISSING_DESTINATION = 1801;
    public static final int ERROR_MISSING_NAME = 1802;
    public static final int ERROR_PROJECT_CLOSED = 1805;
    public static final int ERROR_PROJECT_NATURE = 1806;
    public static final int EXCEPTION_PROJECT_NATURE = 1807;
    public static final int ERROR_FILE_ALREADY_EXISTS = 1808;
    public static final int ERROR_CREATING_FILE = 1809;
    public static final int READY_TO_EXECUTE = 1810;
    public static final int ERROR_COPYING_RESOURCE = 1811;
    public static final int EXECUTE_WITH_NO_PROBLEMS = 1812;
    public static final int EXECUTE_WITH_WARNINGS = 1813;
    public static final int EXECUTE_WITH_ERRORS = 1814;
    public static final int EXECUTE_WITH_WARNINGS_AND_ERRORS = 1815;
    public static final int EXECUTE_WITH_NO_WARNINGS_AND_ERRORS = 1816;
    static final String PID = "com.metamatrix.modeler.core";
    private static final String UUID_ATTRIBUTE_NAME = "UUID";
    private static Collection REFERENCE_UPDATORS;
    private ModelResource resourceToCopy;
    private IContainer destination;
    private String newModelName;
    private String extension;
    private IFile newIFile;
    private ArrayList problemList = new ArrayList();
    private Collection referencingResources;

    public void setModelToCopy(ModelResource modelResource) {
        this.resourceToCopy = modelResource;
        this.extension = modelResource.getResource().getFileExtension();
    }

    public void setNewModelDestination(IContainer destination, String name) {
        this.newModelName = name;
        this.destination = destination;
    }

    public void setModelsToRedirect(Collection modelResourceList) {
        this.referencingResources = modelResourceList;
    }

    public IStatus canExecute() {
        if (this.newModelName.length() == 0) {
            String msg = ModelerCore.Util.getString("ModelCopyCommand.No_new_model_name");
            return new Status(4, PID, 1802, msg, null);
        }
        if (this.resourceToCopy == null) {
            String msg = ModelerCore.Util.getString("ModelCopyCommand.No_resource_has_been_selected");
            return new Status(4, PID, 1800, msg, null);
        }
        if (this.destination == null) {
            String msg = ModelerCore.Util.getString("ModelCopyCommand.No_destination_has_been_selected");
            return new Status(4, PID, 1002, msg, null);
        }
        if (!this.destination.getProject().isOpen()) {
            String msg = ModelerCore.Util.getString("ModelCopyCommand.Error_project_closed");
            return new Status(4, PID, 1805, msg, null);
        }
        try {
            if (this.destination.getProject().getNature("com.metamatrix.modeler.core.modelNature") == null) {
                String msg = ModelerCore.Util.getString("ModelCopyCommand.Cannot_move_to_non_model_project");
                return new Status(4, PID, 1806, msg, null);
            }
        }
        catch (CoreException e2) {
            String msg = ModelerCore.Util.getString("ModelCopyCommand.Cannot_determine_project_nature");
            return new Status(4, PID, 1807, msg, e2);
        }
        ValidationResultImpl result = new ValidationResultImpl(this.newModelName);
        CoreValidationRulesUtil.validateStringNameChars(result, this.newModelName, null);
        if (result.hasProblems()) {
            ValidationProblem problem = result.getProblems()[0];
            return new Status(problem.getSeverity(), PID, problem.getCode(), problem.getMessage(), null);
        }
        if (this.fileAlreadyExists(this.newModelName)) {
            String msg = ModelerCore.Util.getString("ModelCopyCommand.Name_already_exists_in_container");
            return new Status(4, PID, 1808, msg, null);
        }
        String msg = ModelerCore.Util.getString("ModelCopyCommand.Ready_to_execute");
        return new Status(0, PID, 1000, msg, null);
    }

    public IStatus execute(IProgressMonitor monitor) {
        this.problemList.clear();
        this.newIFile = this.destination.getFile(new Path(this.newModelName + '.' + this.extension));
        if (this.isXsdResource(this.newIFile)) {
            this.executeXsdCopy(monitor);
        } else {
            this.executeXmiCopy(monitor);
        }
        IStatus resultStatus = null;
        if (this.problemList.isEmpty()) {
            int code = 1812;
            String msg = ModelerCore.Util.getString("ModelCopyCommand.Model_copy_complete_1");
            Status status = new Status(0, PID, 1812, msg, null);
            resultStatus = status;
        } else if (this.problemList.size() == 1) {
            resultStatus = (IStatus)this.problemList.get(0);
        } else {
            int numErrors = 0;
            int numWarnings = 0;
            Iterator problemIter = this.problemList.iterator();
            while (problemIter.hasNext()) {
                IStatus aStatus = (IStatus)problemIter.next();
                if (aStatus.getSeverity() == 2) {
                    ++numWarnings;
                    continue;
                }
                if (aStatus.getSeverity() != 4) continue;
                ++numErrors;
            }
            IStatus[] statusArray = this.problemList.toArray(new IStatus[this.problemList.size()]);
            if (numWarnings != 0 && numErrors == 0) {
                int code = 1813;
                Object[] params = new Object[]{new Integer(numWarnings)};
                String msg = ModelerCore.Util.getString("ModelCopyCommand.Model_copy_with_warnings_8", params);
                resultStatus = new MultiStatus(PID, 1813, statusArray, msg, null);
            } else if (numWarnings == 0 && numErrors != 0) {
                int code = 1814;
                Object[] params = new Object[]{new Integer(numErrors)};
                String msg = ModelerCore.Util.getString("ModelCopyCommand.Model_copy_with_errors_9", params);
                resultStatus = new MultiStatus(PID, 1814, statusArray, msg, null);
            } else if (numWarnings != 0 && numErrors != 0) {
                int code = 1815;
                Object[] params = new Object[]{new Integer(numWarnings), new Integer(numErrors)};
                String msg = ModelerCore.Util.getString("ModelCopyCommand.Model_copy_with_warnings_and_errors_10", params);
                resultStatus = new MultiStatus(PID, 1815, statusArray, msg, null);
            } else {
                int code = 1816;
                String msg = ModelerCore.Util.getString("ModelCopyCommand.Model_copy_with_no_warnings_or_errors_11");
                resultStatus = new MultiStatus(PID, 1816, statusArray, msg, null);
            }
        }
        return resultStatus;
    }

    public boolean canUndo() {
        return false;
    }

    public boolean canRedo() {
        return false;
    }

    public IStatus undo(IProgressMonitor monitor) {
        return null;
    }

    public IStatus redo(IProgressMonitor monitor) {
        return null;
    }

    public Collection getResult() {
        return null;
    }

    public Collection getAffectedObjects() {
        return null;
    }

    public String getLabel() {
        return ModelerCore.Util.getString("ModelCopyCommand.label");
    }

    public String getDescription() {
        return ModelerCore.Util.getString("ModelCopyCommand.description");
    }

    public Collection getPostExecuteMessages() {
        return this.problemList;
    }

    public IFile getNewIFile() {
        return this.newIFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void executeXsdCopy(IProgressMonitor monitor) {
        ModelResource modelResource;
        String msg;
        Object[] params;
        boolean modifiedState;
        boolean incrementalBuildState;
        Resource source;
        block28: {
            IOException e1222;
            Object var13_13;
            OutputStream bos;
            FileOutputStream fos;
            File newFile;
            block26: {
                source = null;
                try {
                    source = this.resourceToCopy.getEmfResource();
                    if (source == null) {
                        Object[] params2 = new Object[]{this.resourceToCopy};
                        String msg2 = ModelerCore.Util.getString("ModelCopyCommand.Error_getting_Emf_resource_for_2", params2);
                        this.problemList.add(new Status(4, PID, 1811, msg2, null));
                        return;
                    }
                }
                catch (Throwable e2) {
                    String msg3 = ModelerCore.Util.getString("ModelCopyCommand.Error_getting_Emf_resource_references_4");
                    this.problemList.add(new Status(4, PID, 1811, msg3, e2));
                }
                incrementalBuildState = this.getXsdIncrementalBuild(source);
                this.setXsdIncrementalBuild(source, false);
                modifiedState = source.isModified();
                IPath newFilePath = this.newIFile.getLocation();
                newFile = newFilePath.toFile();
                fos = null;
                bos = null;
                fos = new FileOutputStream(newFile);
                bos = new BufferedOutputStream(fos);
                source.save(bos, Collections.EMPTY_MAP);
                var13_13 = null;
                if (bos == null) break block26;
                try {
                    bos.close();
                }
                catch (IOException e1222) {
                    // empty catch block
                }
            }
            if (fos != null) {
                try {
                    ((OutputStream)fos).close();
                }
                catch (IOException e1222) {}
            }
            break block28;
            {
                catch (Throwable t2) {
                    IOException e1222;
                    params = new Object[]{newFile};
                    msg = ModelerCore.Util.getString("ModelCopyCommand.Exception_saving_XSD_resource_to_0_1", params);
                    this.problemList.add(new Status(4, PID, 1811, msg, t2));
                    var13_13 = null;
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException e1222) {
                            // empty catch block
                        }
                    }
                    if (fos != null) {
                        try {
                            ((OutputStream)fos).close();
                        }
                        catch (IOException e1222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e1222;
                Object var13_14 = null;
                if (bos != null) {
                    try {
                        bos.close();
                    }
                    catch (IOException e1222) {
                        // empty catch block
                    }
                }
                if (fos != null) {
                    try {
                        ((OutputStream)fos).close();
                    }
                    catch (IOException e1222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if ((modelResource = ModelerCore.create(this.newIFile)) == null) {
            params = new Object[]{this.newModelName};
            msg = ModelerCore.Util.getString("ModelCopyCommand.Error_creating_ModelResource_for_1", params);
            this.problemList.add(new Status(4, PID, 1811, msg, null));
            return;
        }
        Resource target = null;
        try {
            target = modelResource.getEmfResource();
            if (target == null) {
                Object[] params3 = new Object[]{modelResource};
                String msg4 = ModelerCore.Util.getString("ModelCopyCommand.Error_getting_Emf_resource_for_3", params3);
                this.problemList.add(new Status(4, PID, 1811, msg4, null));
                return;
            }
            this.resetXsdSimpleTypeUuids(target);
            target.save(Collections.EMPTY_MAP);
            target.setModified(false);
        }
        catch (Throwable e3) {
            String msg5 = ModelerCore.Util.getString("ModelCopyCommand.Error_getting_Emf_resource_references_4");
            this.problemList.add(new Status(4, PID, 1811, msg5, e3));
        }
        try {
            modelResource.save(monitor, true);
        }
        catch (Throwable e4) {
            Object[] params4 = new Object[]{modelResource};
            String msg6 = ModelerCore.Util.getString("ModelCopyCommand.Error_saving_new_model_resource_7", params4);
            this.problemList.add(new Status(4, PID, 1811, msg6, e4));
        }
        this.setXsdIncrementalBuild(source, incrementalBuildState);
        source.setModified(modifiedState);
        Map originalsToCopies = this.getOriginalToCopiesMap(source, target);
        this.updateReferencingResources(monitor, originalsToCopies, modelResource);
    }

    protected Map getOriginalToCopiesMap(Resource source, Resource target) {
        String uriFragment;
        int beginIndex;
        String uri;
        HashMap<EObject, EObject> originalToCopied = new HashMap<EObject, EObject>();
        HashMap<String, EObject> uriFragmentToObject = new HashMap<String, EObject>();
        TreeIterator iter = source.getAllContents();
        while (iter.hasNext()) {
            EObject originalObj = (EObject)iter.next();
            uri = EcoreUtil.getURI(originalObj).toString();
            beginIndex = uri.indexOf("#") + 1;
            uriFragment = beginIndex > 0 ? uri.substring(beginIndex) : uri;
            if (uriFragment == null) continue;
            uriFragmentToObject.put(uriFragment.toUpperCase(), originalObj);
        }
        iter = target.getAllContents();
        while (iter.hasNext()) {
            EObject originalObject;
            EObject copiedObj = (EObject)iter.next();
            uri = EcoreUtil.getURI(copiedObj).toString();
            beginIndex = uri.indexOf("#") + 1;
            uriFragment = beginIndex > 0 ? uri.substring(beginIndex) : uri;
            if (uriFragment == null || (originalObject = (EObject)uriFragmentToObject.get(uriFragment.toUpperCase())) == null) continue;
            originalToCopied.put(originalObject, copiedObj);
        }
        return originalToCopied;
    }

    protected void executeXmiCopy(IProgressMonitor monitor) {
        String msg;
        Iterator iter;
        ModelResource modelResource = ModelerCore.create(this.newIFile);
        if (modelResource == null) {
            Object[] params = new Object[]{this.newModelName};
            String msg2 = ModelerCore.Util.getString("ModelCopyCommand.Error_creating_ModelResource_for_1", params);
            this.problemList.add(new Status(4, PID, 1811, msg2, null));
            return;
        }
        Resource source = null;
        Resource target = null;
        try {
            source = this.resourceToCopy.getEmfResource();
            if (source == null) {
                Object[] params = new Object[]{this.resourceToCopy};
                String msg3 = ModelerCore.Util.getString("ModelCopyCommand.Error_getting_Emf_resource_for_2", params);
                this.problemList.add(new Status(4, PID, 1811, msg3, null));
                return;
            }
            target = modelResource.getEmfResource();
            if (target == null) {
                Object[] params = new Object[]{modelResource};
                String msg4 = ModelerCore.Util.getString("ModelCopyCommand.Error_getting_Emf_resource_for_3", params);
                this.problemList.add(new Status(4, PID, 1811, msg4, null));
                return;
            }
        }
        catch (Throwable e2) {
            String msg5 = ModelerCore.Util.getString("ModelCopyCommand.Error_getting_Emf_resource_references_4");
            this.problemList.add(new Status(4, PID, 1811, msg5, e2));
        }
        HashMap<EObject, EObject> originalsToCopies = new HashMap<EObject, EObject>();
        try {
            if (source instanceof EmfResource && target instanceof EmfResource) {
                ModelAnnotation sourceAnnot = ((EmfResource)source).getModelAnnotation();
                ModelAnnotation targetAnnot = ((EmfResource)target).getModelAnnotation();
                if (targetAnnot == null) {
                    targetAnnot = (ModelAnnotation)this.copyEObject(sourceAnnot);
                    target.getContents().add(targetAnnot);
                } else {
                    targetAnnot.setDescription(sourceAnnot.getDescription());
                    targetAnnot.setExtensionPackage(sourceAnnot.getExtensionPackage());
                    targetAnnot.setMaxSetSize(sourceAnnot.getMaxSetSize());
                    targetAnnot.setModelType(sourceAnnot.getModelType());
                    targetAnnot.setNameInSource(sourceAnnot.getNameInSource());
                    targetAnnot.setPrimaryMetamodelUri(sourceAnnot.getPrimaryMetamodelUri());
                    targetAnnot.setSupportsDistinct(sourceAnnot.isSupportsDistinct());
                    targetAnnot.setSupportsJoin(sourceAnnot.isSupportsJoin());
                    targetAnnot.setSupportsOrderBy(sourceAnnot.isSupportsOrderBy());
                    targetAnnot.setSupportsOuterJoin(sourceAnnot.isSupportsOuterJoin());
                    targetAnnot.setSupportsWhereAll(sourceAnnot.isSupportsWhereAll());
                    targetAnnot.setVisible(sourceAnnot.isVisible());
                    targetAnnot.eContents().clear();
                    iter = sourceAnnot.eContents().iterator();
                    while (iter.hasNext()) {
                        EObject sourceImport = (EObject)iter.next();
                        if (sourceImport == null) continue;
                        ModelImport targetImport = (ModelImport)this.copyEObject(sourceImport);
                        targetAnnot.getModelImports().add(targetImport);
                        originalsToCopies.put(sourceImport, targetImport);
                    }
                    originalsToCopies.put(sourceAnnot, targetAnnot);
                }
            }
        }
        catch (Throwable e3) {
            msg = ModelerCore.Util.getString("ModelCopyCommand.Error_copying_ModelAnnotation_information_5");
            this.problemList.add(new Status(4, PID, 1811, msg, e3));
        }
        try {
            ArrayList sourceRootsToCopy = new ArrayList(source.getContents());
            Iterator iter2 = sourceRootsToCopy.iterator();
            while (iter2.hasNext()) {
                EObject sourceRoot = (EObject)iter2.next();
                if (!(sourceRoot instanceof ModelAnnotation)) continue;
                iter2.remove();
            }
            Collection targetRoots = this.copyEObject(sourceRootsToCopy, originalsToCopies);
            iter = targetRoots.iterator();
            while (iter.hasNext()) {
                EObject targetRoot = (EObject)iter.next();
                ResetReferencesVisitor visitor = new ResetReferencesVisitor(originalsToCopies, false);
                ConcurrentModelVisitorProcessor processor = new ConcurrentModelVisitorProcessor(visitor);
                processor.walk(targetRoot, 2);
                target.getContents().add(targetRoot);
            }
        }
        catch (Throwable e4) {
            msg = ModelerCore.Util.getString("ModelCopyCommand.Error_copying_model_roots_6");
            this.problemList.add(new Status(4, PID, 1811, msg, e4));
        }
        try {
            modelResource.save(monitor, true);
        }
        catch (Throwable e5) {
            Object[] params = new Object[]{modelResource};
            String msg6 = ModelerCore.Util.getString("ModelCopyCommand.Error_saving_new_model_resource_7", params);
            this.problemList.add(new Status(4, PID, 1811, msg6, e5));
        }
        this.updateReferencingResources(monitor, originalsToCopies, modelResource);
    }

    public void updateReferencingResources(IProgressMonitor monitor, Map originalsToCopies, ModelResource referencedResource) {
        if (this.referencingResources == null || this.referencingResources.isEmpty()) {
            return;
        }
        ResetReferencesVisitor visitor = new ResetReferencesVisitor(originalsToCopies, true);
        try {
            Iterator iter = this.referencingResources.iterator();
            while (iter.hasNext()) {
                ModelResource referenceResource = (ModelResource)iter.next();
                ConcurrentModelVisitorProcessor processor = new ConcurrentModelVisitorProcessor(visitor);
                processor.walk(referenceResource, 2);
                referenceResource.save(monitor, true);
            }
        }
        catch (Throwable e2) {
            Object[] params = new Object[]{referencedResource};
            String msg = ModelerCore.Util.getString("ModelCopyCommand.0", params);
            this.problemList.add(new Status(4, PID, 1811, msg, e2));
        }
    }

    private static Collection getReferenceUpdators() {
        if (REFERENCE_UPDATORS == null) {
            String id = "com.metamatrix.modeler.core.referenceUpdator";
            IExtension[] extensions = PluginUtilities.getExtensions("com.metamatrix.modeler.core.referenceUpdator");
            REFERENCE_UPDATORS = new ArrayList(extensions.length);
            for (int i2 = 0; i2 < extensions.length; ++i2) {
                IExtension extension = extensions[i2];
                String element = "class";
                String attribute = "name";
                try {
                    Object instance = PluginUtilities.createExecutableExtension(extension, "class", "name");
                    if (instance instanceof ReferenceUpdator) {
                        REFERENCE_UPDATORS.add(instance);
                        continue;
                    }
                    String message = ModelerCore.Util.getString("ModelCopyCommand.0");
                    ModelerCore.Util.log(message);
                    continue;
                }
                catch (CoreException e2) {
                    ModelerCore.Util.log(e2);
                }
            }
        }
        return REFERENCE_UPDATORS;
    }

    private String getModifiedPathString(String proposedName) {
        String parentPath = ((Object)this.destination.getFullPath()).toString();
        String newPath = parentPath + '/' + proposedName;
        if (this.extension != null && this.extension.length() > 0) {
            newPath = newPath + '.' + this.extension;
        }
        return newPath;
    }

    private boolean fileAlreadyExists(String proposedName) {
        String newPath = this.getModifiedPathString(proposedName);
        IWorkspaceRoot workspaceRoot = this.resourceToCopy.getResource().getWorkspace().getRoot();
        return workspaceRoot.findMember(newPath) != null;
    }

    private EObject copyEObject(EObject eObject) {
        return EcoreUtil.copy(eObject);
    }

    private Collection copyEObject(List eObjects, Map originalsToCopies) throws Exception {
        return ModelerCore.getModelEditor().copyAll(eObjects, originalsToCopies);
    }

    private boolean isXsdResource(IFile resource) {
        return ModelUtil.isXsdFile(resource);
    }

    private boolean getXsdIncrementalBuild(Resource resource) {
        XSDResourceImpl xsdResource;
        XSDSchema schema;
        if (resource instanceof XSDResourceImpl && (schema = (xsdResource = (XSDResourceImpl)resource).getSchema()) != null) {
            return schema.isIncrementalUpdate();
        }
        return false;
    }

    private void resetXsdSimpleTypeUuids(Resource resource) throws Exception {
        XSDResourceImpl xsdResource;
        XSDSchema schema;
        if (resource instanceof XSDResourceImpl && (schema = (xsdResource = (XSDResourceImpl)resource).getSchema()) != null) {
            Iterator iter = schema.getContents().iterator();
            while (iter.hasNext()) {
                XSDSimpleTypeDefinition type;
                XSDAnnotation annotation;
                EObject eObj = (EObject)iter.next();
                if (!(eObj instanceof XSDSimpleTypeDefinition) || (annotation = (type = (XSDSimpleTypeDefinition)eObj).getAnnotation()) == null) continue;
                Iterator appInfos = annotation.getApplicationInformation().iterator();
                while (appInfos.hasNext()) {
                    Element appInfo = (Element)appInfos.next();
                    String uuid = appInfo.getAttribute(UUID_ATTRIBUTE_NAME);
                    if (uuid == null) continue;
                    uuid = ((Object)IDGenerator.getInstance().create()).toString();
                    appInfo.setAttribute(UUID_ATTRIBUTE_NAME, uuid);
                    uuid = appInfo.getAttribute(UUID_ATTRIBUTE_NAME);
                }
            }
        }
    }

    private void setXsdIncrementalBuild(Resource resource, boolean isIncrementalUpdate) {
        XSDResourceImpl xsdResource;
        XSDSchema schema;
        if (resource instanceof XSDResourceImpl && (schema = (xsdResource = (XSDResourceImpl)resource).getSchema()) != null) {
            schema.setIncrementalUpdate(isIncrementalUpdate);
        }
    }

    private class ResetReferencesVisitor
    implements ModelVisitor {
        private final Map originalsToCopies;
        private final Collection updatedExternalObjects = new HashSet();
        private final boolean isExternalResource;

        public ResetReferencesVisitor(Map originalsToCopies, boolean isExternalResource) {
            this.originalsToCopies = originalsToCopies;
            this.isExternalResource = isExternalResource;
        }

        public boolean visit(EObject eObj) throws ModelerCoreException {
            EList refs = eObj.eClass().getEAllReferences();
            Iterator iter1 = refs.iterator();
            while (iter1.hasNext()) {
                EReference eReference = (EReference)iter1.next();
                if (eReference.isContainment() && eReference.isContainer() && eReference.isVolatile()) continue;
                Object value = eObj.eGet(eReference);
                if (eReference.isMany()) {
                    List values = (List)value;
                    if (values.isEmpty()) continue;
                    ArrayList<EObject> newValues = new ArrayList<EObject>(values.size());
                    boolean resetList = false;
                    Iterator iter2 = values.iterator();
                    while (iter2.hasNext()) {
                        Object valueInList = iter2.next();
                        if (valueInList == null || !(valueInList instanceof EObject)) continue;
                        EObject orig = (EObject)valueInList;
                        EObject copy = (EObject)this.originalsToCopies.get(orig);
                        if (copy != null) {
                            newValues.add(copy);
                            resetList = true;
                            continue;
                        }
                        this.updateReference(orig);
                        newValues.add(orig);
                    }
                    if (!resetList) continue;
                    ModelerCore.getModelEditor().setPropertyValue(eObj, newValues, eReference);
                    continue;
                }
                if (value == null || !(value instanceof EObject)) continue;
                EObject orig = (EObject)value;
                EObject copy = (EObject)this.originalsToCopies.get(orig);
                if (copy != null) {
                    eObj.eSet(eReference, copy);
                    continue;
                }
                this.updateReference(orig);
            }
            return true;
        }

        private void updateReference(EObject eObject) throws ModelerCoreException {
            if (this.isExternalResource && !this.updatedExternalObjects.contains(eObject)) {
                Iterator iter = ModelCopyCommand.getReferenceUpdators().iterator();
                while (iter.hasNext()) {
                    ReferenceUpdator updator = (ReferenceUpdator)iter.next();
                    updator.updateEObject(eObject, this.originalsToCopies);
                }
                this.updatedExternalObjects.add(eObject);
            }
        }

        public boolean visit(Resource resource) throws ModelerCoreException {
            return resource != null;
        }
    }
}

