/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.notification.util;

import com.metamatrix.metamodels.core.Annotation;
import com.metamatrix.modeler.core.notification.util.NotificationUtilities;
import com.metamatrix.modeler.core.transaction.SourcedNotification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;

public class SourcedNotificationUtilities {
    private SourcedNotificationUtilities() {
    }

    public static Collection getAddNotifications(SourcedNotification sourcedNotification) {
        ArrayList<Notification> result = new ArrayList<Notification>();
        if (sourcedNotification != null) {
            Iterator iter = sourcedNotification.getNotifications().iterator();
            while (iter.hasNext()) {
                Notification notification = (Notification)iter.next();
                if (!NotificationUtilities.isAdded(notification)) continue;
                result.add(notification);
            }
        }
        return result;
    }

    public static Collection getRemovedNotifications(SourcedNotification sourcedNotification) {
        ArrayList<Notification> result = new ArrayList<Notification>();
        if (sourcedNotification != null) {
            Iterator iter = sourcedNotification.getNotifications().iterator();
            while (iter.hasNext()) {
                Notification notification = (Notification)iter.next();
                if (!NotificationUtilities.isRemoved(notification)) continue;
                result.add(notification);
            }
        }
        return result;
    }

    public static Collection getChangedNotifications(SourcedNotification sourcedNotification) {
        ArrayList<Notification> result = new ArrayList<Notification>();
        if (sourcedNotification != null) {
            Iterator iter = sourcedNotification.getNotifications().iterator();
            while (iter.hasNext()) {
                Notification notification = (Notification)iter.next();
                if (!NotificationUtilities.isChanged(notification)) continue;
                result.add(notification);
            }
        }
        return result;
    }

    public static Set getAffectedFeatureIDs(SourcedNotification sn, Class expectedClass) {
        HashSet<Integer> rv = new HashSet<Integer>();
        Iterator itor = sn.getNotifications().iterator();
        while (itor.hasNext()) {
            Notification noti = (Notification)itor.next();
            rv.add(new Integer(noti.getFeatureID(expectedClass)));
        }
        return rv;
    }

    public static Set getAllNotifiers(SourcedNotification sn) {
        Collection notifications = sn.getNotifications();
        HashSet<Object> rv = new HashSet<Object>(notifications.size());
        Iterator itor = notifications.iterator();
        while (itor.hasNext()) {
            Notification noti = (Notification)itor.next();
            rv.add(noti.getNotifier());
        }
        return rv;
    }

    public static Set gatherNotifiers(Notification notification, boolean gatherAnnotatedObjects) {
        Set<Object> notifyingObjects;
        if (notification instanceof SourcedNotification) {
            SourcedNotification sn = (SourcedNotification)notification;
            notifyingObjects = SourcedNotificationUtilities.getAllNotifiers(sn);
        } else {
            Object target = notification.getNotifier();
            notifyingObjects = Collections.singleton(target);
        }
        if (gatherAnnotatedObjects) {
            HashSet<Object> affectedObjects = new HashSet<Object>(notifyingObjects.size());
            Iterator<Object> it = notifyingObjects.iterator();
            while (it.hasNext()) {
                EObject mightBeAnnotation;
                Object target = it.next();
                if (target instanceof EStringToStringMapEntryImpl && (mightBeAnnotation = ((EStringToStringMapEntryImpl)target).eContainer()) instanceof Annotation) {
                    affectedObjects.add(((Annotation)mightBeAnnotation).getAnnotatedObject());
                }
                affectedObjects.add(target);
            }
            notifyingObjects = affectedObjects;
        }
        return notifyingObjects;
    }
}

