/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.metamodel.core.aspects.validation.rules;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelImport;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.container.ResourceFinder;
import com.metamatrix.modeler.core.validation.ObjectValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class MissingModelImportRule
implements ObjectValidationRule {
    static /* synthetic */ Class class$com$metamatrix$metamodels$core$ModelAnnotation;

    public void validate(EObject eObject, ValidationContext context) {
        ArgCheck.isInstanceOf(class$com$metamatrix$metamodels$core$ModelAnnotation == null ? (class$com$metamatrix$metamodels$core$ModelAnnotation = MissingModelImportRule.class$("com.metamatrix.metamodels.core.ModelAnnotation")) : class$com$metamatrix$metamodels$core$ModelAnnotation, eObject);
        ModelAnnotation modelAnnot = (ModelAnnotation)eObject;
        Resource resource = modelAnnot.eResource();
        if (resource == null) {
            return;
        }
        Container container = context.getResourceContainer();
        Assertion.isNotNull(container);
        ResourceFinder finder = container.getResourceFinder();
        String[] unresolvedLocations = finder.findUnresolvedResourceLocations(resource);
        for (int i2 = 0; i2 != unresolvedLocations.length; ++i2) {
            String pathToExternalResource = unresolvedLocations[i2];
            Object[] params = new Object[]{pathToExternalResource};
            ValidationResultImpl result = new ValidationResultImpl(eObject, eObject.eResource());
            String msg = ModelerCore.Util.getString("MissingModelImportRule.Missing_model_import_to_resource_0_4", params);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem(problem);
            result.setFatalResource(true);
            context.addResult(result);
        }
        List<Resource> refs = Arrays.asList(finder.findReferencesFrom(resource, false, true));
        ArrayList imports = new ArrayList(modelAnnot.getModelImports());
        Iterator i3 = imports.iterator();
        while (i3.hasNext()) {
            ValidationProblemImpl problem;
            String msg;
            ValidationResultImpl result;
            Object[] params;
            URI uri;
            ModelImport modelImport = (ModelImport)i3.next();
            String location = modelImport.getModelLocation();
            if (!StringUtil.isEmpty(location) && finder.isBuiltInResource(uri = URI.createURI(location))) continue;
            Resource importResource = finder.findByImport(modelImport, true);
            if (importResource == null) {
                params = new Object[]{location};
                result = new ValidationResultImpl(eObject, eObject.eResource());
                msg = ModelerCore.Util.getString("MissingModelImportRule.Bad_model_import_to_resource_0_4", params);
                problem = new ValidationProblemImpl(0, 4, msg);
                result.addProblem(problem);
                result.setFatalResource(true);
                context.addResult(result);
                continue;
            }
            if (importResource == resource || refs.contains(importResource)) continue;
            params = new Object[]{location};
            result = new ValidationResultImpl(eObject, modelImport);
            msg = ModelerCore.Util.getString("MissingModelImportRule.Model_import_0_is_no_longer_needed._3", params);
            problem = new ValidationProblemImpl(0, 2, msg);
            result.addProblem(problem);
            context.addResult(result);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

