/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.metamodel;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.IntervalMultiplicity;
import com.metamatrix.modeler.core.metamodel.MultiplicityExpressionException;
import com.metamatrix.modeler.core.metamodel.MultiplicityHolder;
import com.metamatrix.modeler.core.metamodel.RangeMultiplicity;
import com.metamatrix.modeler.core.metamodel.UnlimitedMultiplicity;
import java.io.Serializable;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class Multiplicity
implements Serializable,
Comparable {
    public static final String UNBOUNDED_DEFINITION = "*";
    protected static final char UNBOUNDED_CHAR = '*';
    public static final String RANGE_DELIMITER = "..";
    protected static final char RANGE_DELIMITER_CHAR = '.';
    protected static final int RANGE_DELIMITER_LENGTH = "..".length();
    public static final String INTERVAL_DELIMITER = ",";
    protected static final char INTERVAL_DELIMITER_CHAR = ',';
    protected static final int INTERVAL_DELIMITER_LENGTH = ",".length();
    public static final int UNBOUNDED_VALUE = Integer.MAX_VALUE;
    protected static final int MINIMUM_SINGLE_VALUE = 1;
    protected static final int DEFAULT_SINGLE_VALUE = 1;
    public static final boolean DEFAULT_ORDERING = false;
    public static final boolean DEFAULT_UNIQUENESS = false;
    public static final Multiplicity UNBOUNDED = new UnlimitedMultiplicity();
    public static final Multiplicity ZERO_OR_ONE = Multiplicity.getInstance(0, 1);
    public static final Multiplicity ONLY_ONE = Multiplicity.getInstance(1);
    public static final Multiplicity ONE_OR_MORE = Multiplicity.getInstance(1, Integer.MAX_VALUE);
    private static final Map InstancePool = Collections.synchronizedMap(new HashMap());
    public static boolean DEBUG_MULTIPLICITY_CREATION = false;
    public static boolean DEBUG_MULTIPLICITY_LOCATION = false;
    protected static final Multiplicity DEFAULT = new IntervalMultiplicity(1);
    private boolean isOrdered = false;
    private boolean isUnique = false;

    public static Multiplicity get(String multiplicityValue, boolean isOrdered, boolean isUnique) throws MultiplicityExpressionException {
        MultiplicityHolder key;
        Multiplicity result;
        if (multiplicityValue == null) {
            Assertion.isNotNull(multiplicityValue, ModelerCore.Util.getString("Multiplicity.The_multiplicity_string_may_not_be_null"));
        }
        if ((result = (Multiplicity)InstancePool.get(key = new MultiplicityHolder(multiplicityValue, isOrdered, isUnique))) == null) {
            result = Multiplicity.getInstance(multiplicityValue, isOrdered, isUnique);
            InstancePool.put(key, result);
            if (DEBUG_MULTIPLICITY_CREATION) {
                ModelerCore.Util.log(1, ModelerCore.Util.getString("Multiplicity.DEBUG.Adding_Multiplicity") + result + "\"");
            }
        } else if (DEBUG_MULTIPLICITY_LOCATION) {
            ModelerCore.Util.log(1, ModelerCore.Util.getString("Multiplicity.DEBUG.Found_Multiplicity") + result + "\"");
        }
        return result;
    }

    public static Multiplicity get(String multiplicityValue) throws MultiplicityExpressionException {
        return Multiplicity.get(multiplicityValue, false, false);
    }

    public static void clearPool() {
        InstancePool.clear();
    }

    static List parseExpression(String defn, boolean isOrdered, boolean isUnique) throws MultiplicityExpressionException {
        ArrayList<Multiplicity> results = new ArrayList<Multiplicity>();
        if (defn == null || defn.trim().length() == 0) {
            results.add(DEFAULT);
            return results;
        }
        if (defn == UNBOUNDED_DEFINITION || defn.equals(UNBOUNDED_DEFINITION)) {
            results.add(UNBOUNDED);
            return results;
        }
        int minimum = -1;
        int maximum = -1;
        int startIndex = 0;
        int currentIndex = 0;
        StringCharacterIterator iter = new StringCharacterIterator(defn);
        char c2 = iter.first();
        while (c2 != '\uffff') {
            currentIndex = iter.getIndex();
            if (c2 == '.') {
                if (minimum == -1) {
                    try {
                        minimum = Integer.parseInt(defn.substring(startIndex, currentIndex));
                    }
                    catch (NumberFormatException e2) {
                        Object[] params = new Object[]{RANGE_DELIMITER, new Integer(currentIndex), defn};
                        throw new MultiplicityExpressionException(ModelerCore.Util.getString("Multiplicity.Malformed_text_before_the_range_delimiter_at_index_is_not_an_integer", params));
                    }
                }
                startIndex = currentIndex + RANGE_DELIMITER_LENGTH;
                iter.setIndex(startIndex);
            }
            if (c2 == ',') {
                if (defn.charAt(startIndex) == '*') {
                    throw new MultiplicityExpressionException(ModelerCore.Util.getString("Multiplicity.Malformed_unbounded_interval_maximum_must_appear_at_the_end_of_the_expression", new Integer(startIndex), defn));
                }
                try {
                    maximum = Integer.parseInt(defn.substring(startIndex, currentIndex));
                    if (minimum == -1) {
                        minimum = maximum;
                    }
                }
                catch (NumberFormatException e3) {
                    throw new MultiplicityExpressionException(ModelerCore.Util.getString("Multiplicity.Malformed_text_at_indexes_is_not_an_integer", new Integer(startIndex), new Integer(currentIndex), defn));
                }
                try {
                    results.add(new IntervalMultiplicity(minimum, maximum, isOrdered, isUnique));
                }
                catch (IllegalArgumentException e4) {
                    throw new MultiplicityExpressionException(ModelerCore.Util.getString("Multiplicity.Malformed_minimum_must_be_equal_to_or_less_than_the_maximum_interval", new Integer(minimum), new Integer(maximum), defn));
                }
                minimum = -1;
                maximum = -1;
                startIndex = currentIndex + INTERVAL_DELIMITER_LENGTH;
                iter.setIndex(startIndex);
            }
            c2 = iter.next();
        }
        if (defn.length() <= startIndex) {
            throw new MultiplicityExpressionException(ModelerCore.Util.getString("Multiplicity.Malformed_expression_may_not_end_with_a_delimiter", new Integer(defn.length() - 1), defn));
        }
        if (defn.charAt(startIndex) == '*') {
            maximum = Integer.MAX_VALUE;
        } else {
            try {
                maximum = Integer.parseInt(defn.substring(startIndex));
            }
            catch (NumberFormatException e5) {
                throw new MultiplicityExpressionException(ModelerCore.Util.getString("Multiplicity.Malformed_text_at_indexes_is_not_an_integer", new Integer(startIndex), new Integer(defn.length() - 1), defn));
            }
        }
        if (minimum == -1) {
            minimum = maximum;
        }
        try {
            results.add(new IntervalMultiplicity(minimum, maximum, isOrdered, isUnique));
        }
        catch (IllegalArgumentException e6) {
            throw new MultiplicityExpressionException(ModelerCore.Util.getString("Multiplicity.Malformed_minimum_must_be_equal_to_or_less_than_the_maximum", new Integer(minimum), new Integer(maximum), defn));
        }
        Collections.sort(results);
        if (results.size() > 1) {
            int index = 0;
            Multiplicity first = (Multiplicity)results.get(index);
            Multiplicity next = (Multiplicity)results.get(++index);
            while (next != null) {
                if (first.getMaximum() >= next.getMinimum() || first.getMaximum() == next.getMinimum() - 1) {
                    int min = Math.min(first.getMinimum(), next.getMinimum());
                    int max = Math.max(first.getMaximum(), next.getMaximum());
                    first = new IntervalMultiplicity(min, max, isOrdered, isUnique);
                    results.set(index - 1, first);
                    results.remove(index);
                } else {
                    ++index;
                    first = next;
                }
                if (index < results.size()) {
                    next = (Multiplicity)results.get(index);
                    continue;
                }
                next = null;
            }
        }
        return results;
    }

    protected Multiplicity(boolean isOrdered, boolean isUnique) {
        this.isOrdered = isOrdered;
        this.isUnique = isUnique;
    }

    protected Multiplicity() {
        this(false, false);
    }

    public static Multiplicity getInstance(String defn, boolean isOrdered, boolean isUnique) throws MultiplicityExpressionException {
        if ((UNBOUNDED_DEFINITION.equals(defn) || "0..*".equals(defn)) && UNBOUNDED.isOrdered() == isOrdered && UNBOUNDED.isUnique() == isUnique) {
            return UNBOUNDED;
        }
        if ("0..1".equals(defn) && ZERO_OR_ONE.isOrdered() == isOrdered && ZERO_OR_ONE.isUnique() == isUnique) {
            return ZERO_OR_ONE;
        }
        if ("1".equals(defn) && ONLY_ONE.isOrdered() == isOrdered && ONLY_ONE.isUnique() == isUnique) {
            return ONLY_ONE;
        }
        if ("1..*".equals(defn) && ONE_OR_MORE.isOrdered() == isOrdered && ONE_OR_MORE.isUnique() == isUnique) {
            return ONE_OR_MORE;
        }
        List intervals = Multiplicity.parseExpression(defn, isOrdered, isUnique);
        if (intervals.size() == 1) {
            return (Multiplicity)intervals.get(0);
        }
        return new RangeMultiplicity(intervals, isOrdered, isUnique);
    }

    public static Multiplicity getInstance(String defn) throws MultiplicityExpressionException {
        List intervals = Multiplicity.parseExpression(defn, false, false);
        if (intervals.size() == 1) {
            return (Multiplicity)intervals.get(0);
        }
        return new RangeMultiplicity(intervals, false, false);
    }

    public static Multiplicity getUnboundedInstance() {
        return UNBOUNDED;
    }

    public static Multiplicity getUnboundedInstance(boolean isOrdered, boolean isUnique) {
        return new UnlimitedMultiplicity(isOrdered, isUnique);
    }

    public static Multiplicity getInstance() {
        return DEFAULT;
    }

    public static Multiplicity getInstance(int number, boolean isOrdered, boolean isUnique) {
        return new IntervalMultiplicity(number, number, isOrdered, isUnique);
    }

    public static Multiplicity getInstance(int minimum, int maximum, boolean isOrdered, boolean isUnique) {
        return new IntervalMultiplicity(minimum, maximum, isOrdered, isUnique);
    }

    public static Multiplicity getInstance(int number) {
        return new IntervalMultiplicity(number);
    }

    public static Multiplicity getInstance(int minimum, int maximum) {
        return new IntervalMultiplicity(minimum, maximum, false, false);
    }

    public abstract int getMaximum();

    public boolean isOrdered() {
        return this.isOrdered;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public abstract int getMinimum();

    public abstract boolean isIncluded(int var1);

    public abstract boolean isUnlimited();

    public abstract String toString();

    public abstract int compareTo(Object var1);

    protected int compareFlags(Multiplicity that) {
        if (this.isOrdered()) {
            if (!that.isOrdered()) {
                return -1;
            }
        } else if (that.isOrdered()) {
            return 1;
        }
        if (this.isUnique()) {
            if (!that.isUnique()) {
                return -1;
            }
        } else if (that.isUnique()) {
            return 1;
        }
        return 0;
    }

    static int compare(Multiplicity obj1, Multiplicity obj2) {
        if (obj1 instanceof UnlimitedMultiplicity) {
            return obj1.compareTo(obj2);
        }
        if (obj2 instanceof UnlimitedMultiplicity) {
            return -obj2.compareTo(obj1);
        }
        if (obj1 instanceof IntervalMultiplicity) {
            int diffInMinimum = obj1.getMinimum() - obj2.getMinimum();
            int diffInMaximum = obj1.getMaximum() - obj2.getMaximum();
            if (obj2 instanceof IntervalMultiplicity) {
                if (diffInMinimum != 0) {
                    return diffInMinimum;
                }
                return obj1.compareFlags(obj2);
            }
            if (diffInMinimum != 0) {
                return diffInMinimum;
            }
            if (diffInMaximum != 0) {
                return diffInMaximum;
            }
            return 1;
        }
        if (obj1 instanceof RangeMultiplicity) {
            if (obj2 instanceof IntervalMultiplicity) {
                return -Multiplicity.compare(obj2, obj1);
            }
            int diffInMinimum = obj1.getMinimum() - obj2.getMinimum();
            int diffInMaximum = obj1.getMaximum() - obj2.getMaximum();
            if (diffInMinimum != 0) {
                return diffInMinimum;
            }
            if (diffInMaximum != 0) {
                return diffInMaximum;
            }
            RangeMultiplicity r1 = (RangeMultiplicity)obj1;
            RangeMultiplicity r2 = (RangeMultiplicity)obj2;
            Iterator r1Iter = r1.getIntervals().iterator();
            Iterator r2Iter = r2.getIntervals().iterator();
            while (r1Iter.hasNext()) {
                IntervalMultiplicity r2Interval;
                if (!r2Iter.hasNext()) {
                    return 1;
                }
                IntervalMultiplicity r1Interval = (IntervalMultiplicity)r1Iter.next();
                int diff = r1Interval.compareTo(r2Interval = (IntervalMultiplicity)r2Iter.next());
                if (diff == 0) continue;
                return diff;
            }
            return obj1.compareFlags(obj2);
        }
        throw new IllegalArgumentException(ModelerCore.Util.getString("Multiplicity.The_multiplicity_object_is_not_a_known_subclass", obj1));
    }
}

