/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.wsdl.io;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.internal.core.xml.JdomHelper;
import com.metamatrix.metamodels.wsdl.Attribute;
import com.metamatrix.metamodels.wsdl.Binding;
import com.metamatrix.metamodels.wsdl.BindingFault;
import com.metamatrix.metamodels.wsdl.BindingInput;
import com.metamatrix.metamodels.wsdl.BindingOperation;
import com.metamatrix.metamodels.wsdl.BindingOutput;
import com.metamatrix.metamodels.wsdl.Definitions;
import com.metamatrix.metamodels.wsdl.Documentation;
import com.metamatrix.metamodels.wsdl.Element;
import com.metamatrix.metamodels.wsdl.Fault;
import com.metamatrix.metamodels.wsdl.Import;
import com.metamatrix.metamodels.wsdl.Input;
import com.metamatrix.metamodels.wsdl.Message;
import com.metamatrix.metamodels.wsdl.MessagePart;
import com.metamatrix.metamodels.wsdl.NamespaceDeclaration;
import com.metamatrix.metamodels.wsdl.NamespaceDeclarationOwner;
import com.metamatrix.metamodels.wsdl.Operation;
import com.metamatrix.metamodels.wsdl.Output;
import com.metamatrix.metamodels.wsdl.Port;
import com.metamatrix.metamodels.wsdl.PortType;
import com.metamatrix.metamodels.wsdl.Service;
import com.metamatrix.metamodels.wsdl.Types;
import com.metamatrix.metamodels.wsdl.WsdlFactory;
import com.metamatrix.metamodels.wsdl.WsdlPackage;
import com.metamatrix.metamodels.wsdl.http.HttpAddress;
import com.metamatrix.metamodels.wsdl.http.HttpBinding;
import com.metamatrix.metamodels.wsdl.http.HttpOperation;
import com.metamatrix.metamodels.wsdl.http.HttpPackage;
import com.metamatrix.metamodels.wsdl.io.WsdlConstants;
import com.metamatrix.metamodels.wsdl.mime.MimeContent;
import com.metamatrix.metamodels.wsdl.mime.MimeMultipartRelated;
import com.metamatrix.metamodels.wsdl.mime.MimePackage;
import com.metamatrix.metamodels.wsdl.mime.MimePart;
import com.metamatrix.metamodels.wsdl.soap.SoapAddress;
import com.metamatrix.metamodels.wsdl.soap.SoapBinding;
import com.metamatrix.metamodels.wsdl.soap.SoapBody;
import com.metamatrix.metamodels.wsdl.soap.SoapFault;
import com.metamatrix.metamodels.wsdl.soap.SoapHeader;
import com.metamatrix.metamodels.wsdl.soap.SoapHeaderFault;
import com.metamatrix.metamodels.wsdl.soap.SoapOperation;
import com.metamatrix.metamodels.wsdl.soap.SoapPackage;
import com.metamatrix.metamodels.wsdl.soap.SoapStyleType;
import com.metamatrix.metamodels.wsdl.soap.SoapUseType;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.DOMHandler;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSchema;
import org.jdom.Document;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.input.DOMBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.NodeList;

public class WsdlWriter
implements XMLSave,
WsdlConstants {
    public static final String ENCODING_UTF8 = "UTF-8";
    public static final String ENCODING_DEFAULT = "UTF-8";
    private String encoding;
    private String indentation;
    private boolean insertNewlines;
    private Namespace wsdlNamespace;
    private Namespace soapNamespace;
    private Namespace httpNamespace;
    private Namespace mimeNamespace;
    private boolean useSoap;
    private boolean useHttp;
    private boolean useMime;

    public void save(XMLResource resource, OutputStream outputStream, Map options) throws IOException {
        ArgCheck.isNotNull(resource);
        ArgCheck.isNotNull(outputStream);
        this.init(resource, options);
        org.jdom.Element wsdlElement = null;
        Iterator iter = resource.getContents().iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof Definitions)) continue;
            wsdlElement = this.doGenerate((Definitions)obj);
        }
        if (wsdlElement == null) {
            wsdlElement = this.doGenerate(null);
        }
        Document doc = new Document(wsdlElement);
        this.doWrite(doc, outputStream, options);
    }

    public org.w3c.dom.Document save(XMLResource resource, org.w3c.dom.Document document, Map options, DOMHandler handler) {
        throw new UnsupportedOperationException();
    }

    protected void init(XMLResource resource, Map options) {
        Object insertNewLinesValue = options.get("OPTION_INSERT_NEWLINES");
        this.insertNewlines = insertNewLinesValue == null || !Boolean.FALSE.equals(insertNewLinesValue);
        String indentationValue = (String)options.get("OPTION_INDENTATION");
        this.indentation = indentationValue != null ? indentationValue : "  ";
        this.encoding = options.containsKey("ENCODING") ? (String)options.get("ENCODING") : "UTF-8";
        TreeIterator treeIter = resource.getAllContents();
        while (treeIter.hasNext()) {
            EObject theEObject = (EObject)treeIter.next();
            EClass theEClass = theEObject.eClass();
            if (theEClass.getEPackage() == SoapPackage.eINSTANCE) {
                this.useSoap = true;
            } else if (theEClass.getEPackage() == HttpPackage.eINSTANCE) {
                this.useHttp = true;
            } else if (theEClass.getEPackage() == MimePackage.eINSTANCE) {
                this.useMime = true;
            }
            if (!this.useSoap || !this.useHttp || !this.useMime) continue;
            break;
        }
    }

    protected void doWrite(Document doc, OutputStream outputStream, Map options) throws IOException {
        Format format = JdomHelper.getFormat(this.indentation, this.insertNewlines);
        format.setEncoding(this.encoding);
        XMLOutputter outputter = new XMLOutputter(format);
        outputter.output(doc, outputStream);
    }

    protected org.jdom.Element doGenerate(Definitions defns) {
        NamespaceDeclaration nsDecl;
        NamespaceDeclaration wsdlDecl = this.doFindNamespace("http://schemas.xmlsoap.org/wsdl/", defns, true);
        Namespace namespace = this.wsdlNamespace = wsdlDecl.getPrefix() != null ? Namespace.getNamespace(wsdlDecl.getPrefix(), wsdlDecl.getUri()) : Namespace.getNamespace(wsdlDecl.getUri());
        if (this.useSoap) {
            nsDecl = this.doFindNamespace("http://schemas.xmlsoap.org/wsdl/", defns, true);
            Namespace namespace2 = this.soapNamespace = nsDecl.getPrefix() != null ? Namespace.getNamespace(nsDecl.getPrefix(), nsDecl.getUri()) : Namespace.getNamespace(nsDecl.getUri());
        }
        if (this.useHttp) {
            nsDecl = this.doFindNamespace("http://schemas.xmlsoap.org/wsdl/", defns, true);
            Namespace namespace3 = this.httpNamespace = nsDecl.getPrefix() != null ? Namespace.getNamespace(nsDecl.getPrefix(), nsDecl.getUri()) : Namespace.getNamespace(nsDecl.getUri());
        }
        if (this.useMime) {
            nsDecl = this.doFindNamespace("http://schemas.xmlsoap.org/wsdl/", defns, true);
            this.mimeNamespace = nsDecl.getPrefix() != null ? Namespace.getNamespace(nsDecl.getPrefix(), nsDecl.getUri()) : Namespace.getNamespace(nsDecl.getUri());
        }
        org.jdom.Element element = new org.jdom.Element("definitions", this.wsdlNamespace);
        element.addNamespaceDeclaration(this.wsdlNamespace);
        if (this.useSoap) {
            element.addNamespaceDeclaration(this.soapNamespace);
        }
        if (this.useHttp) {
            element.addNamespaceDeclaration(this.httpNamespace);
        }
        if (this.useMime) {
            element.addNamespaceDeclaration(this.mimeNamespace);
        }
        this.addNamespaces(defns, element);
        this.addAttribute(element, "name", this.wsdlNamespace, defns.getName());
        this.addAttribute(element, "targetNamespace", this.wsdlNamespace, defns.getTargetNamespace());
        this.doProcess(defns.getDocumentation(), element);
        this.doProcess(defns.getElements(), element);
        this.doProcess(defns.getImports(), element);
        this.doProcess(defns.getTypes(), element);
        this.doProcess(defns.getMessages(), element);
        this.doProcess(defns.getPortTypes(), element);
        this.doProcess(defns.getBindings(), element);
        this.doProcess(defns.getServices(), element);
        return element;
    }

    protected org.jdom.Element doGenerate(BindingFault bindingFault, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("fault", this.wsdlNamespace);
        this.addAttribute(element, "name", this.wsdlNamespace, bindingFault.getName());
        return element;
    }

    protected org.jdom.Element doGenerate(BindingOutput bindingOutput, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("output", this.wsdlNamespace);
        this.addAttribute(element, "name", this.wsdlNamespace, bindingOutput.getName());
        return element;
    }

    protected org.jdom.Element doGenerate(BindingInput bindingInput, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("input", this.wsdlNamespace);
        this.addAttribute(element, "name", this.wsdlNamespace, bindingInput.getName());
        return element;
    }

    protected org.jdom.Element doGenerate(BindingOperation bindingOperation, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("operation", this.wsdlNamespace);
        this.addAttribute(element, "name", this.wsdlNamespace, bindingOperation.getName());
        return element;
    }

    protected org.jdom.Element doGenerate(Fault fault, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("fault", this.wsdlNamespace);
        this.addAttribute(element, "name", this.wsdlNamespace, fault.getName());
        this.addAttribute(element, "message", this.wsdlNamespace, fault.getMessage());
        return element;
    }

    protected org.jdom.Element doGenerate(Output output, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("output", this.wsdlNamespace);
        this.addAttribute(element, "name", this.wsdlNamespace, output.getName());
        this.addAttribute(element, "message", this.wsdlNamespace, output.getMessage());
        return element;
    }

    protected org.jdom.Element doGenerate(Input input, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("input", this.wsdlNamespace);
        this.addAttribute(element, "name", this.wsdlNamespace, input.getName());
        this.addAttribute(element, "message", this.wsdlNamespace, input.getMessage());
        return element;
    }

    protected org.jdom.Element doGenerate(Operation operation, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("operation", this.wsdlNamespace);
        this.addAttribute(element, "name", this.wsdlNamespace, operation.getName());
        this.addAttribute(element, "parameterOrder", this.wsdlNamespace, operation.getParameterOrder());
        return element;
    }

    protected org.jdom.Element doGenerate(MessagePart messagePart, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("part", this.wsdlNamespace);
        this.addAttribute(element, "name", this.wsdlNamespace, messagePart.getName());
        this.addAttribute(element, "element", this.wsdlNamespace, messagePart.getElement());
        this.addAttribute(element, "type", this.wsdlNamespace, messagePart.getType());
        return element;
    }

    protected org.jdom.Element doGenerate(Types types, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("types", this.wsdlNamespace);
        return element;
    }

    protected org.jdom.Element doGenerate(Port port, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("port", this.wsdlNamespace);
        this.addAttribute(element, "name", this.wsdlNamespace, port.getName());
        this.addAttribute(element, "binding", this.wsdlNamespace, port.getBinding());
        return element;
    }

    protected org.jdom.Element doGenerate(Import import_, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("import", this.wsdlNamespace);
        this.addAttribute(element, "namespace", this.wsdlNamespace, import_.getNamespace());
        this.addAttribute(element, "location", this.wsdlNamespace, import_.getLocation());
        return element;
    }

    protected org.jdom.Element doGenerate(Service service, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("service", this.wsdlNamespace);
        this.addAttribute(element, "name", this.wsdlNamespace, service.getName());
        return element;
    }

    protected org.jdom.Element doGenerate(Binding binding, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("binding", this.wsdlNamespace);
        this.addAttribute(element, "name", this.wsdlNamespace, binding.getName());
        this.addAttribute(element, "type", this.wsdlNamespace, binding.getType());
        return element;
    }

    protected org.jdom.Element doGenerate(PortType portType, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("portType", this.wsdlNamespace);
        this.addAttribute(element, "name", this.wsdlNamespace, portType.getName());
        return element;
    }

    protected org.jdom.Element doGenerate(Message message, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("message", this.wsdlNamespace);
        this.addAttribute(element, "name", this.wsdlNamespace, message.getName());
        return element;
    }

    protected org.jdom.Element doGenerate(Documentation documentation, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("documentation", this.wsdlNamespace);
        element.setText(documentation.getTextContent());
        return element;
    }

    protected org.jdom.Element doGenerate(Attribute attribute, org.jdom.Element parentElement) {
        String uri = attribute.getNamespaceUri();
        Namespace namespace = this.findXmlNamespace(parentElement, uri);
        this.addAttribute(parentElement, attribute.getName(), namespace, attribute.getValue());
        return null;
    }

    protected org.jdom.Element doGenerate(Element element, org.jdom.Element parentElement) {
        String uri = element.getNamespaceUri();
        Namespace namespace = this.findXmlNamespace(parentElement, uri);
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        org.jdom.Element result = new org.jdom.Element(element.getName(), namespace);
        String text = element.getTextContent();
        if (text != null) {
            result.setText(text);
        }
        return result;
    }

    protected org.jdom.Element doGenerate(SoapBinding soapBinding, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("binding", this.soapNamespace);
        this.addAttribute(element, "style", null, this.getValue(soapBinding.getStyle()));
        this.addAttribute(element, "transport", null, soapBinding.getTransport());
        return element;
    }

    protected org.jdom.Element doGenerate(SoapOperation soapOperation, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("operation", this.soapNamespace);
        this.addAttribute(element, "style", null, this.getValue(soapOperation.getStyle()));
        this.addAttribute(element, "soapAction", null, soapOperation.getAction());
        return element;
    }

    protected org.jdom.Element doGenerate(SoapBody soapBody, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("body", this.soapNamespace);
        this.addAttribute(element, "encodingStyle", null, this.getStringValues(soapBody.getEncodingStyles()));
        this.addAttribute(element, "namespace", null, soapBody.getNamespace());
        this.addAttribute(element, "parts", null, this.getStringValues(soapBody.getParts()));
        this.addAttribute(element, "use", null, this.getValue(soapBody.getUse()));
        return element;
    }

    protected org.jdom.Element doGenerate(SoapHeader soapHeader, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("header", this.soapNamespace);
        this.addAttribute(element, "encodingStyle", null, this.getStringValues(soapHeader.getEncodingStyles()));
        this.addAttribute(element, "namespace", null, soapHeader.getNamespace());
        this.addAttribute(element, "message", null, soapHeader.getMessage());
        this.addAttribute(element, "parts", null, this.getStringValues(soapHeader.getParts()));
        this.addAttribute(element, "use", null, this.getValue(soapHeader.getUse()));
        return element;
    }

    protected org.jdom.Element doGenerate(SoapFault soapFault, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("fault", this.soapNamespace);
        this.addAttribute(element, "encodingStyle", null, this.getStringValues(soapFault.getEncodingStyles()));
        this.addAttribute(element, "namespace", null, soapFault.getNamespace());
        this.addAttribute(element, "use", null, this.getValue(soapFault.getUse()));
        return element;
    }

    protected org.jdom.Element doGenerate(SoapHeaderFault soapHeaderFault, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("headerfault", this.soapNamespace);
        this.addAttribute(element, "encodingStyle", null, this.getStringValues(soapHeaderFault.getEncodingStyles()));
        this.addAttribute(element, "namespace", null, soapHeaderFault.getNamespace());
        this.addAttribute(element, "message", null, soapHeaderFault.getMessage());
        this.addAttribute(element, "parts", null, this.getStringValues(soapHeaderFault.getParts()));
        this.addAttribute(element, "use", null, this.getValue(soapHeaderFault.getUse()));
        return element;
    }

    protected org.jdom.Element doGenerate(SoapAddress soapAddress, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("address", this.soapNamespace);
        this.addAttribute(element, "location", null, soapAddress.getLocation());
        return element;
    }

    protected String getStringValues(List list) {
        StringBuffer buffer = null;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof String)) continue;
            if (buffer == null) {
                buffer = new StringBuffer();
            } else {
                buffer.append(" ");
            }
            buffer.append(obj.toString());
        }
        return buffer != null ? buffer.toString() : null;
    }

    protected String getValue(SoapStyleType type) {
        if (type != null) {
            switch (type.getValue()) {
                case 1: {
                    return "document";
                }
                case 0: {
                    return "rpc";
                }
            }
        }
        return null;
    }

    protected String getValue(SoapUseType type) {
        if (type != null) {
            switch (type.getValue()) {
                case 1: {
                    return "encoded";
                }
                case 0: {
                    return "literal";
                }
            }
        }
        return null;
    }

    protected org.jdom.Element doGenerate(HttpOperation httpOperation, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("operation", this.httpNamespace);
        this.addAttribute(element, "location", null, httpOperation.getLocation());
        return element;
    }

    protected org.jdom.Element doGenerate(HttpBinding httpBinding, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("binding", this.httpNamespace);
        this.addAttribute(element, "verb", null, httpBinding.getVerb());
        return element;
    }

    protected org.jdom.Element doGenerate(HttpAddress httpAddress, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("address", this.httpNamespace);
        this.addAttribute(element, "location", null, httpAddress.getLocation());
        return element;
    }

    protected org.jdom.Element doGenerate(MimePart mimePart, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("part", this.mimeNamespace);
        return element;
    }

    protected org.jdom.Element doGenerate(MimeMultipartRelated mimeMultipartRelated, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("multipartRelated", this.mimeNamespace);
        return element;
    }

    protected org.jdom.Element doGenerate(MimeContent mimeContent, org.jdom.Element parentElement) {
        org.jdom.Element element = new org.jdom.Element("content", this.mimeNamespace);
        if (mimeContent.getMessagePart() != null) {
            this.addAttribute(element, "part", null, mimeContent.getMessagePart().getName());
        }
        return element;
    }

    protected org.jdom.Element doGenerate(XSDSchema schema, org.jdom.Element parentElement) {
        NodeList typesList;
        schema.updateElement(true);
        org.w3c.dom.Document domDoc = schema.getDocument();
        if (domDoc == null || domDoc.getDocumentElement() == null) {
            return null;
        }
        org.w3c.dom.Element schemaDomElement = null;
        String[] schemaNS = new String[]{"http://www.w3.org/2001/XMLSchema", "http://www.w3.org/2000/10/XMLSchema", "http://www.w3.org/1999/XMLSchema"};
        org.w3c.dom.Element rootElement = domDoc.getDocumentElement();
        String elementNsUri = rootElement.getNamespaceURI();
        String elementLocalName = rootElement.getLocalName();
        for (int i2 = 0; i2 != schemaNS.length; ++i2) {
            if (!schemaNS[i2].equals(elementNsUri) || !"schema".equals(elementLocalName)) continue;
            schemaDomElement = rootElement;
            break;
        }
        if (schemaDomElement == null && (typesList = rootElement.getElementsByTagName("types")) != null && typesList.getLength() != 0) {
            org.w3c.dom.Element typesElement = (org.w3c.dom.Element)typesList.item(0);
            for (int i3 = 0; i3 != schemaNS.length; ++i3) {
                NodeList typesChildren = typesElement.getElementsByTagNameNS(schemaNS[i3], "schema");
                if (typesChildren == null || typesChildren.getLength() == 0) continue;
                schemaDomElement = (org.w3c.dom.Element)typesChildren.item(0);
                break;
            }
        }
        if (schemaDomElement == null) {
            return null;
        }
        DOMBuilder builder = new DOMBuilder();
        org.jdom.Element schemaElement = builder.build(schemaDomElement);
        Document doc = schemaElement.getDocument();
        Parent parent = schemaElement.getParent();
        if (parent != null) {
            parent.removeContent(schemaElement);
        }
        doc.setRootElement(new org.jdom.Element("bogus"));
        return schemaElement;
    }

    protected void doProcessContents(EObject parent, org.jdom.Element parentElement) {
        Iterator iter = parent.eContents().iterator();
        while (iter.hasNext()) {
            EObject theEObject = (EObject)iter.next();
            this.doProcess(theEObject, parentElement);
        }
    }

    protected void doProcess(List children, org.jdom.Element parentElement) {
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            EObject theEObject = (EObject)iter.next();
            this.doProcess(theEObject, parentElement);
        }
    }

    protected void doProcess(EObject theEObject, org.jdom.Element parentElement) {
        if (theEObject == null) {
            return;
        }
        boolean processContentDone = false;
        EClass theEClass = theEObject.eClass();
        org.jdom.Element result = null;
        if (theEClass.eContainer() == WsdlPackage.eINSTANCE) {
            switch (theEClass.getClassifierID()) {
                case 1: {
                    Documentation documentation = (Documentation)theEObject;
                    result = this.doGenerate(documentation, parentElement);
                    this.doProcess(documentation.getDeclaredNamespaces(), result);
                    this.doProcess(documentation.getElements(), result);
                    processContentDone = true;
                    break;
                }
                case 4: {
                    Attribute attribute = (Attribute)theEObject;
                    result = this.doGenerate(attribute, parentElement);
                    break;
                }
                case 5: {
                    Message message = (Message)theEObject;
                    result = this.doGenerate(message, parentElement);
                    this.doProcess(message.getDeclaredNamespaces(), result);
                    this.doProcess(message.getDocumentation(), result);
                    this.doProcess(message.getElements(), result);
                    this.doProcess(message.getParts(), result);
                    processContentDone = true;
                    break;
                }
                case 6: {
                    PortType portType = (PortType)theEObject;
                    result = this.doGenerate(portType, parentElement);
                    this.doProcess(portType.getDeclaredNamespaces(), result);
                    this.doProcess(portType.getDocumentation(), result);
                    this.doProcess(portType.getAttributes(), result);
                    this.doProcess(portType.getOperations(), result);
                    processContentDone = true;
                    break;
                }
                case 7: {
                    Binding binding = (Binding)theEObject;
                    result = this.doGenerate(binding, parentElement);
                    this.doProcess(binding.getDeclaredNamespaces(), result);
                    this.doProcess(binding.getDocumentation(), result);
                    this.doProcess(binding.getSoapBinding(), result);
                    this.doProcess(binding.getHttpBinding(), result);
                    this.doProcess(binding.getElements(), result);
                    this.doProcess(binding.getBindingOperations(), result);
                    processContentDone = true;
                    break;
                }
                case 8: {
                    Service service = (Service)theEObject;
                    result = this.doGenerate(service, parentElement);
                    this.doProcess(service.getDeclaredNamespaces(), result);
                    this.doProcess(service.getDocumentation(), result);
                    this.doProcess(service.getElements(), result);
                    this.doProcess(service.getPorts(), result);
                    processContentDone = true;
                    break;
                }
                case 9: {
                    Import import_ = (Import)theEObject;
                    result = this.doGenerate(import_, parentElement);
                    this.doProcess(import_.getDeclaredNamespaces(), result);
                    this.doProcess(import_.getDocumentation(), result);
                    this.doProcess(import_.getAttributes(), result);
                    processContentDone = true;
                    break;
                }
                case 10: {
                    Port port = (Port)theEObject;
                    result = this.doGenerate(port, parentElement);
                    this.doProcess(port.getDeclaredNamespaces(), result);
                    this.doProcess(port.getDocumentation(), result);
                    this.doProcess(port.getSoapAddress(), result);
                    this.doProcess(port.getHttpAddress(), result);
                    this.doProcess(port.getElements(), result);
                    processContentDone = true;
                    break;
                }
                case 11: {
                    Element element = (Element)theEObject;
                    result = this.doGenerate(element, parentElement);
                    break;
                }
                case 15: {
                    Types types = (Types)theEObject;
                    result = this.doGenerate(types, parentElement);
                    this.doProcess(types.getDeclaredNamespaces(), result);
                    this.doProcess(types.getDocumentation(), result);
                    this.doProcess(types.getElements(), result);
                    this.doProcess(types.getSchemas(), result);
                    processContentDone = true;
                    break;
                }
                case 16: {
                    MessagePart messagePart = (MessagePart)theEObject;
                    result = this.doGenerate(messagePart, parentElement);
                    this.doProcess(messagePart.getDeclaredNamespaces(), result);
                    this.doProcess(messagePart.getDocumentation(), result);
                    this.doProcess(messagePart.getAttributes(), result);
                    processContentDone = true;
                    break;
                }
                case 18: {
                    Operation operation = (Operation)theEObject;
                    result = this.doGenerate(operation, parentElement);
                    this.doProcess(operation.getDocumentation(), result);
                    if (operation.getInput() != null) {
                        this.doProcess(operation.getInput(), result);
                        this.doProcess(operation.getOutput(), result);
                    } else {
                        this.doProcess(operation.getOutput(), result);
                    }
                    this.doProcess(operation.getFaults(), result);
                    processContentDone = true;
                    break;
                }
                case 19: {
                    Input input = (Input)theEObject;
                    result = this.doGenerate(input, parentElement);
                    this.doProcess(input.getDeclaredNamespaces(), result);
                    this.doProcess(input.getDocumentation(), result);
                    this.doProcess(input.getAttributes(), result);
                    processContentDone = true;
                    break;
                }
                case 20: {
                    Output output = (Output)theEObject;
                    result = this.doGenerate(output, parentElement);
                    this.doProcess(output.getDeclaredNamespaces(), result);
                    this.doProcess(output.getDocumentation(), result);
                    this.doProcess(output.getAttributes(), result);
                    processContentDone = true;
                    break;
                }
                case 21: {
                    Fault fault = (Fault)theEObject;
                    result = this.doGenerate(fault, parentElement);
                    this.doProcess(fault.getDeclaredNamespaces(), result);
                    this.doProcess(fault.getDocumentation(), result);
                    this.doProcess(fault.getAttributes(), result);
                    processContentDone = true;
                    break;
                }
                case 24: {
                    BindingOperation bindingOperation = (BindingOperation)theEObject;
                    result = this.doGenerate(bindingOperation, parentElement);
                    this.doProcess(bindingOperation.getDeclaredNamespaces(), result);
                    this.doProcess(bindingOperation.getDocumentation(), result);
                    this.doProcess(bindingOperation.getSoapOperation(), result);
                    this.doProcess(bindingOperation.getHttpOperation(), result);
                    this.doProcess(bindingOperation.getElements(), result);
                    this.doProcess(bindingOperation.getBindingInput(), result);
                    this.doProcess(bindingOperation.getBindingOutput(), result);
                    this.doProcess(bindingOperation.getBindingFaults(), result);
                    processContentDone = true;
                    break;
                }
                case 25: {
                    BindingInput bindingInput = (BindingInput)theEObject;
                    result = this.doGenerate(bindingInput, parentElement);
                    this.doProcess(bindingInput.getDeclaredNamespaces(), result);
                    this.doProcess(bindingInput.getDocumentation(), result);
                    this.doProcess(bindingInput.getSoapHeader(), result);
                    this.doProcess(bindingInput.getSoapBody(), result);
                    this.doProcess(bindingInput.getMimeElements(), result);
                    this.doProcess(bindingInput.getElements(), result);
                    processContentDone = true;
                    break;
                }
                case 26: {
                    BindingOutput bindingOutput = (BindingOutput)theEObject;
                    result = this.doGenerate(bindingOutput, parentElement);
                    this.doProcess(bindingOutput.getDeclaredNamespaces(), result);
                    this.doProcess(bindingOutput.getDocumentation(), result);
                    this.doProcess(bindingOutput.getSoapHeader(), result);
                    this.doProcess(bindingOutput.getSoapBody(), result);
                    this.doProcess(bindingOutput.getMimeElements(), result);
                    this.doProcess(bindingOutput.getElements(), result);
                    processContentDone = true;
                    break;
                }
                case 27: {
                    BindingFault bindingFault = (BindingFault)theEObject;
                    result = this.doGenerate(bindingFault, parentElement);
                    this.doProcess(bindingFault.getDeclaredNamespaces(), result);
                    this.doProcess(bindingFault.getDocumentation(), result);
                    this.doProcess(bindingFault.getSoapFault(), result);
                    this.doProcess(bindingFault.getElements(), result);
                    processContentDone = true;
                    break;
                }
            }
        } else if (theEClass.eContainer() == SoapPackage.eINSTANCE) {
            switch (theEClass.getClassifierID()) {
                case 0: {
                    SoapAddress soapAddress = (SoapAddress)theEObject;
                    result = this.doGenerate(soapAddress, parentElement);
                    break;
                }
                case 1: {
                    SoapHeaderFault soapHeaderFault = (SoapHeaderFault)theEObject;
                    result = this.doGenerate(soapHeaderFault, parentElement);
                    break;
                }
                case 2: {
                    SoapFault soapFault = (SoapFault)theEObject;
                    result = this.doGenerate(soapFault, parentElement);
                    break;
                }
                case 3: {
                    SoapHeader soapHeader = (SoapHeader)theEObject;
                    result = this.doGenerate(soapHeader, parentElement);
                    break;
                }
                case 4: {
                    SoapBody soapBody = (SoapBody)theEObject;
                    result = this.doGenerate(soapBody, parentElement);
                    break;
                }
                case 5: {
                    SoapOperation soapOperation = (SoapOperation)theEObject;
                    result = this.doGenerate(soapOperation, parentElement);
                    break;
                }
                case 6: {
                    SoapBinding soapBinding = (SoapBinding)theEObject;
                    result = this.doGenerate(soapBinding, parentElement);
                    break;
                }
            }
        } else if (theEClass.eContainer() == HttpPackage.eINSTANCE) {
            switch (theEClass.getClassifierID()) {
                case 0: {
                    HttpAddress httpAddress = (HttpAddress)theEObject;
                    result = this.doGenerate(httpAddress, parentElement);
                    break;
                }
                case 1: {
                    HttpBinding httpBinding = (HttpBinding)theEObject;
                    result = this.doGenerate(httpBinding, parentElement);
                    break;
                }
                case 2: {
                    HttpOperation httpOperation = (HttpOperation)theEObject;
                    result = this.doGenerate(httpOperation, parentElement);
                    break;
                }
            }
        } else if (theEClass.eContainer() == MimePackage.eINSTANCE) {
            switch (theEClass.getClassifierID()) {
                case 0: {
                    MimeContent mimeContent = (MimeContent)theEObject;
                    result = this.doGenerate(mimeContent, parentElement);
                    break;
                }
                case 1: {
                    MimeMultipartRelated mimeMultipartRelated = (MimeMultipartRelated)theEObject;
                    result = this.doGenerate(mimeMultipartRelated, parentElement);
                    break;
                }
                case 2: {
                    MimePart mimePart = (MimePart)theEObject;
                    result = this.doGenerate(mimePart, parentElement);
                    break;
                }
            }
        } else if (theEClass.eContainer() == XSDPackage.eINSTANCE) {
            switch (theEClass.getClassifierID()) {
                case 45: {
                    XSDSchema schema = (XSDSchema)theEObject;
                    result = this.doGenerate(schema, parentElement);
                    break;
                }
            }
        }
        if (result != null) {
            parentElement.addContent(result);
        }
        if (!processContentDone) {
            org.jdom.Element parentElementForChildren = parentElement;
            if (result != null) {
                parentElementForChildren = result;
            }
            this.doProcessContents(theEObject, parentElementForChildren);
        }
    }

    protected void addNamespaces(NamespaceDeclarationOwner owner, org.jdom.Element element) {
        HashMap<String, Namespace> existingNamespaces = new HashMap<String, Namespace>();
        List existingDeclarations = element.getAdditionalNamespaces();
        Iterator iter = existingDeclarations.iterator();
        while (iter.hasNext()) {
            Namespace namespace = (Namespace)iter.next();
            existingNamespaces.put(namespace.getURI(), namespace);
        }
        Iterator iter2 = owner.getDeclaredNamespaces().iterator();
        while (iter2.hasNext()) {
            NamespaceDeclaration nsDecl = (NamespaceDeclaration)iter2.next();
            String prefix = nsDecl.getPrefix();
            String uri = nsDecl.getUri();
            Namespace namespace = (Namespace)existingNamespaces.get(uri);
            if (namespace == null && uri != null && uri.trim().length() != 0) {
                namespace = prefix != null ? Namespace.getNamespace(prefix, uri) : Namespace.getNamespace(uri);
                element.addNamespaceDeclaration(namespace);
                existingNamespaces.put(uri, namespace);
            }
            if ("http://schemas.xmlsoap.org/wsdl/".equals(uri)) {
                this.wsdlNamespace = namespace;
                continue;
            }
            if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(uri)) {
                this.soapNamespace = namespace;
                continue;
            }
            if ("http://schemas.xmlsoap.org/wsdl/http/".equals(uri)) {
                this.httpNamespace = namespace;
                continue;
            }
            if (!"http://schemas.xmlsoap.org/wsdl/mime/".equals(uri)) continue;
            this.mimeNamespace = namespace;
        }
    }

    protected Namespace findXmlNamespace(org.jdom.Element element, String uri) {
        Iterator iter = element.getAdditionalNamespaces().iterator();
        while (iter.hasNext()) {
            Namespace ns = (Namespace)iter.next();
            if (!uri.equals(ns.getURI())) continue;
            return ns;
        }
        Parent parent = element.getParent();
        if (parent != null && parent instanceof org.jdom.Element) {
            return this.findXmlNamespace((org.jdom.Element)parent, uri);
        }
        return null;
    }

    protected NamespaceDeclaration doFindNamespace(String uri, NamespaceDeclarationOwner owner, boolean createIfRequired) {
        NamespaceDeclaration nsDecl;
        if (uri == null) {
            return null;
        }
        boolean foundDefaultNamespace = false;
        Iterator iter = owner.getDeclaredNamespaces().iterator();
        while (iter.hasNext()) {
            nsDecl = (NamespaceDeclaration)iter.next();
            if (uri.equals(nsDecl.getUri())) {
                return nsDecl;
            }
            String prefix = nsDecl.getPrefix();
            if (prefix != null && prefix.trim().length() != 0) continue;
            foundDefaultNamespace = true;
        }
        if (createIfRequired) {
            nsDecl = WsdlFactory.eINSTANCE.createNamespaceDeclaration();
            nsDecl.setUri(uri);
            if ("http://schemas.xmlsoap.org/wsdl/".equals(uri)) {
                if (foundDefaultNamespace) {
                    nsDecl.setPrefix("wsdl");
                }
            } else if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(uri)) {
                nsDecl.setPrefix("soap");
            } else if ("http://schemas.xmlsoap.org/wsdl/http/".equals(uri)) {
                nsDecl.setPrefix("http");
            } else if ("http://schemas.xmlsoap.org/wsdl/mime/".equals(uri)) {
                nsDecl.setPrefix("mime");
            }
            return nsDecl;
        }
        return null;
    }

    protected org.jdom.Attribute addAttribute(org.jdom.Element element, String name, Namespace namespace, String value) {
        return this.addAttribute(element, name, namespace, value, false);
    }

    protected org.jdom.Attribute addAttribute(org.jdom.Element element, String name, Namespace namespace, String value, boolean forceIfNullOrZeroLength) {
        String newValue;
        String string = newValue = value != null && value.trim().length() != 0 ? value.trim() : null;
        if (forceIfNullOrZeroLength || newValue != null) {
            String v2 = newValue == null ? "" : newValue;
            Namespace theNamespace = Namespace.NO_NAMESPACE;
            if (namespace != null && namespace.getPrefix() != null && namespace.getPrefix().trim().length() != 0) {
                theNamespace = namespace;
                String uri = namespace.getURI();
                if ("http://schemas.xmlsoap.org/wsdl/".equals(uri)) {
                    theNamespace = Namespace.NO_NAMESPACE;
                } else if ("http://schemas.xmlsoap.org/wsdl/soap/".equals(uri)) {
                    theNamespace = Namespace.NO_NAMESPACE;
                } else if ("http://schemas.xmlsoap.org/wsdl/http/".equals(uri)) {
                    theNamespace = Namespace.NO_NAMESPACE;
                } else if ("http://schemas.xmlsoap.org/wsdl/mime/".equals(uri)) {
                    theNamespace = Namespace.NO_NAMESPACE;
                }
            }
            org.jdom.Attribute attribute = theNamespace != Namespace.NO_NAMESPACE ? new org.jdom.Attribute(name, v2, theNamespace) : new org.jdom.Attribute(name, v2);
            element.setAttribute(attribute);
            return attribute;
        }
        return null;
    }

    public org.w3c.dom.Document toDOM(XMLResource resource, org.w3c.dom.Document document, DOMHandler handler, Map options) {
        throw new UnsupportedOperationException();
    }
}

