/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.wsdl.io;

import com.metamatrix.common.protocol.URLHelper;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.xml.SAXBuilderHelper;
import com.metamatrix.metamodels.wsdl.io.WsdlConstants;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class WsdlHelper
extends XMLHelperImpl
implements WsdlConstants,
WsdlConstants.Xsd {
    public static ArrayList convertImportsToAbsolutePaths(File wsdlFile, String absPath, ArrayList fileArray, Map urlMap, boolean addToArray) throws JDOMException, IOException {
        URI absoluteUri = URI.create(absPath);
        SAXBuilder builder = SAXBuilderHelper.createSAXBuilder(false);
        Document wsdlDocument = builder.build(wsdlFile);
        Element root = wsdlDocument.getRootElement();
        List wsdlElements = root.getContent();
        Iterator iter = wsdlElements.iterator();
        while (iter.hasNext()) {
            String location;
            Element importElement;
            Object importObject = iter.next();
            if (!(importObject instanceof Element) || !(importElement = (Element)importObject).getName().equals("import") || importElement.getName().equals("include") || (location = importElement.getAttributeValue("location")) == null) continue;
            URI uri = URI.create(location);
            URI resolvedUri = absoluteUri.resolve(uri);
            File file = URLHelper.createFileFromUrl((URL)resolvedUri.toURL(), (String)StringUtil.createFileName(uri.getPath()), (String)".wsdl");
            String path = "file:/" + file.getAbsolutePath();
            importElement.setAttribute("location", path);
            urlMap.put(file.getAbsolutePath(), resolvedUri.toString());
            WsdlHelper.convertImportsToAbsolutePaths(file, resolvedUri.toString(), fileArray, urlMap, false);
        }
        wsdlElements = root.getContent();
        iter = wsdlElements.iterator();
        while (iter.hasNext()) {
            Element typesElement;
            Object typesObject = iter.next();
            if (!(typesObject instanceof Element) || !(typesElement = (Element)typesObject).getName().equals("types")) continue;
            List schemaElements = typesElement.getContent();
            iter = schemaElements.iterator();
            while (iter.hasNext()) {
                Element schemaElement;
                Object schemaObject = iter.next();
                if (!(schemaObject instanceof Element) || !(schemaElement = (Element)schemaObject).getName().equals("schema")) continue;
                List importElements = schemaElement.getContent();
                iter = importElements.iterator();
                while (iter.hasNext()) {
                    String schemaLocation;
                    Element importElement;
                    Object importObject = iter.next();
                    if (!(importObject instanceof Element) || !(importElement = (Element)importObject).getName().equals("import") || importElement.getName().equals("include") || (schemaLocation = importElement.getAttributeValue("schemaLocation")) == null) continue;
                    URI uri = URI.create(schemaLocation);
                    uri = URI.create(schemaLocation);
                    URI newUri = null;
                    newUri = absoluteUri.resolve(uri);
                    importElement.setAttribute("schemaLocation", newUri.toString());
                }
            }
        }
        if (addToArray) {
            fileArray.add(wsdlFile);
        }
        WsdlHelper.writeDocument(wsdlDocument, wsdlFile);
        return fileArray;
    }

    private static void writeDocument(Document doc, File file) throws JDOMException, IOException {
        XMLOutputter out = new XMLOutputter();
        FileWriter writer = new FileWriter(file);
        out.output(doc, (Writer)writer);
        writer.flush();
        writer.close();
    }
}

