/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.relational.aspects.validation.rules;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.RelationalPlugin;
import com.metamatrix.metamodels.relational.Table;
import com.metamatrix.modeler.core.validation.ObjectValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class TableChildrenUpdatabilityRule
implements ObjectValidationRule {
    static /* synthetic */ Class class$com$metamatrix$metamodels$relational$Table;

    public void validate(EObject eObject, ValidationContext context) {
        ArgCheck.isInstanceOf(class$com$metamatrix$metamodels$relational$Table == null ? (class$com$metamatrix$metamodels$relational$Table = TableChildrenUpdatabilityRule.class$("com.metamatrix.metamodels.relational.Table")) : class$com$metamatrix$metamodels$relational$Table, eObject);
        Table table = (Table)eObject;
        if (!table.isSupportsUpdate()) {
            return;
        }
        EList columns = table.getColumns();
        if (!columns.isEmpty()) {
            Iterator columnIter = columns.iterator();
            boolean hasUpdatableColumn = false;
            while (columnIter.hasNext()) {
                Column column = (Column)columnIter.next();
                if (!column.isUpdateable()) continue;
                hasUpdatableColumn = true;
            }
            if (!hasUpdatableColumn) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, this.getProblemMessage(table));
                ValidationResultImpl result = new ValidationResultImpl(eObject);
                result.addProblem(problem);
                context.addResult(result);
            }
        }
    }

    protected String getProblemMessage(Table tableObject) {
        return RelationalPlugin.Util.getString("TableChildrenUpdatabilityRule.The_table_{0},_is_updatable_but_does_not_have_any_updatable_columns._1", tableObject.getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

