/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.relational.aspects.validation.rules;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.relational.Column;
import com.metamatrix.metamodels.relational.ForeignKey;
import com.metamatrix.metamodels.relational.RelationalPlugin;
import com.metamatrix.metamodels.relational.UniqueKey;
import com.metamatrix.modeler.core.validation.ObjectValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class ForeignKeyColumnsRule
implements ObjectValidationRule {
    static /* synthetic */ Class class$com$metamatrix$metamodels$relational$ForeignKey;

    public void validate(EObject eObject, ValidationContext context) {
        ArgCheck.isInstanceOf(class$com$metamatrix$metamodels$relational$ForeignKey == null ? (class$com$metamatrix$metamodels$relational$ForeignKey = ForeignKeyColumnsRule.class$("com.metamatrix.metamodels.relational.ForeignKey")) : class$com$metamatrix$metamodels$relational$ForeignKey, eObject);
        ForeignKey foreignKey = (ForeignKey)eObject;
        UniqueKey uniqueKey = foreignKey.getUniqueKey();
        if (uniqueKey == null) {
            return;
        }
        EList fkColumns = foreignKey.getColumns();
        EList ukColumns = uniqueKey.getColumns();
        int numFkColumns = fkColumns.size();
        int numUkColumns = ukColumns.size();
        if (numFkColumns == 0 || numUkColumns == 0) {
            return;
        }
        if (numFkColumns != numUkColumns) {
            ValidationResultImpl result = new ValidationResultImpl(eObject);
            String msg = RelationalPlugin.Util.getString("ForeignKeyColumnsRule.The_number_of_columns_on_the_foreignkey__1") + foreignKey.getName() + RelationalPlugin.Util.getString("ForeignKeyColumnsRule._do_not_match_the_number_of_columns_on_the_referenced_uniquekey__2") + uniqueKey.getName();
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem(problem);
            context.addResult(result);
            return;
        }
        Iterator fkColIter = fkColumns.iterator();
        Iterator ukColIter = ukColumns.iterator();
        while (fkColIter.hasNext() && ukColIter.hasNext()) {
            Column fkColumn = (Column)fkColIter.next();
            Column ukColumn = (Column)ukColIter.next();
            EObject fkType = fkColumn.getType();
            EObject ukType = ukColumn.getType();
            if (fkType == null || ukType == null) {
                return;
            }
            if (fkType.equals(ukType)) continue;
            ValidationResultImpl result = new ValidationResultImpl(eObject);
            String msg = RelationalPlugin.Util.getString("ForeignKeyColumnsRule.The_datatype_of_the_column__3") + fkColumn.getName() + RelationalPlugin.Util.getString("ForeignKeyColumnsRule._on_the_foreignKey__4") + foreignKey.getName() + RelationalPlugin.Util.getString("ForeignKeyColumnsRule._doesn__t_match_the_that_of_the__5") + ukColumn.getName() + RelationalPlugin.Util.getString("ForeignKeyColumnsRule._on_the_referenced_uniquekey__6") + uniqueKey.getName();
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 2, msg);
            result.addProblem(problem);
            context.addResult(result);
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

