/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.function.aspects.validation.rules;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.core.Annotation;
import com.metamatrix.metamodels.function.FunctionPlugin;
import com.metamatrix.metamodels.function.PushDownType;
import com.metamatrix.metamodels.function.ReturnParameter;
import com.metamatrix.metamodels.function.ScalarFunction;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.validation.ObjectValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.core.validation.ValidationResult;
import com.metamatrix.modeler.core.validation.rules.CoreValidationRulesUtil;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import org.eclipse.emf.ecore.EObject;

public class ScalarFunctionRule
implements ObjectValidationRule {
    static /* synthetic */ Class class$com$metamatrix$metamodels$function$ScalarFunction;

    public void validate(EObject eObject, ValidationContext context) {
        ArgCheck.isInstanceOf(class$com$metamatrix$metamodels$function$ScalarFunction == null ? (class$com$metamatrix$metamodels$function$ScalarFunction = ScalarFunctionRule.class$("com.metamatrix.metamodels.function.ScalarFunction")) : class$com$metamatrix$metamodels$function$ScalarFunction, eObject);
        ValidationResultImpl result = new ValidationResultImpl(eObject);
        ScalarFunction sFunction = (ScalarFunction)eObject;
        this.validateName(sFunction, result);
        this.validateReturnParameter(sFunction.getReturnParameter(), result);
        String invocationClass = sFunction.getInvocationClass();
        if (StringUtil.isEmpty(invocationClass) && !sFunction.getPushDown().equals(PushDownType.REQUIRED_LITERAL)) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, FunctionPlugin.Util.getString("ScalarFunctionRule.Invocation_class_must_be_specified_on_a_scalar_function._1"));
            result.addProblem(problem);
        } else {
            this.validateJavaIdentifier(invocationClass, FunctionPlugin.Util.getString("ScalarFunctionRule.Invocation_class_3"), true, result);
        }
        String invocationMethod = sFunction.getInvocationMethod();
        if (StringUtil.isEmpty(invocationMethod) && !sFunction.getPushDown().equals(PushDownType.REQUIRED_LITERAL)) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, FunctionPlugin.Util.getString("ScalarFunctionRule.Invocation_method_must_be_specified_on_a_scalar_function._2"));
            result.addProblem(problem);
        } else {
            this.validateJavaIdentifier(invocationMethod, FunctionPlugin.Util.getString("ScalarFunctionRule.Invocation_Method_4"), false, result);
        }
        String category = sFunction.getCategory();
        if (StringUtil.isEmpty(category)) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, FunctionPlugin.Util.getString("ScalarFunctionRule.Category_can_not_be_null_or_empty"));
            result.addProblem(problem);
        } else {
            this.validateLength(category, FunctionPlugin.Util.getString("ScalarFunctionRule.Category_5"), result);
        }
        try {
            Annotation annotation = ModelerCore.getModelEditor().getAnnotation(sFunction, false);
            if (annotation != null) {
                this.validateLength(annotation.getDescription(), FunctionPlugin.Util.getString("ScalarFunctionRule.Description_1"), result);
            }
        }
        catch (ModelerCoreException e2) {
            ModelerCore.Util.log(4, e2, FunctionPlugin.Util.getString("ScalarFunctionRule.Error_trying_to_lookup_model_annotation_for_the_function_{0}._2", sFunction.getName()));
        }
        context.addResult(result);
    }

    private void validateName(ScalarFunction sFunction, ValidationResult result) {
        String name = sFunction.getName();
        char[] invalidChars = null;
        CoreValidationRulesUtil.validateStringNameChars(result, name, invalidChars);
    }

    private final void validateReturnParameter(ReturnParameter rParam, ValidationResult result) {
        if (rParam != null) {
            String paramType = rParam.getType();
            if (StringUtil.isEmpty(paramType)) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, FunctionPlugin.Util.getString("ScalarFunctionRule.Type_should_be_specified_on_the_return_parameter_of_a_scalar_function._7"));
                result.addProblem(problem);
            }
            this.validateJavaIdentifier(paramType, FunctionPlugin.Util.getString("ScalarFunctionRule.Return_Parameter_8"), true, result);
        }
    }

    private final void validateJavaIdentifier(String identifier, String strName, boolean allowMultiple, ValidationResult result) {
        if (!StringUtil.isEmpty(identifier)) {
            char firstChar = identifier.charAt(0);
            if (!Character.isJavaIdentifierStart(firstChar)) {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, strName + FunctionPlugin.Util.getString("ScalarFunctionRule._has_invalid_first_character___10") + firstChar);
                result.addProblem(problem);
            }
            for (int i2 = 1; i2 < identifier.length(); ++i2) {
                char ch = identifier.charAt(i2);
                if (Character.isJavaIdentifierPart(ch) || allowMultiple && ch == '.') continue;
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, strName + FunctionPlugin.Util.getString("ScalarFunctionRule._has_invalid_character___11") + firstChar);
                result.addProblem(problem);
            }
            if (identifier.charAt(identifier.length() - 1) == '.') {
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, strName + FunctionPlugin.Util.getString("ScalarFunctionRule._cannot_end_with_a___.___13"));
                result.addProblem(problem);
            }
        }
    }

    private final void validateLength(String string, String strName, ValidationResult result) {
        if (string != null && string.length() > 128) {
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, strName + FunctionPlugin.Util.getString("ScalarFunctionRule._exceeds_maximum_length_of___9") + 128);
            result.addProblem(problem);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

