/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.function.aspects.validation.rules;

import com.metamatrix.metamodels.function.FunctionPlugin;
import com.metamatrix.metamodels.function.ScalarFunction;
import com.metamatrix.modeler.core.validation.ObjectValidationRule;
import com.metamatrix.modeler.core.validation.ValidationContext;
import com.metamatrix.modeler.internal.core.validation.ValidationProblemImpl;
import com.metamatrix.modeler.internal.core.validation.ValidationResultImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public abstract class FunctionEntityUniquenessRule
implements ObjectValidationRule {
    private final String ruleName = this.getClass().getName();

    public void validate(EObject eObject, ValidationContext context) {
        String signature;
        if (context.hasRunRule(eObject, this.ruleName)) {
            return;
        }
        List siblings = this.getSiblingsForUniquenessCheck(eObject);
        if (siblings.size() < 2) {
            return;
        }
        HashMap siblingsBySignature = new HashMap();
        Iterator iter = siblings.iterator();
        while (iter.hasNext()) {
            EObject sibling = (EObject)iter.next();
            if (!(sibling instanceof ScalarFunction)) continue;
            signature = this.computeSignature(sibling);
            LinkedList<EObject> existing = (LinkedList<EObject>)siblingsBySignature.get(signature);
            if (existing == null) {
                existing = new LinkedList<EObject>();
                siblingsBySignature.put(signature, existing);
            }
            if (existing.contains(sibling)) continue;
            existing.add(sibling);
        }
        Iterator iterator = siblingsBySignature.keySet().iterator();
        while (iterator.hasNext()) {
            signature = (String)iterator.next();
            List siblingsWithSameSignature = (List)siblingsBySignature.get(signature);
            int numSiblingsWithSameSignature = siblingsWithSameSignature.size();
            if (numSiblingsWithSameSignature <= 1) continue;
            Iterator siblingIter = siblingsWithSameSignature.iterator();
            while (siblingIter.hasNext()) {
                EObject sibling = (EObject)siblingIter.next();
                ValidationResultImpl result = new ValidationResultImpl(sibling);
                String msg = this.getDuplicateMessage(numSiblingsWithSameSignature, signature);
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
                result.addProblem(problem);
                context.addResult(result);
            }
        }
        context.recordRuleRun(eObject, this.ruleName);
    }

    protected abstract String computeSignature(EObject var1);

    protected String getDuplicateMessage(int numDuplicates, String signature) {
        Object[] params = new Object[]{new Integer(numDuplicates - 1), signature};
        String msg = FunctionPlugin.Util.getString("FunctionEntityUniquenessRule.Same_signature_as_{0}_sibling(s)__{1}", params);
        return msg;
    }

    protected List getSiblingsForUniquenessCheck(EObject eObject) {
        EObject parent = eObject.eContainer();
        if (parent != null) {
            return parent.eContents();
        }
        Resource resource = eObject.eResource();
        if (resource != null) {
            return resource.getContents();
        }
        return new ArrayList(1);
    }
}

