/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.core.util;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.AssertionException;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.core.CoreMetamodelPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;

public class UriValidator {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(class$com$metamatrix$metamodels$core$util$UriValidator == null ? (class$com$metamatrix$metamodels$core$util$UriValidator = UriValidator.class$("com.metamatrix.metamodels.core.util.UriValidator")) : class$com$metamatrix$metamodels$core$util$UriValidator);
    private static final String URI_COMPONENTS_PREFIX = "uricomponents.";
    private static final String URI_LABEL = CoreMetamodelPlugin.Util.getString(PREFIX + "uri");
    private static final int INVALID_FACTOR = -1;
    static /* synthetic */ Class class$com$metamatrix$metamodels$core$util$UriValidator;

    private static String createNullValueMessage(String theComponent) {
        return CoreMetamodelPlugin.Util.getString(PREFIX + "nullValue", theComponent);
    }

    private static IStatus createStatus(String theComponent, String theValue, boolean theIsValidFlag) {
        return new Status(UriValidator.getSeverity(theIsValidFlag), "com.metamatrix.metamodels.core", UriValidator.getCode(theComponent, theIsValidFlag), UriValidator.createValidationMessage(theComponent, theValue, theIsValidFlag), null);
    }

    private static String createValidationMessage(String theComponent, String theValue, boolean theIsValidFlag) {
        if (theIsValidFlag) {
            return CoreMetamodelPlugin.Util.getString(PREFIX + "componentValid", new Object[]{theComponent, theValue});
        }
        return CoreMetamodelPlugin.Util.getString(PREFIX + "componentNotValid", new Object[]{theComponent, theValue});
    }

    private static int getCode(String theComponent, boolean theIsValidFlag) {
        int result = 1;
        if (URI_LABEL.equals(theComponent)) {
            result = 1;
        } else if (UriComponents.AUTHORITY.equals(theComponent)) {
            result = 10;
        } else if (UriComponents.DEVICE.equals(theComponent)) {
            result = 20;
        } else if (UriComponents.FRAGMENT.equals(theComponent)) {
            result = 30;
        } else if (UriComponents.JAR_AUTHORITY.equals(theComponent)) {
            result = 40;
        } else if (UriComponents.OPAQUE_PART.equals(theComponent)) {
            result = 50;
        } else if (UriComponents.QUERY.equals(theComponent)) {
            result = 60;
        } else if (UriComponents.SCHEME.equals(theComponent)) {
            result = 70;
        } else if (UriComponents.SEGMENT.equals(theComponent)) {
            result = 80;
        } else if (UriComponents.SEGMENTS.equals(theComponent)) {
            result = 90;
        }
        if (!theIsValidFlag) {
            result *= -1;
        }
        return result;
    }

    private static int getSeverity(boolean theIsValidFlag) {
        return theIsValidFlag ? 0 : 4;
    }

    public static boolean isValid(String theUri) {
        boolean result = false;
        if (StringUtil.isEmpty(theUri)) {
            result = true;
        } else {
            try {
                URI.createURI(theUri);
                result = true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    public static IStatus validate(String theUri) {
        IStatus result = null;
        if (!StringUtil.isEmpty(theUri)) {
            try {
                URI.createURI(theUri);
            }
            catch (IllegalArgumentException theException) {
                int code = -1;
                String uriMsg = theException.getMessage();
                String msg = null;
                if (uriMsg != null && uriMsg.length() > 0) {
                    String component = null;
                    if (uriMsg.indexOf("scheme") != -1) {
                        component = UriComponents.SCHEME;
                    } else if (uriMsg.indexOf("opaquePart") != -1) {
                        component = UriComponents.OPAQUE_PART;
                    } else if (uriMsg.indexOf("authority") != -1) {
                        component = StringUtil.startsWithIgnoreCase(theUri, "jar") ? UriComponents.JAR_AUTHORITY : UriComponents.AUTHORITY;
                    } else if (uriMsg.indexOf("device") != -1) {
                        component = UriComponents.DEVICE;
                    } else if (uriMsg.indexOf("segments") != -1) {
                        component = UriComponents.SEGMENTS;
                    } else if (uriMsg.indexOf("query") != -1) {
                        component = UriComponents.QUERY;
                    } else if (uriMsg.indexOf("fragment") != -1) {
                        component = UriComponents.FRAGMENT;
                    } else {
                        msg = uriMsg;
                    }
                    if (component != null) {
                        code = UriValidator.getCode(component, false);
                        msg = CoreMetamodelPlugin.Util.getString(PREFIX + "uriComponentInvalid", new Object[]{component, theUri});
                    }
                } else {
                    code = UriValidator.getCode(URI_LABEL, false);
                    msg = CoreMetamodelPlugin.Util.getString(PREFIX + "genericUriError", new Object[]{theUri});
                }
                result = new Status(UriValidator.getSeverity(false), "com.metamatrix.metamodels.core", code, msg, null);
            }
        }
        if (result == null) {
            result = UriValidator.createStatus(URI_LABEL, theUri, true);
        }
        return result;
    }

    public static boolean isValidAuthority(String theAuthority) {
        return URI.validAuthority(theAuthority);
    }

    public static IStatus validateAuthority(String theAuthority) {
        return UriValidator.createStatus(UriComponents.AUTHORITY, theAuthority, UriValidator.isValidAuthority(theAuthority));
    }

    public static boolean isValidDevice(String theDevice) {
        return URI.validDevice(theDevice);
    }

    public static IStatus validateDevice(String theDevice) {
        return UriValidator.createStatus(UriComponents.DEVICE, theDevice, UriValidator.isValidDevice(theDevice));
    }

    public static boolean isValidFragment(String theFragment) {
        return URI.validFragment(theFragment);
    }

    public static IStatus validateFragment(String theFragment) {
        return UriValidator.createStatus(UriComponents.FRAGMENT, theFragment, UriValidator.isValidFragment(theFragment));
    }

    public static boolean isValidArchiveAuthority(String theArchiveAuthority) {
        return URI.validArchiveAuthority(theArchiveAuthority);
    }

    public static IStatus validateArchiveAuthority(String theArchiveAuthority) {
        return UriValidator.createStatus(UriComponents.JAR_AUTHORITY, theArchiveAuthority, UriValidator.isValidArchiveAuthority(theArchiveAuthority));
    }

    public static boolean isValidOpaquePart(String theOpaquePart) {
        return URI.validOpaquePart(theOpaquePart);
    }

    public static IStatus validateOpaquePart(String theOpaquePart) {
        return UriValidator.createStatus(UriComponents.OPAQUE_PART, theOpaquePart, UriValidator.isValidOpaquePart(theOpaquePart));
    }

    public static boolean isValidQuery(String theQuery) {
        return URI.validQuery(theQuery);
    }

    public static IStatus validateQuery(String theQuery) {
        return UriValidator.createStatus(UriComponents.QUERY, theQuery, UriValidator.isValidQuery(theQuery));
    }

    public static boolean isValidScheme(String theScheme) {
        return URI.validScheme(theScheme);
    }

    public static IStatus validateScheme(String theScheme) {
        return UriValidator.createStatus(UriComponents.SCHEME, theScheme, UriValidator.isValidScheme(theScheme));
    }

    public static boolean isValidSegment(String theSegment) {
        return URI.validSegment(theSegment);
    }

    public static IStatus validateSegment(String theSegment) {
        return UriValidator.createStatus(UriComponents.SEGMENT, theSegment, UriValidator.isValidSegment(theSegment));
    }

    public static boolean isValidSegments(String[] theSegments) throws AssertionException {
        Assertion.isNotNull(theSegments, UriValidator.createNullValueMessage(UriComponents.SEGMENTS));
        return URI.validSegments(theSegments);
    }

    public static IStatus validateSegments(String[] theSegments) throws AssertionException {
        Assertion.isNotNull(theSegments, UriValidator.createNullValueMessage(UriComponents.SEGMENTS));
        IStatus result = null;
        for (int i2 = 0; i2 < theSegments.length; ++i2) {
            boolean valid = UriValidator.isValidSegment(theSegments[i2]);
            if (valid) continue;
            result = UriValidator.createStatus(UriComponents.SEGMENTS, theSegments[i2], false);
            break;
        }
        if (result == null) {
            result = new Status(0, "com.metamatrix.metamodels.core", 90, CoreMetamodelPlugin.Util.getString(PREFIX + "allsegmentsvalid"), null);
        }
        return result;
    }

    private UriValidator() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ String access$000() {
        return PREFIX;
    }

    public static interface UriComponents {
        public static final String AUTHORITY = CoreMetamodelPlugin.Util.getString(UriValidator.access$000() + "uricomponents." + "authority");
        public static final String DEVICE = CoreMetamodelPlugin.Util.getString(UriValidator.access$000() + "uricomponents." + "device");
        public static final String FRAGMENT = CoreMetamodelPlugin.Util.getString(UriValidator.access$000() + "uricomponents." + "fragment");
        public static final String JAR_AUTHORITY = CoreMetamodelPlugin.Util.getString(UriValidator.access$000() + "uricomponents." + "jarauthority");
        public static final String OPAQUE_PART = CoreMetamodelPlugin.Util.getString(UriValidator.access$000() + "uricomponents." + "opaquepart");
        public static final String QUERY = CoreMetamodelPlugin.Util.getString(UriValidator.access$000() + "uricomponents." + "query");
        public static final String SCHEME = CoreMetamodelPlugin.Util.getString(UriValidator.access$000() + "uricomponents." + "scheme");
        public static final String SEGMENT = CoreMetamodelPlugin.Util.getString(UriValidator.access$000() + "uricomponents." + "segment");
        public static final String SEGMENTS = CoreMetamodelPlugin.Util.getString(UriValidator.access$000() + "uricomponents." + "multiplesegment");
    }

    public static interface StatusCodes {
        public static final int VALID_URI = 1;
        public static final int INVALID_URI = -1;
        public static final int VALID_AUTHORITY = 10;
        public static final int INVALID_AUTHORITY = -10;
        public static final int VALID_DEVICE = 20;
        public static final int INVALID_DEVICE = -20;
        public static final int VALID_FRAGMENT = 30;
        public static final int INVALID_FRAGMENT = -30;
        public static final int VALID_ARCHIVE_AUTHORITY = 40;
        public static final int INVALID_ARCHIVE_AUTHORITY = -40;
        public static final int VALID_OPAQUE_PART = 50;
        public static final int INVALID_OPAQUE_PART = -50;
        public static final int VALID_QUERY = 60;
        public static final int INVALID_QUERY = -60;
        public static final int VALID_SCHEME = 70;
        public static final int INVALID_SCHEME = -70;
        public static final int VALID_SEGMENT = 80;
        public static final int INVALID_SEGMENT = -80;
        public static final int VALID_SEGMENTS = 90;
        public static final int INVALID_SEGMENTS = -90;
    }
}

