/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.license;

import com.metamatrix.license.a;
import com.metamatrix.license.d;
import com.metamatrix.license.e;
import com.metamatrix.license.exception.InvalidLicenseException;
import com.metamatrix.license.exception.LicenseVerificationException;
import com.metamatrix.license.exception.UnlicensedProductException;
import com.metamatrix.license.exception.UnverifiedLicenseException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class LicenseChecker {
    static final String LICENSE_FILE = "MetaMatrixLicense.xml";
    static final String CERT_FILE = "metamatrix.cert";
    static final String ABOUT_PLUGIN_NAME = "com.metamatrix.modeler";
    static final String ABOUT_MAPPINGS_FILE = "about.mappings";
    private static boolean licenseLoaded = false;
    private static final a licenseManager = new a();
    private static _a notifier = LicenseChecker.getNullNotifier();
    static /* synthetic */ Class class$com$metamatrix$license$LicenseChecker;

    public static void registerNotifier(_a _a2) {
        notifier = _a2;
    }

    public static String getLicenseFileName() {
        return LICENSE_FILE;
    }

    public static synchronized void loadLicense() throws LicenseVerificationException {
        try {
            licenseManager.u(LICENSE_FILE);
            licenseManager.m(CERT_FILE);
            licenseManager.o();
            licenseLoaded = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            notifier.b(fileNotFoundException.getMessage());
            throw new LicenseVerificationException((Throwable)fileNotFoundException, e.n.getString("ERR.003.016.0003", LICENSE_FILE));
        }
        catch (IOException iOException) {
            notifier.b(iOException.getMessage());
            throw new LicenseVerificationException((Throwable)iOException, e.n.getString("ERR.003.016.0005", LICENSE_FILE));
        }
        catch (LicenseVerificationException licenseVerificationException) {
            notifier.b(licenseVerificationException.getMessage());
            throw new LicenseVerificationException((Throwable)licenseVerificationException, e.n.getString("ERR.003.016.0005", LICENSE_FILE));
        }
    }

    public static synchronized void loadLicense(ClassLoader classLoader) throws LicenseVerificationException {
        try {
            if (classLoader == null) {
                classLoader = (class$com$metamatrix$license$LicenseChecker == null ? (class$com$metamatrix$license$LicenseChecker = LicenseChecker.class$("com.metamatrix.license.LicenseChecker")) : class$com$metamatrix$license$LicenseChecker).getClassLoader();
            }
            InputStream inputStream = classLoader.getResourceAsStream(LICENSE_FILE);
            InputStream inputStream2 = classLoader.getResourceAsStream(CERT_FILE);
            if (inputStream == null) {
                notifier.b(e.n.getString("ERR.003.016.0003", LICENSE_FILE));
                throw new LicenseVerificationException(e.n.getString("ERR.003.016.0003", LICENSE_FILE));
            }
            if (inputStream2 == null) {
                notifier.b(e.n.getString("ERR.003.016.0004", CERT_FILE));
                throw new LicenseVerificationException(e.n.getString("ERR.003.016.0004", CERT_FILE));
            }
            licenseManager.v(inputStream);
            licenseManager.w(inputStream2);
            licenseManager.o();
            licenseLoaded = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            notifier.b(fileNotFoundException.getMessage());
            throw new LicenseVerificationException((Throwable)fileNotFoundException, e.n.getString("ERR.003.016.0003", LICENSE_FILE));
        }
        catch (IOException iOException) {
            notifier.b(iOException.getMessage());
            throw new LicenseVerificationException((Throwable)iOException, e.n.getString("ERR.003.016.0005", LICENSE_FILE));
        }
    }

    public static boolean hasValidProductLicense(String string, String string2, boolean bl) {
        try {
            String string3 = LicenseChecker.checkProductLicense(string, string2, bl);
            if (string3 != null && string3.length() > 0) {
                notifier.a(string3);
            }
            return true;
        }
        catch (UnverifiedLicenseException unverifiedLicenseException) {
            notifier.b(unverifiedLicenseException.getMessage());
        }
        catch (UnlicensedProductException unlicensedProductException) {
            notifier.b(unlicensedProductException.getMessage());
        }
        catch (InvalidLicenseException invalidLicenseException) {
            notifier.b(invalidLicenseException.getMessage());
        }
        catch (LicenseVerificationException licenseVerificationException) {
            notifier.b(licenseVerificationException.getMessage());
        }
        return false;
    }

    public static boolean hasValidProductLicense(String string, String string2) {
        try {
            String string3 = LicenseChecker.checkProductLicense(string, string2);
            if (string3 != null && string3.length() > 0) {
                notifier.a(string3);
            }
            return true;
        }
        catch (UnverifiedLicenseException unverifiedLicenseException) {
            notifier.b(unverifiedLicenseException.getMessage());
        }
        catch (UnlicensedProductException unlicensedProductException) {
            notifier.b(unlicensedProductException.getMessage());
        }
        catch (InvalidLicenseException invalidLicenseException) {
            notifier.b(invalidLicenseException.getMessage());
        }
        catch (LicenseVerificationException licenseVerificationException) {
            notifier.b(licenseVerificationException.getMessage());
        }
        return false;
    }

    public static boolean hasValidProductLicense(String string, String string2, int n2) {
        try {
            String string3 = LicenseChecker.checkProductLicense(string, string2, n2);
            if (string3 != null && string3.length() > 0) {
                notifier.a(string3);
            }
            return true;
        }
        catch (UnverifiedLicenseException unverifiedLicenseException) {
            notifier.b(unverifiedLicenseException.getMessage());
        }
        catch (UnlicensedProductException unlicensedProductException) {
            notifier.b(unlicensedProductException.getMessage());
        }
        catch (InvalidLicenseException invalidLicenseException) {
            notifier.b(invalidLicenseException.getMessage());
        }
        catch (LicenseVerificationException licenseVerificationException) {
            notifier.b(licenseVerificationException.getMessage());
        }
        return false;
    }

    public static boolean checkProductLicenseForExpiring(String string, String string2) {
        try {
            licenseManager.d();
            String string3 = LicenseChecker.checkProductLicense(string, string2);
            if (string3 != null && string3.length() > 0) {
                String string4 = licenseManager.s(string, string2);
                LicenseChecker.updateLicenseExpiringAboutMessage(string4);
                notifier.a(string3);
            } else {
                LicenseChecker.updateLicenseExpiringAboutMessage("");
            }
            return true;
        }
        catch (UnverifiedLicenseException unverifiedLicenseException) {
            notifier.b(unverifiedLicenseException.getMessage());
        }
        catch (UnlicensedProductException unlicensedProductException) {
            notifier.b(unlicensedProductException.getMessage());
        }
        catch (InvalidLicenseException invalidLicenseException) {
            notifier.b(invalidLicenseException.getMessage());
        }
        catch (LicenseVerificationException licenseVerificationException) {
            notifier.b(licenseVerificationException.getMessage());
        }
        return false;
    }

    public static void updateLicenseExpiringAboutMessage(String string) {
        try {
            Bundle bundle = Platform.getBundle(ABOUT_PLUGIN_NAME);
            Path path = new Path(ABOUT_MAPPINGS_FILE);
            URL uRL = Platform.find(bundle, path);
            InputStream inputStream = uRL.openStream();
            Properties properties = new Properties();
            properties.load(inputStream);
            properties.setProperty("1", string);
            URL uRL2 = Platform.resolve(uRL);
            String string2 = uRL2.getPath();
            File file = new File(string2);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            properties.store(fileOutputStream, null);
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String checkProductLicense(String string, String string2) throws LicenseVerificationException, UnverifiedLicenseException, UnlicensedProductException, InvalidLicenseException {
        if (!licenseLoaded) {
            LicenseChecker.loadLicense(Thread.currentThread().getContextClassLoader());
        }
        return licenseManager.a(string, string2);
    }

    public static String checkProductLicense(String string, String string2, boolean bl) throws LicenseVerificationException, UnverifiedLicenseException, UnlicensedProductException, InvalidLicenseException {
        if (!licenseLoaded) {
            LicenseChecker.loadLicense(Thread.currentThread().getContextClassLoader());
        }
        return licenseManager.b(string, string2, bl);
    }

    public static String checkProductLicense(String string, String string2, int n2) throws LicenseVerificationException, UnverifiedLicenseException, UnlicensedProductException, InvalidLicenseException {
        if (!licenseLoaded) {
            LicenseChecker.loadLicense(Thread.currentThread().getContextClassLoader());
        }
        return licenseManager.t(string, string2, n2);
    }

    public static synchronized d getLicenseDescriptor(String string, String string2) {
        try {
            if (!licenseLoaded) {
                LicenseChecker.loadLicense(Thread.currentThread().getContextClassLoader());
            }
            return licenseManager.r(string, string2);
        }
        catch (LicenseVerificationException licenseVerificationException) {
            notifier.b(licenseVerificationException.getMessage());
        }
        catch (UnverifiedLicenseException unverifiedLicenseException) {
            notifier.b(unverifiedLicenseException.getMessage());
        }
        catch (UnlicensedProductException unlicensedProductException) {
            notifier.b(unlicensedProductException.getMessage());
        }
        catch (InvalidLicenseException invalidLicenseException) {
            notifier.b(invalidLicenseException.getMessage());
        }
        return null;
    }

    public static synchronized d getLicenseDescriptor(String string, String string2, String string3, String string4) {
        try {
            if (!licenseLoaded) {
                LicenseChecker.loadLicense(Thread.currentThread().getContextClassLoader());
            }
            return licenseManager.k(string, string2, string3, string4);
        }
        catch (LicenseVerificationException licenseVerificationException) {
            notifier.b(licenseVerificationException.getMessage());
        }
        catch (UnverifiedLicenseException unverifiedLicenseException) {
            notifier.b(unverifiedLicenseException.getMessage());
        }
        catch (UnlicensedProductException unlicensedProductException) {
            notifier.b(unlicensedProductException.getMessage());
        }
        catch (InvalidLicenseException invalidLicenseException) {
            notifier.b(invalidLicenseException.getMessage());
        }
        return null;
    }

    static _a getSystemOutNotifier() {
        return new _a(){

            public void b(String string) {
                System.out.println(string);
            }

            public void a(String string) {
                System.out.println(string);
            }
        };
    }

    static _a getNullNotifier() {
        return new _a(){

            public void b(String string) {
            }

            public void a(String string) {
            }
        };
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface _a {
        public void b(String var1);

        public void a(String var1);
    }
}

