/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.util;

import com.metamatrix.jdbc.JDBCPlugin;

public class StoredProcedureCall {
    private boolean hasReturnParameter;
    private String procedureName;
    private String parameters;

    public StoredProcedureCall(String callStatement) throws IllegalArgumentException {
        String call = callStatement.trim();
        if (!call.startsWith("{") || !call.endsWith("}")) {
            throw new IllegalArgumentException(JDBCPlugin.Util.getString("StoredProcedureCall.curlies"));
        }
        if ((call = call.substring(1, call.length() - 1).trim()).startsWith("?")) {
            this.hasReturnParameter = true;
            if (!(call = call.substring(1).trim()).startsWith("=")) {
                throw new IllegalArgumentException(JDBCPlugin.Util.getString("StoredProcedureCall.equals"));
            }
            call = call.substring(1).trim();
        }
        if (!call.regionMatches(true, 0, "call", 0, 4)) {
            throw new IllegalArgumentException(JDBCPlugin.Util.getString("StoredProcedureCall.call"));
        }
        String procedure = call.substring(4);
        if (!Character.isWhitespace(procedure.charAt(0))) {
            throw new IllegalArgumentException(JDBCPlugin.Util.getString("StoredProcedureCall.no_whitespace"));
        }
        procedure = procedure.trim();
        int paramStart = procedure.indexOf(40);
        int paramEnd = procedure.lastIndexOf(41);
        if (paramStart < 0) {
            if (paramEnd >= 0) {
                throw new IllegalArgumentException(JDBCPlugin.Util.getString("StoredProcedureCall.unnecessary_paren"));
            }
            this.procedureName = procedure;
        } else {
            if (paramStart == 0) {
                throw new IllegalArgumentException(JDBCPlugin.Util.getString("StoredProcedureCall.procname"));
            }
            if (paramEnd != procedure.length() - 1) {
                throw new IllegalArgumentException(JDBCPlugin.Util.getString("StoredProcedureCall.unexpected_tokens"));
            }
            this.parameters = procedure.substring(paramStart);
            this.procedureName = procedure.substring(0, paramStart).trim();
        }
        if (this.containsWhitespace(this.procedureName)) {
            throw new IllegalArgumentException(JDBCPlugin.Util.getString("StoredProcedureCall.whitespace_in_name"));
        }
    }

    private boolean containsWhitespace(String str) {
        char[] chars = str.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            if (!Character.isWhitespace(chars[i2])) continue;
            return true;
        }
        return false;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public String getParameters() {
        return this.parameters == null ? "()" : this.parameters;
    }

    public boolean hasReturnParameter() {
        return this.hasReturnParameter;
    }

    public String getExecCommand() {
        return "EXEC " + this.getProcedureName() + this.getParameters();
    }
}

