/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.transport;

import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.comm.api.ServerConnection;
import com.metamatrix.common.comm.api.ServerConnectionFactory;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.comm.exception.ConnectionException;
import com.metamatrix.dqp.application.ClientConnectionListener;
import com.metamatrix.dqp.embedded.DQPEmbeddedManager;
import com.metamatrix.dqp.embedded.DQPListener;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.transport.DQPLocalServerConnectionFactory;
import com.metamatrix.jdbc.transport.KillableServerListener;
import com.metamatrix.jdbc.transport.TransportHandler;
import java.net.URL;
import java.util.Properties;

public class LocalTransportHandler
implements TransportHandler {
    private static final String SERVER_CONFIG_FILE_EXTENSION = ".properties";
    private DQPEmbeddedManager dqpManager;
    private ServerConnectionFactory connFactory;
    private int connectionID = 0;
    DQPListener dqpListener = null;
    ClientConnectionListener connectionListener = null;
    private boolean alive = true;

    public LocalTransportHandler() {
        this(null, null);
    }

    public LocalTransportHandler(DQPListener dqpListener, ClientConnectionListener connListener) {
        this.dqpListener = dqpListener;
        this.connectionListener = connListener;
    }

    public boolean isAlive() {
        return this.alive && this.dqpManager != null && this.dqpManager.isDQPAlive();
    }

    private void initManager(URL dqpURL, Properties connProperties) throws ApplicationInitializationException {
        if (this.dqpManager == null) {
            if (dqpURL == null) {
                throw new ApplicationInitializationException(JDBCPlugin.Util.getString("LocalTransportHandler.No_configuration_file_set_in_property", "dqp.propertiesFile"));
            }
            String dqpFileName = dqpURL.toString().toLowerCase();
            if (!dqpFileName.endsWith(SERVER_CONFIG_FILE_EXTENSION)) {
                throw new ApplicationInitializationException(JDBCPlugin.Util.getString("LocalTransportHandler.Invalid_config_file_extension", dqpFileName));
            }
            this.dqpManager = new DQPEmbeddedManager(dqpURL, connProperties, this.dqpListener);
            ServerListener listener = this.dqpManager.createDQP(this.connectionListener);
            String transportShutdownErrorMessage = JDBCPlugin.Util.getString("LocalTransportHandler.Transport_shutdown");
            listener = new KillableServerListener(listener, this, transportShutdownErrorMessage);
            this.connFactory = new DQPLocalServerConnectionFactory(listener);
        }
    }

    public synchronized ServerConnection createConnection(Properties props) throws ConnectionException, CommunicationException {
        try {
            URL dqpURL = (URL)props.get("bootstrapFile");
            this.initManager(dqpURL, props);
        }
        catch (ApplicationInitializationException e2) {
            throw new ConnectionException(e2);
        }
        if (this.connFactory == null) {
            throw new ConnectionException(JDBCPlugin.Util.getString("LocalTransportHandler.Failed_to_initialize_factory_1"));
        }
        props.put("connectionID", this.getConnectionID());
        ServerConnection conn = this.connFactory.establishConnection(null, props);
        return conn;
    }

    public synchronized String getConnectionID() {
        String id = "" + this.connectionID;
        ++this.connectionID;
        return id;
    }

    public synchronized void shutdown() {
        this.alive = false;
        if (this.dqpManager != null) {
            this.connFactory = null;
            try {
                this.dqpManager.shutdown();
            }
            catch (ApplicationLifecycleException applicationLifecycleException) {
                // empty catch block
            }
            this.dqpManager = null;
        }
    }

    public DQPEmbeddedManager getManager() {
        return this.dqpManager;
    }

    void setManager(DQPEmbeddedManager manager) {
        this.dqpManager = manager;
    }
}

