/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.common.xa.atomikos.xaresource.MMXid;
import com.metamatrix.core.log.Logger;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMConnection;
import com.metamatrix.jdbc.MMConnectionWrapper;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMXAConnection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class MMXAResource
implements XAResource {
    private final int DEFAULT_TIMEOUT = 120;
    private MMXAConnection mmConnection;
    private int timeOut;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMXAResource;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMXAConnection;

    public static MMXAResource newInstance(MMXAConnection mmConnection) {
        if (AOP.useproxy()) {
            return (MMXAResource)ProxyFactory.extend((Class)(class$com$metamatrix$jdbc$MMXAResource == null ? (class$com$metamatrix$jdbc$MMXAResource = MMXAResource.class$("com.metamatrix.jdbc.MMXAResource")) : class$com$metamatrix$jdbc$MMXAResource), (Class[])new Class[]{class$com$metamatrix$jdbc$MMXAConnection == null ? (class$com$metamatrix$jdbc$MMXAConnection = MMXAResource.class$("com.metamatrix.jdbc.MMXAConnection")) : class$com$metamatrix$jdbc$MMXAConnection}, (Object[])new Object[]{mmConnection});
        }
        return new MMXAResource(mmConnection);
    }

    public MMXAResource(MMXAConnection mmConnection) {
        this.mmConnection = mmConnection;
    }

    public Logger getLogger() {
        return this.mmConnection.getLogger();
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        Xid mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().commitTransaction(mmXid, onePhase);
        }
        catch (SQLException e2) {
            Throwable ex;
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedCommitTXN", xid, onePhase ? "true" : "false");
            this.getLogger().log(2, e2, logMsg);
            if (e2 instanceof MMSQLException && (ex = ((MMSQLException)e2).getNestedException()) != null && ex instanceof XAException) {
                throw (XAException)ex;
            }
            throw new XAException(-3);
        }
    }

    public void end(Xid xid, int flag) throws XAException {
        Xid mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().endTransaction(mmXid, flag);
        }
        catch (SQLException e2) {
            Throwable ex;
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedEndTXN", xid, new Integer(flag));
            this.getLogger().log(2, e2, logMsg);
            if (e2 instanceof MMSQLException && (ex = ((MMSQLException)e2).getNestedException()) != null && ex instanceof XAException) {
                throw (XAException)ex;
            }
            throw new XAException(-3);
        }
    }

    public void forget(Xid xid) throws XAException {
        Xid mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().forgetTransaction(mmXid);
        }
        catch (SQLException e2) {
            Throwable ex;
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedForgetTXN", xid);
            this.getLogger().log(2, e2, logMsg);
            if (e2 instanceof MMSQLException && (ex = ((MMSQLException)e2).getNestedException()) != null && ex instanceof XAException) {
                throw (XAException)ex;
            }
            throw new XAException(-3);
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.timeOut;
    }

    public boolean isSameRM(XAResource arg0) throws XAException {
        return arg0 == this;
    }

    public int prepare(Xid xid) throws XAException {
        Xid mmXid = this.getMMXid(xid);
        try {
            return this.getMMConnection().prepareTransaction(mmXid);
        }
        catch (SQLException e2) {
            Throwable ex;
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedPrepareTXN", xid);
            this.getLogger().log(2, e2, logMsg);
            if (e2 instanceof MMSQLException && (ex = ((MMSQLException)e2).getNestedException()) != null && ex instanceof XAException) {
                throw (XAException)ex;
            }
            throw new XAException(-3);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        try {
            return this.getMMConnection().recoverTransaction(flag);
        }
        catch (SQLException e2) {
            Throwable ex;
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedRecoverTXN", flag);
            this.getLogger().log(2, e2, logMsg);
            if (e2 instanceof MMSQLException && (ex = ((MMSQLException)e2).getNestedException()) != null && ex instanceof XAException) {
                throw (XAException)ex;
            }
            throw new XAException(-3);
        }
    }

    public void rollback(Xid xid) throws XAException {
        Xid mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().rollbackTransaction(mmXid);
        }
        catch (SQLException e2) {
            Throwable ex;
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedRollbackTXN", xid);
            this.getLogger().log(2, e2, logMsg);
            if (e2 instanceof MMSQLException && (ex = ((MMSQLException)e2).getNestedException()) != null && ex instanceof XAException) {
                throw (XAException)ex;
            }
            throw new XAException(-3);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (this.timeOut == seconds) {
            return true;
        }
        if (seconds == 0) {
            this.timeOut = 120;
        }
        try {
            this.getMMConnection().setTransactionTimeout(seconds);
            this.timeOut = seconds;
        }
        catch (SQLException e2) {
            Throwable ex;
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedSetTXNTimeout", new Integer(seconds));
            this.getLogger().log(2, e2, logMsg);
            if (e2 instanceof MMSQLException && (ex = ((MMSQLException)e2).getNestedException()) != null && ex instanceof XAException) {
                throw (XAException)ex;
            }
            throw new XAException(-3);
        }
        return true;
    }

    public void start(Xid xid, int flag) throws XAException {
        Xid mmXid = this.getMMXid(xid);
        try {
            this.getMMConnection().startTransaction(mmXid, flag);
        }
        catch (SQLException e2) {
            Throwable ex;
            String logMsg = JDBCPlugin.Util.getString("MMXAResource.FailedStartTXN", xid, new Integer(flag));
            this.getLogger().log(2, e2, logMsg);
            if (e2 instanceof MMSQLException && (ex = ((MMSQLException)e2).getNestedException()) != null && ex instanceof XAException) {
                throw (XAException)ex;
            }
            throw new XAException(-3);
        }
    }

    void setMMXAConnection(MMXAConnection conn) {
        this.mmConnection = conn;
    }

    private MMConnection getMMConnection() throws XAException {
        MMConnection conn = null;
        try {
            conn = ((MMConnectionWrapper)this.mmConnection.getConnection()).getMMConnection();
        }
        catch (SQLException e2) {
            throw new XAException(-7);
        }
        return conn;
    }

    private Xid getMMXid(Xid originalXid) throws XAException {
        return new MMXid(originalXid.getFormatId(), originalXid.getGlobalTransactionId(), originalXid.getBranchQualifier());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

