/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc;

import com.metamatrix.common.aop.AOP;
import com.metamatrix.common.aop.ProxyFactory;
import com.metamatrix.core.log.Logger;
import com.metamatrix.jdbc.JDBCPlugin;
import com.metamatrix.jdbc.MMSQLException;
import com.metamatrix.jdbc.MMStatement;
import com.metamatrix.jdbc.ReaderImpl;
import com.metamatrix.jdbc.StreamImpl;
import com.metamatrix.query.i.e;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

public class MMClob
implements Clob,
Serializable {
    private MMStatement statement;
    private e valueID;
    private ReaderImpl in;
    private long length = -1L;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMClob;
    static /* synthetic */ Class class$com$metamatrix$jdbc$MMStatement;
    static /* synthetic */ Class class$com$metamatrix$query$i$e;

    public static MMClob newInstance(MMStatement statement, e valueID) throws SQLException {
        if (AOP.useproxy()) {
            return (MMClob)ProxyFactory.extend((Class)(class$com$metamatrix$jdbc$MMClob == null ? (class$com$metamatrix$jdbc$MMClob = MMClob.class$("com.metamatrix.jdbc.MMClob")) : class$com$metamatrix$jdbc$MMClob), (Class[])new Class[]{class$com$metamatrix$jdbc$MMStatement == null ? (class$com$metamatrix$jdbc$MMStatement = MMClob.class$("com.metamatrix.jdbc.MMStatement")) : class$com$metamatrix$jdbc$MMStatement, class$com$metamatrix$query$i$e == null ? (class$com$metamatrix$query$i$e = MMClob.class$("com.metamatrix.query.i.e")) : class$com$metamatrix$query$i$e}, (Object[])new Object[]{statement, valueID});
        }
        return new MMClob(statement, valueID);
    }

    public MMClob(MMStatement statement, e valueID) throws SQLException {
        this.statement = statement;
        this.valueID = valueID;
        this.in = ReaderImpl.newInstance(StreamImpl.newInstance(this.statement, this.getValueID()));
    }

    public Logger getLogger() {
        return this.statement.getLogger();
    }

    public InputStream getAsciiStream() throws SQLException {
        return StreamImpl.newInstance(this.statement, this.getValueID(), true);
    }

    public Reader getCharacterStream() throws SQLException {
        return ReaderImpl.newInstance(StreamImpl.newInstance(this.statement, this.getValueID()));
    }

    public String getSubString(long pos, int length) throws SQLException {
        char[] dataCopy = new char[length];
        try {
            if (pos < 1L) {
                Object[] params = new Object[]{new Long(pos)};
                throw new SQLException(JDBCPlugin.Util.getString("MMClob_MMBlob.0", params));
            }
            if (pos > this.length()) {
                return null;
            }
            if (length < 0) {
                Object[] params = new Object[]{new Integer(length)};
                throw new SQLException(JDBCPlugin.Util.getString("MMClob_MMBlob.1", params));
            }
            if ((long)length > this.length()) {
                length = (int)this.length();
            }
            this.in.skip(pos - 1L);
            this.in.read(dataCopy, 0, length);
        }
        catch (IOException ie) {
            Object[] params = new Object[]{ie.getMessage()};
            throw new SQLException(JDBCPlugin.Util.getString("MMClob.Unable_to_get_chars_from_pos_to_length._{0}_1", params));
        }
        return new String(dataCopy);
    }

    public long length() throws SQLException {
        if (this.length == -1L) {
            try {
                this.length = this.in.length();
            }
            catch (IOException e2) {
                throw MMSQLException.create(e2, e2.getMessage());
            }
        }
        return this.length;
    }

    public long position(Clob searchstr, long start) throws SQLException {
        if (searchstr == null || start > this.length()) {
            return -1L;
        }
        int length = (int)searchstr.length();
        String searchString = searchstr.getSubString(1L, length);
        return this.position(searchString, start);
    }

    public long position(String searchstr, long start) throws SQLException {
        int position = 0;
        try {
            if (start < 1L) {
                Object[] params = new Object[]{new Long(start)};
                throw new SQLException(JDBCPlugin.Util.getString("MMClob_MMBlob.2", params));
            }
            if (searchstr == null || start > this.length()) {
                return -1L;
            }
            String patternStr = searchstr;
            char[] restData = new char[(int)this.length()];
            this.in.read(restData, 0, restData.length);
            String streamData = new String(restData);
            position = streamData.indexOf(patternStr, (int)start - 1);
            if (position != -1) {
                ++position;
            }
        }
        catch (IOException ie) {
            Object[] params = new Object[]{searchstr, ie.getMessage()};
            throw new SQLException(JDBCPlugin.Util.getString("MMClob.Unable_to_get_the_position_of___{0}__._{1}_2", params));
        }
        return position;
    }

    public String toString() {
        try {
            int c2;
            StringBuffer buff = new StringBuffer();
            char[] chunk = new char[102400];
            Reader reader = this.getCharacterStream();
            while ((c2 = reader.read(chunk, 0, chunk.length)) != -1) {
                buff.append(chunk, 0, c2);
            }
            return buff.toString();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2.getMessage());
        }
    }

    public boolean equals(Object obj) {
        try {
            String thisSubStr;
            if (obj == null || this.in == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof MMClob)) {
                return false;
            }
            MMClob clob = (MMClob)obj;
            if (clob.length() != this.length() || clob.getValueID() != this.getValueID()) {
                return false;
            }
            String subStr = clob.getSubString(1L, (int)clob.length());
            if (!subStr.equals(thisSubStr = this.getSubString(1L, (int)this.length()))) {
                return false;
            }
        }
        catch (SQLException e2) {
            return false;
        }
        return true;
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int setString(long pos, String str) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void truncate(long len) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public e getValueID() {
        return this.valueID;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

