/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.xml;

import com.metamatrix.core.util.ArgCheck;
import java.io.IOException;
import java.io.Reader;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.om.Item;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.trans.XPathException;

public class XPathHelper {
    public static String getSingleMatchAsString(Reader documentReader, String xpath) throws XPathException, IOException {
        Object o2 = XPathHelper.getSingleMatch(documentReader, xpath);
        if (o2 == null) {
            return null;
        }
        if (o2 instanceof Item) {
            return ((Item)o2).getStringValue();
        }
        return o2.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getSingleMatch(Reader documentReader, String xpath) throws XPathException, IOException {
        ArgCheck.isNotNull(documentReader);
        ArgCheck.isNotNull(xpath);
        try {
            StreamSource s2 = new StreamSource(documentReader);
            XPathEvaluator eval = new XPathEvaluator();
            XPathExpression expr = eval.createExpression(xpath);
            Object object = expr.evaluateSingle(s2);
            return object;
        }
        finally {
            documentReader.close();
        }
    }

    public static void validateXpath(String xpath) throws XPathException {
        if (xpath == null) {
            return;
        }
        XPathEvaluator eval = new XPathEvaluator();
        eval.createExpression(xpath);
    }
}

