/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.index;

import com.metamatrix.core.util.CharOperation;
import com.metamatrix.internal.core.index.IndexedFile;
import com.metamatrix.internal.core.index.WordEntry;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Util {
    private static final int DEFAULT_READING_SIZE = 8192;
    protected static ResourceBundle bundle;
    private static final String bundleName = "com.metamatrix.core.index.i18n";

    private Util() {
    }

    public static String bind(String id) {
        return Util.bind(id, (String[])null);
    }

    public static String bind(String id, String argument) {
        return Util.bind(id, new String[]{argument});
    }

    public static String bind(String id, String argument1, String argument2) {
        return Util.bind(id, new String[]{argument1, argument2});
    }

    public static String bind(String id, String[] arguments) {
        if (id == null) {
            return "No message available";
        }
        String message = null;
        try {
            message = bundle.getString(id);
        }
        catch (MissingResourceException e2) {
            return "Missing message: " + id + " in: " + bundleName;
        }
        return MessageFormat.format(message, arguments);
    }

    public static int compare(char[] str1, char[] str2) {
        int len1 = str1.length;
        int len2 = str2.length;
        int n2 = Math.min(len1, len2);
        int i2 = 0;
        while (n2-- != 0) {
            char c2;
            char c1 = str1[i2];
            if (c1 == (c2 = str2[i2++])) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static int prefixLength(char[] s1, char[] s2) {
        int len = 0;
        int max = Math.min(s1.length, s2.length);
        for (int i2 = 0; i2 < max && s1[i2] == s2[i2]; ++i2) {
            ++len;
        }
        return len;
    }

    public static int prefixLength(String s1, String s2) {
        int len = 0;
        int max = Math.min(s1.length(), s2.length());
        for (int i2 = 0; i2 < max && s1.charAt(i2) == s2.charAt(i2); ++i2) {
            ++len;
        }
        return len;
    }

    private static void quickSort(char[][] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        char[] mid = list[(left + right) / 2];
        while (true) {
            if (Util.compare(list[left], mid) < 0) {
                ++left;
                continue;
            }
            while (Util.compare(mid, list[right]) < 0) {
                --right;
            }
            if (left <= right) {
                char[] tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(list, left, original_right);
        }
    }

    private static void quickSort(int[] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        int mid = list[(left + right) / 2];
        while (true) {
            if (list[left] < mid) {
                ++left;
                continue;
            }
            while (mid < list[right]) {
                --right;
            }
            if (left <= right) {
                int tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(list, left, original_right);
        }
    }

    private static void quickSort(String[] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        String mid = list[(left + right) / 2];
        while (true) {
            if (list[left].compareTo(mid) < 0) {
                ++left;
                continue;
            }
            while (mid.compareTo(list[right]) < 0) {
                --right;
            }
            if (left <= right) {
                String tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(list, left, original_right);
        }
    }

    private static void quickSort(IndexedFile[] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        String mid = list[(left + right) / 2].path;
        while (true) {
            if (list[left].path.compareTo(mid) < 0) {
                ++left;
                continue;
            }
            while (mid.compareTo(list[right].path) < 0) {
                --right;
            }
            if (left <= right) {
                IndexedFile tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(list, left, original_right);
        }
    }

    private static void quickSort(WordEntry[] list, int left, int right) {
        int original_left = left;
        int original_right = right;
        char[] mid = list[(left + right) / 2].fWord;
        while (true) {
            if (Util.compare(list[left].fWord, mid) < 0) {
                ++left;
                continue;
            }
            while (Util.compare(mid, list[right].fWord) < 0) {
                --right;
            }
            if (left <= right) {
                WordEntry tmp = list[left];
                list[left] = list[right];
                list[right] = tmp;
                ++left;
                --right;
            }
            if (left > right) break;
        }
        if (original_left < right) {
            Util.quickSort(list, original_left, right);
        }
        if (left < original_right) {
            Util.quickSort(list, left, original_right);
        }
    }

    public static final char[] readUTF(DataInput in) throws IOException {
        int utflen = in.readUnsignedShort();
        char[] str = new char[utflen];
        int count = 0;
        int strlen = 0;
        block5: while (count < utflen) {
            int c2 = in.readUnsignedByte();
            switch (c2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c2;
                    continue block5;
                }
                case 12: 
                case 13: {
                    if ((count += 2) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = in.readUnsignedByte();
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c2 & 0x1F) << 6 | char2 & 0x3F);
                    continue block5;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new UTFDataFormatException();
                    }
                    int char2 = in.readUnsignedByte();
                    int char3 = in.readUnsignedByte();
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    str[strlen++] = (char)((c2 & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    continue block5;
                }
            }
            throw new UTFDataFormatException();
        }
        if (strlen < utflen) {
            char[] cArray = str;
            str = new char[strlen];
            System.arraycopy(cArray, 0, str, 0, strlen);
        }
        return str;
    }

    public static void sort(char[][] list) {
        if (list.length > 1) {
            Util.quickSort(list, 0, list.length - 1);
        }
    }

    public static void sort(int[] list) {
        if (list.length > 1) {
            Util.quickSort(list, 0, list.length - 1);
        }
    }

    public static void sort(String[] list) {
        if (list.length > 1) {
            Util.quickSort(list, 0, list.length - 1);
        }
    }

    public static void sort(IndexedFile[] list) {
        if (list.length > 1) {
            Util.quickSort(list, 0, list.length - 1);
        }
    }

    public static void sort(WordEntry[] list) {
        if (list.length > 1) {
            Util.quickSort(list, 0, list.length - 1);
        }
    }

    public static void writeUTF(OutputStream out, char[] str) throws IOException {
        char c2;
        int i2;
        int strlen = str.length;
        int utflen = 0;
        for (i2 = 0; i2 < strlen; ++i2) {
            c2 = str[i2];
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c2 > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        out.write(utflen >>> 8 & 0xFF);
        out.write(utflen >>> 0 & 0xFF);
        for (i2 = 0; i2 < strlen; ++i2) {
            c2 = str[i2];
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                out.write(c2);
                continue;
            }
            if (c2 > '\u07ff') {
                out.write(0xE0 | c2 >> 12 & 0xF);
                out.write(0x80 | c2 >> 6 & 0x3F);
                out.write(0x80 | c2 >> 0 & 0x3F);
                continue;
            }
            out.write(0xC0 | c2 >> 6 & 0x1F);
            out.write(0x80 | c2 >> 0 & 0x3F);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getFileByteContent(File file) throws IOException {
        byte[] byArray;
        block5: {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(file));
                byArray = Util.getInputStreamAsByteArray(stream, (int)file.length());
                Object var4_3 = null;
                if (stream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var4_4 = null;
                    if (stream == null) break block6;
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException e2) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] getFileCharContent(File file, String encoding) throws IOException {
        char[] cArray;
        block5: {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(new FileInputStream(file));
                cArray = Util.getInputStreamAsCharArray(stream, (int)file.length(), encoding);
                Object var5_4 = null;
                if (stream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var5_5 = null;
                    if (stream == null) break block6;
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (IOException e2) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        return cArray;
    }

    public static byte[] getInputStreamAsByteArray(InputStream stream, int length) throws IOException {
        byte[] contents;
        if (length == -1) {
            contents = new byte[]{};
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    byte[] byArray = contents;
                    contents = new byte[contentsLength + amountRequested];
                    System.arraycopy(byArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = stream.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            if (contentsLength < contents.length) {
                byte[] byArray = contents;
                contents = new byte[contentsLength];
                System.arraycopy(byArray, 0, contents, 0, contentsLength);
            }
        } else {
            contents = new byte[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = stream.read(contents, len += readSize, length - len);
            }
        }
        return contents;
    }

    public static char[] getInputStreamAsCharArray(InputStream stream, int length, String encoding) throws IOException {
        char[] contents;
        InputStreamReader reader = null;
        InputStreamReader inputStreamReader = reader = encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, encoding);
        if (length == -1) {
            contents = CharOperation.NO_CHAR;
            int contentsLength = 0;
            int amountRead = -1;
            do {
                int amountRequested;
                if (contentsLength + (amountRequested = Math.max(stream.available(), 8192)) > contents.length) {
                    char[] cArray = contents;
                    contents = new char[contentsLength + amountRequested];
                    System.arraycopy(cArray, 0, contents, 0, contentsLength);
                }
                if ((amountRead = reader.read(contents, contentsLength, amountRequested)) <= 0) continue;
                contentsLength += amountRead;
            } while (amountRead != -1);
            int start = 0;
            if (contentsLength > 0 && "UTF-8".equals(encoding) && contents[0] == '\ufeff') {
                --contentsLength;
                start = 1;
            }
            if (contentsLength < contents.length) {
                char[] cArray = contents;
                contents = new char[contentsLength];
                System.arraycopy(cArray, start, contents, 0, contentsLength);
            }
        } else {
            contents = new char[length];
            int len = 0;
            int readSize = 0;
            while (readSize != -1 && len != length) {
                readSize = reader.read(contents, len += readSize, length - len);
            }
            int start = 0;
            if (length > 0 && "UTF-8".equals(encoding) && contents[0] == '\ufeff') {
                --len;
                start = 1;
            }
            if (len != length) {
                char[] cArray = contents;
                contents = new char[len];
                System.arraycopy(cArray, start, contents, 0, len);
            }
        }
        return contents;
    }
}

