/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.index;

import com.metamatrix.internal.core.index.FileListBlock;
import com.metamatrix.internal.core.index.GammaCompressedIndexBlock;
import com.metamatrix.internal.core.index.IndexBlock;
import com.metamatrix.internal.core.index.IndexOutput;
import com.metamatrix.internal.core.index.IndexSummary;
import com.metamatrix.internal.core.index.IndexedFile;
import com.metamatrix.internal.core.index.SafeRandomAccessFile;
import com.metamatrix.internal.core.index.WordEntry;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BlocksIndexOutput
extends IndexOutput {
    protected RandomAccessFile indexOut;
    protected int blockNum;
    protected boolean opened = false;
    protected File indexFile;
    protected FileListBlock fileListBlock;
    protected IndexBlock indexBlock;
    protected int numWords = 0;
    protected IndexSummary summary;
    protected int numFiles = 0;
    protected boolean firstInBlock;
    protected boolean firstIndexBlock;
    protected boolean firstFileListBlock;

    public BlocksIndexOutput(File indexFile) {
        this.indexFile = indexFile;
        this.summary = new IndexSummary();
        this.blockNum = 1;
        this.firstInBlock = true;
        this.firstIndexBlock = true;
        this.firstFileListBlock = true;
    }

    public void addFile(IndexedFile indexedFile) throws IOException {
        if (this.firstFileListBlock) {
            this.firstInBlock = true;
            this.fileListBlock = new FileListBlock(8192);
            this.firstFileListBlock = false;
        }
        if (this.fileListBlock.addFile(indexedFile)) {
            if (this.firstInBlock) {
                this.summary.addFirstFileInBlock(indexedFile, this.blockNum);
                this.firstInBlock = false;
            }
            ++this.numFiles;
        } else {
            if (this.fileListBlock.isEmpty()) {
                return;
            }
            this.flushFiles();
            this.addFile(indexedFile);
        }
    }

    public void addWord(WordEntry entry) throws IOException {
        if (this.firstIndexBlock) {
            this.indexBlock = new GammaCompressedIndexBlock(8192);
            this.firstInBlock = true;
            this.firstIndexBlock = false;
        }
        if (entry.getNumRefs() == 0) {
            return;
        }
        if (this.indexBlock.addEntry(entry)) {
            if (this.firstInBlock) {
                this.summary.addFirstWordInBlock(entry.getWord(), this.blockNum);
                this.firstInBlock = false;
            }
            ++this.numWords;
        } else {
            if (this.indexBlock.isEmpty()) {
                return;
            }
            this.flushWords();
            this.addWord(entry);
        }
    }

    public void close() throws IOException {
        if (this.opened) {
            this.indexOut.close();
            this.summary = null;
            this.numFiles = 0;
            this.opened = false;
        }
    }

    public void flush() throws IOException {
        this.summary.setNumFiles(this.numFiles);
        this.summary.setNumWords(this.numWords);
        this.indexOut.seek((long)this.blockNum * 8192L);
        this.summary.write(this.indexOut);
        this.indexOut.seek(0L);
        this.indexOut.writeUTF("INDEX FILE 0.012");
        this.indexOut.writeInt(this.blockNum);
    }

    protected void flushFiles() throws IOException {
        if (!this.firstFileListBlock && this.fileListBlock != null) {
            this.fileListBlock.flush();
            this.fileListBlock.write(this.indexOut, this.blockNum++);
            this.fileListBlock.clear();
            this.firstInBlock = true;
        }
    }

    protected void flushWords() throws IOException {
        if (!this.firstInBlock && this.indexBlock != null) {
            this.indexBlock.flush();
            this.indexBlock.write(this.indexOut, this.blockNum++);
            this.indexBlock.clear();
            this.firstInBlock = true;
        }
    }

    public Object getDestination() {
        return this.indexFile;
    }

    public void open() throws IOException {
        if (!this.opened) {
            this.summary = new IndexSummary();
            this.numFiles = 0;
            this.numWords = 0;
            this.blockNum = 1;
            this.firstInBlock = true;
            this.firstIndexBlock = true;
            this.firstFileListBlock = true;
            this.indexOut = new SafeRandomAccessFile(this.indexFile, "rw");
            this.opened = true;
        }
    }
}

