/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.spi.basic;

import com.metamatrix.dqp.spi.CommandLoggerSPI;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class FileCommandLogger
implements CommandLoggerSPI {
    public static final String LOG_FILE_NAME_PROPERTY = "dqp.commandLogger.fileName";
    private static final String TIMESTAMP_FORMAT = "yyyy.MM.dd HH:mm:ss.SSS";
    private static DateFormat TIMESTAMP_FORMATTER = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS");
    private String filename;
    private BufferedWriter logWriter;

    public void initialize(Properties props) {
        this.filename = props.getProperty(LOG_FILE_NAME_PROPERTY);
        if (this.filename == null) {
            System.out.println("FileCommandLogger could not find log filename property");
        } else {
            boolean append = true;
            try {
                this.logWriter = new BufferedWriter(new FileWriter(this.filename, append));
            }
            catch (IOException e2) {
                System.out.println("FileCommandLogger could not write to log file " + this.filename + ": " + e2.getMessage());
            }
        }
    }

    public void close() {
        try {
            this.logWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void logMessage(String outputString) {
        try {
            this.logWriter.write(outputString, 0, outputString.length());
            this.logWriter.newLine();
            this.logWriter.flush();
        }
        catch (IOException e2) {
            System.out.println("FileCommandLogger could not write to log file " + this.filename + ": " + e2.getMessage());
        }
    }

    private String getTimestampString(Date date) {
        return TIMESTAMP_FORMATTER.format(date);
    }

    public void userCommandStart(long timestamp, String requestID, String transactionID, String sessionID, String applicationName, String principal, String vdbName, String vdbVersion, String sql) {
        String outputString = this.getTimestampString(new Date()) + "\tSTART USER COMMAND:\tstartTime=" + this.getTimestampString(new Date(timestamp)) + "\trequestID=" + requestID + "\ttxID=" + transactionID + "\tsessionID=" + sessionID + "\tapplicationName=" + applicationName + "\tprincipal=" + principal + "\tvdbName=" + vdbName + "\tvdbVersion=" + vdbVersion + "\tsql=" + sql;
        this.logMessage(outputString);
    }

    public void userCommandEnd(long timestamp, String requestID, String transactionID, String sessionID, String principal, String vdbName, String vdbVersion, int finalRowCount, boolean isCancelled, boolean errorOccurred) {
        String outputString = this.getTimestampString(new Date()) + "\tEND USER COMMAND:\tendTime=" + this.getTimestampString(new Date(timestamp)) + "\trequestID=" + requestID + "\ttxID=" + transactionID + "\tsessionID=" + sessionID + "\tprincipal=" + principal + "\tvdbName=" + vdbName + "\tvdbVersion=" + vdbVersion + "\tfinalRowCount=" + finalRowCount + "\tisCancelled=" + isCancelled + "\terrorOccurred=" + errorOccurred;
        this.logMessage(outputString);
    }

    public void dataSourceCommandStart(long timestamp, String requestID, long sourceCommandID, String subTransactionID, String modelName, String connectorBindingName, String sessionID, String principal, String sql) {
        String outputString = this.getTimestampString(new Date()) + "\tSTART DATA SRC COMMAND:\tstartTime=" + this.getTimestampString(new Date(timestamp)) + "\trequestID=" + requestID + "\tsourceCommandID=" + sourceCommandID + "\tsubTxID=" + subTransactionID + "\tmodelName=" + modelName + "\tconnectorBindingName=" + connectorBindingName + "\tsessionID=" + sessionID + "\tprincipal=" + principal + "\tsql=" + sql;
        this.logMessage(outputString);
    }

    public void dataSourceCommandEnd(long timestamp, String requestID, long sourceCommandID, String subTransactionID, String modelName, String connectorBindingName, String sessionID, String principal, int finalRowCount, boolean isCancelled, boolean errorOccurred) {
        String outputString = this.getTimestampString(new Date()) + "\tEND DATA SRC COMMAND:\tendTime=" + this.getTimestampString(new Date(timestamp)) + "\trequestID=" + requestID + "\tsourceCommandID=" + sourceCommandID + "\tsubTxID=" + subTransactionID + "\tmodelName=" + modelName + "\tconnectorBindingName=" + connectorBindingName + "\tsessionID=" + sessionID + "\tprincipal=" + principal + "\tfinalRowCount=" + finalRowCount + "\tisCancelled=" + isCancelled + "\terrorOccurred=" + errorOccurred;
        this.logMessage(outputString);
    }

    public void transactionStart(long timestamp, String transactionID, String sessionID, String principal, String vdbName, String vdbVersion) {
        String outputString = this.getTimestampString(new Date()) + "\tSTART TRANSACTION:\tstartTime=" + this.getTimestampString(new Date(timestamp)) + "\ttxID=" + transactionID + "\tsessionID=" + sessionID + "\tprincipal=" + principal + "\tvdbName=" + vdbName + "\tvdbVersion=" + vdbVersion;
        this.logMessage(outputString);
    }

    public void transactionEnd(long timestamp, String transactionID, String sessionID, String principal, String vdbName, String vdbVersion, boolean isCommit) {
        String outputString = this.getTimestampString(new Date()) + "\tEND TRANSACTION:\tendTime=" + this.getTimestampString(new Date(timestamp)) + "\ttxID=" + transactionID + "\tsessionID=" + sessionID + "\tprincipal=" + principal + "\tvdbName=" + vdbName + "\tvdbVersion=" + vdbVersion + "\tisCommit=" + isCommit;
        this.logMessage(outputString);
    }
}

