/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.service.metadata;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.extensionmodule.protocol.URLFactory;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.modeler.internal.core.index.CompositeIndexSelector;
import com.metamatrix.modeler.internal.core.index.RuntimeIndexSelector;
import com.metamatrix.modeler.transformation.metadata.TransformationMetadataFactory;
import com.metamatrix.query.m.e;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class QueryMetadataCache {
    private Map vdbToQueryMetadata = new HashMap();
    private Map vdbToCompositeSelector = new HashMap();
    private Map vdbToRuntimeSelector = new HashMap();
    private final RuntimeIndexSelector systemVDBSelector;
    private int numberOfShares = 0;
    private boolean isCacheValid = true;

    public QueryMetadataCache(URL systemVdbUrl) throws MetaMatrixComponentException {
        try {
            this.systemVDBSelector = this.getRuntimeIndexSelector(systemVdbUrl);
        }
        catch (Exception e2) {
            LogManager.logError("DQP", (Throwable)e2, DQPPlugin.Util.getString("QueryMetadataCache.Failed_creating_Runtime_Index_Selector._4", "System.vdb"));
            throw new MetaMatrixComponentException(e2);
        }
    }

    public QueryMetadataCache(byte[] sysemVdbContent) throws MetaMatrixComponentException {
        try {
            this.systemVDBSelector = this.getRuntimeIndexSelector("System.vdb", sysemVdbContent);
        }
        catch (Exception e2) {
            LogManager.logError("DQP", (Throwable)e2, DQPPlugin.Util.getString("QueryMetadataCache.Failed_creating_Runtime_Index_Selector._4", "System.vdb"));
            throw new MetaMatrixComponentException(e2);
        }
    }

    public QueryMetadataCache(String filePath) throws MetaMatrixComponentException {
        try {
            URL systemVdbUrl = new URL("file:///" + filePath);
            this.systemVDBSelector = this.getRuntimeIndexSelector(systemVdbUrl);
        }
        catch (Exception e2) {
            LogManager.logError("DQP", (Throwable)e2, DQPPlugin.Util.getString("QueryMetadataCache.Failed_creating_Runtime_Index_Selector._4", "System.vdb"));
            throw new MetaMatrixComponentException(e2);
        }
    }

    public synchronized void shareIncrement() {
        ++this.numberOfShares;
    }

    public synchronized void shareDecrement() {
        if (this.numberOfShares > 0) {
            --this.numberOfShares;
        }
        if (this.numberOfShares == 0) {
            this.clearCache();
        }
    }

    public boolean isValid() {
        return this.isCacheValid;
    }

    public CompositeIndexSelector getCompositeSelector(String vdbName, String vdbVersion) {
        this.assertIsValidCache();
        String vdbID = this.toVdbID(vdbName, vdbVersion);
        return (CompositeIndexSelector)this.vdbToCompositeSelector.get(vdbID);
    }

    public e lookupMetadata(String vdbName, String vdbVersion) {
        this.assertIsValidCache();
        String vdbID = this.toVdbID(vdbName, vdbVersion);
        QueryMetadataInterfaceHolder qmiHolder = (QueryMetadataInterfaceHolder)this.vdbToQueryMetadata.get(vdbID);
        if (qmiHolder != null) {
            return qmiHolder.getQueryMetadataInteface();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public e lookupMetadata(String vdbName, String vdbVersion, String filePath) throws MetaMatrixComponentException {
        this.assertIsValidCache();
        String vdbID = this.toVdbID(vdbName, vdbVersion);
        QueryMetadataInterfaceHolder qmiHolder = null;
        Map map = this.vdbToQueryMetadata;
        synchronized (map) {
            qmiHolder = (QueryMetadataInterfaceHolder)this.vdbToQueryMetadata.get(vdbID);
            if (qmiHolder == null) {
                qmiHolder = new QueryMetadataInterfaceHolder(vdbID, vdbName);
                this.vdbToQueryMetadata.put(vdbID, qmiHolder);
            }
        }
        return qmiHolder.getQueryMetadataInterface(filePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public e lookupMetadata(String vdbName, String vdbVersion, byte[] vdbContent) throws MetaMatrixComponentException {
        this.assertIsValidCache();
        String vdbID = this.toVdbID(vdbName, vdbVersion);
        QueryMetadataInterfaceHolder qmiHolder = null;
        Map map = this.vdbToQueryMetadata;
        synchronized (map) {
            qmiHolder = (QueryMetadataInterfaceHolder)this.vdbToQueryMetadata.get(vdbID);
            if (qmiHolder == null) {
                qmiHolder = new QueryMetadataInterfaceHolder(vdbID, vdbName);
                this.vdbToQueryMetadata.put(vdbID, qmiHolder);
            }
        }
        return qmiHolder.getQueryMetadataInteface(vdbContent);
    }

    private void assertIsValidCache() {
        if (!this.isValid()) {
            throw new MetaMatrixRuntimeException(DQPPlugin.Util.getString("QueryMetadataCache.cache_not_valid"));
        }
    }

    private e loadMetadata(String vdbID, RuntimeIndexSelector runtimeSelector) throws MetaMatrixComponentException {
        this.assertIsValidCache();
        this.vdbToRuntimeSelector.put(vdbID, runtimeSelector);
        ArrayList<RuntimeIndexSelector> selectors = new ArrayList<RuntimeIndexSelector>(2);
        selectors.add(runtimeSelector);
        if (this.systemVDBSelector != null && this.systemVDBSelector.isValid()) {
            selectors.add(this.systemVDBSelector);
        }
        CompositeIndexSelector composite = new CompositeIndexSelector(selectors);
        this.vdbToCompositeSelector.put(vdbID, composite);
        e result = TransformationMetadataFactory.getInstance().createCachingServerMetadata(composite);
        return result;
    }

    private RuntimeIndexSelector getRuntimeIndexSelector(String vdbName, byte[] vdbContents) {
        RuntimeIndexSelector runtimeSelector = null;
        try {
            String vdbFileName = vdbName + '.' + "vdb";
            runtimeSelector = new RuntimeIndexSelector(vdbFileName, vdbContents);
            runtimeSelector.getIndexes();
        }
        catch (IOException e2) {
            LogManager.logError("DQP", (Throwable)e2, DQPPlugin.Util.getString("QueryMetadataCache.Failed_creating_Runtime_Index_Selector._4", vdbName));
            throw new MetaMatrixRuntimeException(e2);
        }
        return runtimeSelector;
    }

    private RuntimeIndexSelector getRuntimeIndexSelector(URL path) {
        RuntimeIndexSelector runtimeSelector = null;
        try {
            runtimeSelector = new RuntimeIndexSelector(path);
            runtimeSelector.getIndexes();
        }
        catch (IOException e2) {
            LogManager.logError("DQP", (Throwable)e2, DQPPlugin.Util.getString("QueryMetadataCache.Failed_creating_Runtime_Index_Selector._4", path));
            throw new MetaMatrixRuntimeException(e2);
        }
        return runtimeSelector;
    }

    public void clearCache() {
        this.isCacheValid = false;
        this.vdbToQueryMetadata.clear();
        Iterator iter = this.vdbToRuntimeSelector.values().iterator();
        while (iter.hasNext()) {
            RuntimeIndexSelector selector = (RuntimeIndexSelector)iter.next();
            selector.setValid(false);
            selector.clearVDB();
        }
        this.vdbToRuntimeSelector.clear();
        if (this.systemVDBSelector != null) {
            this.systemVDBSelector.setValid(false);
            this.systemVDBSelector.clearVDB();
        }
        this.vdbToCompositeSelector.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromCache(String vdbName, String vdbVersion) {
        if (vdbName != null && vdbVersion != null) {
            String vdbID = this.toVdbID(vdbName, vdbVersion);
            QueryMetadataInterfaceHolder qmiHolder = null;
            RuntimeIndexSelector selector = null;
            Map map = this.vdbToQueryMetadata;
            synchronized (map) {
                qmiHolder = (QueryMetadataInterfaceHolder)this.vdbToQueryMetadata.get(vdbID);
                if (qmiHolder != null) {
                    this.vdbToQueryMetadata.remove(vdbID);
                }
                this.vdbToCompositeSelector.remove(vdbID);
                selector = (RuntimeIndexSelector)this.vdbToRuntimeSelector.remove(vdbID);
            }
            if (selector != null) {
                selector.clearVDB();
            }
        }
    }

    private String toVdbID(String vdbName, String vdbVersion) {
        return vdbName + vdbVersion;
    }

    public e testLoadMetadata(String vdbName, String vdbVersion, String filePath) throws MetaMatrixComponentException {
        String vdbID = this.toVdbID(vdbName, vdbVersion);
        try {
            return this.loadMetadata(vdbID, this.getRuntimeIndexSelector(new URL("file:///" + filePath)));
        }
        catch (Exception e2) {
            throw new MetaMatrixComponentException(e2);
        }
    }

    protected class QueryMetadataInterfaceHolder {
        private final String vdbId;
        private final String vdbName;
        private e qmi;

        protected QueryMetadataInterfaceHolder(String vdbId, String vdbName) {
            this.vdbId = vdbId;
            this.vdbName = vdbName;
        }

        protected e getQueryMetadataInteface() {
            return this.qmi;
        }

        protected synchronized e getQueryMetadataInterface(String filePath) throws MetaMatrixComponentException {
            if (this.qmi == null) {
                URL path = null;
                try {
                    path = URLFactory.parseURL(filePath);
                }
                catch (MalformedURLException e2) {
                    throw new MetaMatrixComponentException(e2);
                }
                this.qmi = QueryMetadataCache.this.loadMetadata(this.vdbId, QueryMetadataCache.this.getRuntimeIndexSelector(path));
            }
            return this.qmi;
        }

        protected synchronized e getQueryMetadataInteface(byte[] vdbCotent) throws MetaMatrixComponentException {
            if (this.qmi == null) {
                this.qmi = QueryMetadataCache.this.loadMetadata(this.vdbId, QueryMetadataCache.this.getRuntimeIndexSelector(this.vdbName, vdbCotent));
            }
            return this.qmi;
        }
    }
}

