/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.service.metadata;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.vdb.api.VDBStream;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.dqp.service.metadata.IndexSelectorSource;
import com.metamatrix.dqp.service.metadata.QueryMetadataCache;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.query.m.e;
import java.util.Properties;

public class IndexMetadataService
implements MetadataService,
IndexSelectorSource {
    private VDBService vdbService;
    private boolean started = false;
    private QueryMetadataCache metadataCache;

    public IndexMetadataService() {
    }

    public IndexMetadataService(QueryMetadataCache metadataCache) {
        this.metadataCache = metadataCache;
    }

    public void initialize(Properties props) throws ApplicationInitializationException {
        if (this.metadataCache == null) {
            this.metadataCache = (QueryMetadataCache)props.get("dqp.metadata.queryMetadataCache");
        }
    }

    public void start(ApplicationEnvironment environment) throws ApplicationLifecycleException {
        if (!this.started) {
            if (this.vdbService == null) {
                this.vdbService = (VDBService)environment.findService("dqp.vdb");
                if (this.vdbService == null) {
                    LogManager.logError("DQP", DQPPlugin.Util.getString("IndexMetadataService.VDB_Service_is_not_available._1"));
                    throw new ApplicationLifecycleException(DQPPlugin.Util.getString("IndexMetadataService.VDB_Service_is_not_available._1"));
                }
            }
            this.started = true;
            this.metadataCache.shareIncrement();
        }
    }

    public void bind() throws ApplicationLifecycleException {
    }

    public void unbind() throws ApplicationLifecycleException {
    }

    public void stop() throws ApplicationLifecycleException {
        if (this.started) {
            this.started = false;
            this.metadataCache.shareDecrement();
        }
    }

    public IndexSelector getIndexSelector(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        return this.metadataCache.getCompositeSelector(vdbName, vdbVersion);
    }

    public e lookupMetadata(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        e qmi = this.metadataCache.lookupMetadata(vdbName, vdbVersion);
        if (qmi == null) {
            VDBStream contents = this.vdbService.getVDBResource(vdbName, vdbVersion);
            return this.metadataCache.lookupMetadata(vdbName, vdbVersion, contents.toByteArray());
        }
        return qmi;
    }

    public e testLoadMetadata(String vdbName, String vdbVersion, String filePath) throws MetaMatrixComponentException {
        return this.metadataCache.lookupMetadata(vdbName, vdbVersion, filePath);
    }
}

