/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.service;

import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.QueueWorker;
import com.metamatrix.common.queue.QueueWorkerException;
import com.metamatrix.common.queue.QueueWorkerFactory;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.service.CustomizableTrackingMessage;
import com.metamatrix.dqp.service.TrackingService;
import com.metamatrix.dqp.spi.CommandLoggerSPI;
import com.metamatrix.query.o.j.l;
import java.util.Properties;

public class CustomizableTrackingService
implements TrackingService {
    public static final String SYSTEM_TXN_STORE_TXN = "metamatrix.transaction.log.storeTXN";
    public static final String SYSTEM_TXN_STORE_MMCMD = "metamatrix.transaction.log.storeMMCMD";
    public static final String SYSTEM_TXN_STORE_SRCCMD = "metamatrix.transaction.log.storeSRCCMD";
    public static final String SYSTEM_LOG_THREAD_TTL = "metamatrix.transaction.log.threadTTL";
    protected static final String DEFAULT_LOG_THREAD_TTL = "600000";
    private CommandLoggerSPI commandLogger;
    private boolean recordTransactions;
    private boolean recordUserCommands;
    private boolean recordSourceCommands;
    private long workerTTL;
    private WorkerPool logQueue;

    public void log(String txnUid, short txnPoint, short status, String sessionUid, String principal, String vdbName, String vdbVersion) {
        if (this.willRecordTxn()) {
            CustomizableTrackingMessage message = null;
            if (txnPoint == 1) {
                message = new CustomizableTrackingMessage(System.currentTimeMillis(), txnUid, sessionUid, principal, vdbName, vdbVersion);
            } else {
                boolean isCommit = false;
                if (status == 2) {
                    isCommit = true;
                }
                message = new CustomizableTrackingMessage(System.currentTimeMillis(), txnUid, sessionUid, principal, vdbName, vdbVersion, isCommit);
            }
            this.addWork(message);
        }
    }

    public void log(String requestId, String txnUid, short cmdPoint, short status, String sessionUid, String applicationName, String principal, String vdbName, String vdbVersion, l sql, int rowCount) {
        if (this.willRecordMMCmd()) {
            CustomizableTrackingMessage message = null;
            if (cmdPoint == 1) {
                message = new CustomizableTrackingMessage(System.currentTimeMillis(), requestId, txnUid, sessionUid, applicationName, principal, vdbName, vdbVersion, sql != null ? sql.toString() : null);
            } else {
                boolean isCancelled = false;
                boolean errorOccurred = false;
                if (status == 3) {
                    isCancelled = true;
                } else if (status == 4) {
                    errorOccurred = true;
                }
                message = new CustomizableTrackingMessage(System.currentTimeMillis(), requestId, txnUid, sessionUid, principal, vdbName, vdbVersion, rowCount, isCancelled, errorOccurred);
            }
            this.addWork(message);
        }
    }

    public void log(String requestId, long nodeID, String subTxnUid, short status, String modelName, String cbName, short cmdPoint, String sessionUid, String principal, l sql, int rowCount) {
        if (this.willRecordSrcCmd()) {
            CustomizableTrackingMessage message = null;
            if (cmdPoint == 1) {
                message = new CustomizableTrackingMessage(System.currentTimeMillis(), requestId, nodeID, subTxnUid, modelName, cbName, sessionUid, principal, sql != null ? sql.toString() : null);
            } else {
                boolean isCancelled = false;
                boolean errorOccurred = false;
                if (status == 3) {
                    isCancelled = true;
                } else if (status == 4) {
                    errorOccurred = true;
                }
                message = new CustomizableTrackingMessage(System.currentTimeMillis(), requestId, nodeID, subTxnUid, modelName, cbName, sessionUid, principal, rowCount, isCancelled, errorOccurred);
            }
            this.addWork(message);
        }
    }

    public boolean willRecordTxn() {
        return this.recordTransactions;
    }

    public boolean willRecordMMCmd() {
        return this.recordUserCommands;
    }

    public boolean willRecordSrcCmd() {
        return this.recordSourceCommands;
    }

    public void initialize(Properties props) throws ApplicationInitializationException {
        String propvalue = props.getProperty(SYSTEM_TXN_STORE_TXN);
        if (propvalue != null) {
            this.recordTransactions = Boolean.valueOf(propvalue);
        }
        if ((propvalue = props.getProperty(SYSTEM_TXN_STORE_MMCMD)) != null) {
            this.recordUserCommands = Boolean.valueOf(propvalue);
        }
        if ((propvalue = props.getProperty(SYSTEM_TXN_STORE_SRCCMD)) != null) {
            this.recordSourceCommands = Boolean.valueOf(propvalue);
        }
        try {
            this.workerTTL = Long.parseLong(System.getProperty(SYSTEM_LOG_THREAD_TTL, DEFAULT_LOG_THREAD_TTL));
        }
        catch (NumberFormatException e2) {
            throw new ApplicationInitializationException(e2);
        }
        String commandLoggerClassname = props.getProperty("dqp.tracking.commandLoggerClassname");
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            CommandLoggerSPI logger = (CommandLoggerSPI)loader.loadClass(commandLoggerClassname).newInstance();
            logger.initialize(props);
            this.commandLogger = logger;
        }
        catch (Exception e3) {
            throw new ApplicationInitializationException(e3);
        }
    }

    void initialize(CommandLoggerSPI commandLogger, boolean willRecordTransactions, boolean willRecordUserCommands, boolean willRecordSourceCommands) {
        this.commandLogger = commandLogger;
        this.recordTransactions = willRecordTransactions;
        this.recordUserCommands = willRecordUserCommands;
        this.recordSourceCommands = willRecordSourceCommands;
        this.workerTTL = Long.parseLong(DEFAULT_LOG_THREAD_TTL);
    }

    public void start(ApplicationEnvironment environment) throws ApplicationLifecycleException {
        this.logQueue = new WorkerPool("CustomTracker", new QueueWorkerFactory(){

            public QueueWorker createWorker() {
                return new LogQueueWorker();
            }
        }, 1, this.workerTTL);
    }

    public void bind() throws ApplicationLifecycleException {
    }

    public void unbind() throws ApplicationLifecycleException {
    }

    public void stop() throws ApplicationLifecycleException {
        if (this.logQueue != null) {
            this.logQueue.shutdown();
            this.logQueue = null;
        }
        this.commandLogger.close();
    }

    private void addWork(Object work) {
        try {
            if (this.logQueue != null) {
                this.logQueue.addWork(work);
            } else {
                LogManager.logWarning("TXN_LOG", DQPPlugin.Util.getString("CustomizableTrackingService.not_started"));
            }
        }
        catch (QueueSuspendedException e2) {
            LogManager.logWarning("TXN_LOG", e2.getMessage());
        }
    }

    protected class LogQueueWorker
    extends QueueWorker {
        protected LogQueueWorker() {
        }

        public void initialize() throws QueueWorkerException {
        }

        public void cleanup() throws QueueWorkerException {
        }

        public void process(Object o2) throws QueueWorkerException {
            if (o2 instanceof CustomizableTrackingMessage) {
                CustomizableTrackingMessage message = (CustomizableTrackingMessage)o2;
                switch (message.type) {
                    case 0: {
                        CustomizableTrackingService.this.commandLogger.userCommandStart(message.timestamp, message.requestID, message.transactionID, message.sessionID, message.applicationName, message.principal, message.vdbName, message.vdbVersion, message.sql);
                        break;
                    }
                    case 1: {
                        CustomizableTrackingService.this.commandLogger.userCommandEnd(message.timestamp, message.requestID, message.transactionID, message.sessionID, message.principal, message.vdbName, message.vdbVersion, message.rowCount, message.isCancelled, message.errorOccurred);
                        break;
                    }
                    case 2: {
                        CustomizableTrackingService.this.commandLogger.dataSourceCommandStart(message.timestamp, message.requestID, message.sourceCommandID, message.subTransactionID, message.modelName, message.connectorBindingName, message.sessionID, message.principal, message.sql);
                        break;
                    }
                    case 3: {
                        CustomizableTrackingService.this.commandLogger.dataSourceCommandEnd(message.timestamp, message.requestID, message.sourceCommandID, message.subTransactionID, message.modelName, message.connectorBindingName, message.sessionID, message.principal, message.rowCount, message.isCancelled, message.errorOccurred);
                        break;
                    }
                    case 4: {
                        CustomizableTrackingService.this.commandLogger.transactionStart(message.timestamp, message.transactionID, message.sessionID, message.principal, message.vdbName, message.vdbVersion);
                        break;
                    }
                    case 5: {
                        CustomizableTrackingService.this.commandLogger.transactionEnd(message.timestamp, message.transactionID, message.sessionID, message.principal, message.vdbName, message.vdbVersion, message.isCommit);
                        break;
                    }
                    default: {
                        throw new QueueWorkerException(DQPPlugin.Util.getString("CustomizableTrackingService.unknown_message"));
                    }
                }
            } else {
                throw new QueueWorkerException(DQPPlugin.Util.getString("CustomizableTrackingService.unknown_message"));
            }
        }
    }
}

