/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.message;

import com.metamatrix.core.util.ExternalizeUtil;
import com.metamatrix.dqp.message.DQPInboundMessage;
import com.metamatrix.query.o.j.l;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.transaction.xa.Xid;

public class TransactionMessage
extends DQPInboundMessage {
    static final long serialVersionUID = -4868529360675726768L;
    public static final int GET_REQUIRED_TRANSACTION = 1;
    public static final int USER_TRANSACTION_BEGIN = 2;
    public static final int USER_TRANSACTION_COMMIT = 3;
    public static final int USER_TRANSACTION_ROLLBACK = 4;
    public static final int USER_TRANSACTION_SET_ROLLBACK_ONLY = 5;
    public static final int USER_TRANSACTION_GET_STATUS = 6;
    public static final int START_TRANSACTION = 7;
    public static final int COMMIT_TRANSACTION = 8;
    public static final int ROLLBACK_TRANSACTION = 9;
    public static final int FORGET_TRANSACTION = 10;
    public static final int END_TRANSACTION = 11;
    public static final int PREPARE_TRANSACTION = 12;
    public static final int RECOVER_TRANSACTION = 13;
    public static final int TRANSACTION_TIMEOUT = 14;
    private int requestType;
    private Xid xid;
    private int patameter;
    private Xid[] recoveredXids;
    private Throwable exception;
    private l command;
    private String threadIdentifier;
    private String mmXid;
    private int txnTimeout;
    private int txnStatus;
    private boolean txnRequired;

    public boolean isTxnRequired() {
        return this.txnRequired;
    }

    public void setTxnRequired(boolean txnRequired) {
        this.txnRequired = txnRequired;
    }

    public int getTxnTimeout() {
        return this.txnTimeout;
    }

    public void setTxnTimeout(int txnTimeout) {
        this.txnTimeout = txnTimeout;
    }

    public String getMMXid() {
        return this.mmXid;
    }

    public void setMMXid(String mmXid) {
        this.mmXid = mmXid;
    }

    public int getTxnStatus() {
        return this.txnStatus;
    }

    public void setTxnStatus(int status) {
        this.txnStatus = status;
    }

    public int getMessageType() {
        return 13;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public void setRequestType(int requestType) {
        this.requestType = requestType;
    }

    public void setXid(Xid xid) {
        this.xid = xid;
    }

    public Xid getXid() {
        return this.xid;
    }

    public int getParameter() {
        return this.patameter;
    }

    public void setParameter(int param) {
        this.patameter = param;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable throwable) {
        this.exception = throwable;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public Xid[] getRecoveredXids() {
        return this.recoveredXids;
    }

    public void setRecoveredXids(Xid[] xids) {
        this.recoveredXids = xids;
    }

    public l getCommand() {
        return this.command;
    }

    public void setCommand(l command) {
        this.command = command;
    }

    public String getThreadIdentifier() {
        String connectionID = this.getConnectionID();
        return (connectionID != null ? connectionID + "|" : "") + this.threadIdentifier;
    }

    public void setThreadIdentifier(String threadIdentifier) {
        this.threadIdentifier = threadIdentifier;
    }

    public void setTransactionTimeout(int seconds) {
        this.txnTimeout = seconds;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.requestType = in.readInt();
        this.xid = (Xid)in.readObject();
        this.patameter = in.readInt();
        this.recoveredXids = (Xid[])in.readObject();
        this.command = (l)in.readObject();
        this.threadIdentifier = (String)in.readObject();
        this.mmXid = (String)in.readObject();
        this.txnTimeout = in.readInt();
        this.txnStatus = in.readInt();
        this.txnRequired = in.readBoolean();
        this.exception = ExternalizeUtil.readThrowable(in);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.requestType);
        out.writeObject(this.xid);
        out.writeInt(this.patameter);
        out.writeObject(this.recoveredXids);
        out.writeObject(this.command);
        out.writeObject(this.threadIdentifier);
        out.writeObject(this.mmXid);
        out.writeInt(this.txnTimeout);
        out.writeInt(this.txnStatus);
        out.writeBoolean(this.txnRequired);
        ExternalizeUtil.writeThrowable(out, this.exception);
    }
}

