/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.message;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.xa.TransactionContext;
import com.metamatrix.core.util.ExternalizeUtil;
import com.metamatrix.dqp.message.DQPInboundMessage;
import com.metamatrix.query.i.e;
import com.metamatrix.query.o.i.j;
import com.metamatrix.query.o.j.l;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.List;
import javax.transaction.xa.Xid;

public class RequestMessage
extends DQPInboundMessage {
    static final long serialVersionUID = 2258063872049251854L;
    private l command = null;
    private l originalCommand = null;
    private int fetchSize;
    private int cursorType;
    private boolean partialResultsFlag;
    private boolean isPreparedStatement;
    private boolean isCallableStatement;
    private List parameterValues;
    private boolean validationMode;
    private String txnAutoWrapMode;
    private String XMLFormat;
    private String styleSheet;
    private Date submittedTimestamp;
    private Date processingTimestamp;
    private e valueID;
    private int chunkSize;
    private boolean isLobRequest;
    private long startPosition;
    private TransactionContext txnContext;
    private Xid xid;
    private String txnID;
    private boolean useResultSetCache;
    private String cacheCommand;
    private boolean dblQuotedVariableAllowed = false;
    private boolean synchRequest = false;
    private boolean showPlan = false;
    private int rowLimit;
    protected Object profileID;

    public RequestMessage() {
    }

    public RequestMessage(l command) {
        this();
        this.command = command;
    }

    public l getCommand() {
        return this.command;
    }

    public void setCommand(l command) {
        this.command = command;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public boolean supportsPartialResults() {
        return this.partialResultsFlag;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setPartialResults(boolean partial) {
        this.partialResultsFlag = partial;
    }

    public boolean isPreparedStatement() {
        return this.isPreparedStatement;
    }

    public boolean isCallableStatement() {
        return this.isCallableStatement;
    }

    public void setPreparedStatement(boolean isPreparedStatement) {
        this.isPreparedStatement = isPreparedStatement;
    }

    public void setCallableStatement(boolean isCallableStatement) {
        this.isCallableStatement = isCallableStatement;
    }

    public List getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterValues(List values) {
        this.parameterValues = values;
    }

    public int getCursorType() {
        return this.cursorType;
    }

    public void setCursorType(int cursorType) {
        this.cursorType = cursorType;
    }

    public boolean getValidationMode() {
        return this.validationMode;
    }

    public String getXMLFormat() {
        return this.XMLFormat;
    }

    public void setValidationMode(boolean validationMode) {
        this.validationMode = validationMode;
    }

    public void setXMLFormat(String xMLFormat) {
        this.XMLFormat = xMLFormat;
    }

    public String getTxnAutoWrapMode() {
        return this.txnAutoWrapMode;
    }

    public void setTxnAutoWrapMode(String txnAutoWrapMode) {
        this.txnAutoWrapMode = txnAutoWrapMode;
    }

    public String getStyleSheet() {
        return this.styleSheet;
    }

    public void setStyleSheet(String styleSheet) {
        this.styleSheet = styleSheet;
    }

    public String getUserTransactionId() {
        return this.txnID;
    }

    public void setUserTransactionId(String txnId) {
        this.txnID = txnId;
    }

    public e getValueID() {
        return this.valueID;
    }

    public void setValueID(e valueID) {
        this.valueID = valueID;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public boolean isLobRequest() {
        return this.isLobRequest;
    }

    public void setLobRequest(boolean isLobRequest) {
        this.isLobRequest = isLobRequest;
    }

    public long getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(long startPosition) {
        this.startPosition = startPosition;
    }

    public int getMessageType() {
        return 7;
    }

    public Date getSubmittedTimestamp() {
        return this.submittedTimestamp;
    }

    public void setSubmittedTimestamp(Date submittedTimestamp) {
        this.submittedTimestamp = submittedTimestamp;
    }

    public void markSubmissionStart() {
        this.setSubmittedTimestamp(new Date());
    }

    public Date getProcessingTimestamp() {
        return this.processingTimestamp;
    }

    public void setProcessingTimestamp(Date processingTimestamp) {
        this.processingTimestamp = processingTimestamp;
    }

    public void markProcessingStart() {
        this.setProcessingTimestamp(new Date());
    }

    public l getOriginalCommand() {
        return this.originalCommand;
    }

    public void setOriginalCommand(l originalCommand) {
        this.originalCommand = originalCommand;
    }

    public TransactionContext getTransactionContext() {
        return this.txnContext;
    }

    public void setTransactionContext(TransactionContext context) {
        this.txnContext = context;
    }

    public boolean isTransactional() {
        return this.txnContext != null || this.txnID != null || this.xid != null;
    }

    public void setTransactionXid(Xid id) {
        this.xid = id;
    }

    public Xid getTransactionXid() {
        return this.xid;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.command = (l)in.readObject();
        this.originalCommand = (l)in.readObject();
        this.fetchSize = in.readInt();
        this.cursorType = in.readInt();
        this.partialResultsFlag = in.readBoolean();
        this.isPreparedStatement = in.readBoolean();
        this.isCallableStatement = in.readBoolean();
        this.txnID = (String)in.readObject();
        this.parameterValues = ExternalizeUtil.readList(in);
        this.validationMode = in.readBoolean();
        this.txnAutoWrapMode = (String)in.readObject();
        this.styleSheet = (String)in.readObject();
        this.XMLFormat = (String)in.readObject();
        this.submittedTimestamp = (Date)in.readObject();
        this.processingTimestamp = (Date)in.readObject();
        this.valueID = (e)in.readObject();
        this.chunkSize = in.readInt();
        this.isLobRequest = in.readBoolean();
        this.startPosition = in.readLong();
        this.txnContext = (TransactionContext)in.readObject();
        this.xid = (Xid)in.readObject();
        this.useResultSetCache = in.readBoolean();
        this.dblQuotedVariableAllowed = in.readBoolean();
        this.synchRequest = in.readBoolean();
        this.showPlan = in.readBoolean();
        this.rowLimit = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.command);
        out.writeObject(this.originalCommand);
        out.writeInt(this.fetchSize);
        out.writeInt(this.cursorType);
        out.writeBoolean(this.partialResultsFlag);
        out.writeBoolean(this.isPreparedStatement);
        out.writeBoolean(this.isCallableStatement);
        out.writeObject(this.txnID);
        ExternalizeUtil.writeList(out, this.parameterValues);
        out.writeBoolean(this.validationMode);
        out.writeObject(this.txnAutoWrapMode);
        out.writeObject(this.styleSheet);
        out.writeObject(this.XMLFormat);
        out.writeObject(this.submittedTimestamp);
        out.writeObject(this.processingTimestamp);
        out.writeObject(this.valueID);
        out.writeInt(this.chunkSize);
        out.writeBoolean(this.isLobRequest);
        out.writeLong(this.startPosition);
        out.writeObject(this.txnContext);
        out.writeObject(this.xid);
        out.writeBoolean(this.useResultSetCache);
        out.writeBoolean(this.dblQuotedVariableAllowed);
        out.writeBoolean(this.synchRequest);
        out.writeBoolean(this.showPlan);
        out.writeInt(this.rowLimit);
    }

    public void setProfile(boolean profile) {
    }

    public Object getProfileID() {
        if (this.profileID == null) {
            this.profileID = new Integer(this.hashCode());
        }
        return this.profileID;
    }

    public void setProfileID(Object profileID) {
        this.profileID = profileID;
    }

    public boolean useResultSetCache() {
        return this.useResultSetCache && !this.isTransactional();
    }

    public void setUseResultSetCache(boolean useResultSetCacse) {
        this.useResultSetCache = useResultSetCacse;
    }

    public String getCacheCommand() {
        if (this.cacheCommand == null) {
            this.cacheCommand = this.originalCommand.toString();
        }
        return this.cacheCommand;
    }

    public void setCacheCommand(String cacheCommand) {
        this.cacheCommand = cacheCommand;
    }

    public void setDoubleQuotedVariableAllowed(boolean allowed) {
        this.dblQuotedVariableAllowed = allowed;
    }

    public boolean isDoubleQuotedVariableAllowed() {
        return this.dblQuotedVariableAllowed;
    }

    public void setSynchronousRequest(boolean isSynchronousRequest) {
        this.synchRequest = isSynchronousRequest;
    }

    public boolean isSynchronousRequest() {
        return this.synchRequest;
    }

    public boolean isXMLQuery() {
        List projectedSymbols;
        return this.command != null && (projectedSymbols = this.command.gg()).size() == 1 && ((j)projectedSymbols.get(0)).ag().equals(DataTypeManager.DefaultDataClasses.XML);
    }

    public boolean getShowPlan() {
        return this.showPlan;
    }

    public void setShowPlan(boolean showPlan) {
        this.showPlan = showPlan;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }
}

