/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryParserException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.api.exception.query.QueryResolverException;
import com.metamatrix.api.exception.query.QueryValidatorException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.xa.TransactionContext;
import com.metamatrix.common.xa.XATransactionException;
import com.metamatrix.dqp.internal.process.DQPCore;
import com.metamatrix.dqp.internal.process.MetaDataProcessor;
import com.metamatrix.dqp.internal.process.PreparedPlanCache;
import com.metamatrix.dqp.internal.process.RequestManager;
import com.metamatrix.dqp.internal.process.SchemaRequestProcessor;
import com.metamatrix.dqp.internal.process.TransactionProcessor;
import com.metamatrix.dqp.message.AdminRequestMessage;
import com.metamatrix.dqp.message.AdminResultsMessage;
import com.metamatrix.dqp.message.CancelMessage;
import com.metamatrix.dqp.message.CloseMessage;
import com.metamatrix.dqp.message.CursorRequestMessage;
import com.metamatrix.dqp.message.DQPInboundMessage;
import com.metamatrix.dqp.message.MetaDataMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.TransactionMessage;
import com.metamatrix.dqp.message.XMLSchemaMessage;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.TrackingService;
import com.metamatrix.dqp.service.TransactionService;
import com.metamatrix.query.o.j.l;
import java.util.ArrayList;
import java.util.Map;
import javax.transaction.xa.XAException;

public class MessageHandler {
    private DQPCore dqp;
    private TrackingService tracker;
    private MetadataService metadataService;
    private TransactionProcessor transactionProcessor;
    private RequestManager requestManager;
    private PreparedPlanCache planCache;
    private ApplicationEnvironment env;

    MessageHandler(DQPCore dqp, TrackingService tracker, TransactionService transactionService, boolean transactionAllowed, MetadataService metadataService, RequestManager requestManager, PreparedPlanCache planCache, ApplicationEnvironment env) {
        this.dqp = dqp;
        this.tracker = tracker;
        if (transactionService != null) {
            this.transactionProcessor = new TransactionProcessor(transactionService, metadataService, tracker, transactionAllowed);
        }
        this.metadataService = metadataService;
        this.requestManager = requestManager;
        this.planCache = planCache;
        this.env = env;
    }

    Message processMessage(DQPInboundMessage message) throws QueryParserException, QueryResolverException, QueryValidatorException, QueryPlannerException, QueryMetadataException, MetaMatrixComponentException, XATransactionException, XAException {
        switch (message.getMessageType()) {
            case 3: {
                return this.processCloseMessage((CloseMessage)message);
            }
            case 2: {
                return this.processCancelMessage((CancelMessage)message);
            }
            case 5: {
                return this.processMetaDataMessage((MetaDataMessage)message);
            }
            case 12: {
                return this.processXMLSchemaMessage((XMLSchemaMessage)message);
            }
            case 4: {
                return this.processCursorRequestMessage((CursorRequestMessage)message);
            }
            case 7: {
                this.logMMCommand(message, true, 0);
                return this.dqp.processRequestMessage((RequestMessage)message);
            }
            case 10: {
                return this.processAdminRequestMessage((AdminRequestMessage)message);
            }
            case 13: {
                return this.transactionProcessor.proccessTransactionMessage((TransactionMessage)message);
            }
        }
        return null;
    }

    Message processMetaDataMessage(MetaDataMessage metadataMsg) throws QueryParserException, QueryResolverException, MetaMatrixComponentException {
        return this.createMetaDataProcessor().processMessage(metadataMsg);
    }

    Message processXMLSchemaMessage(XMLSchemaMessage xmlSchemaMsg) throws MetaMatrixComponentException, QueryMetadataException {
        return this.createSchemaRequestProcessor().processMessage(xmlSchemaMsg);
    }

    private MetaDataProcessor createMetaDataProcessor() {
        return new MetaDataProcessor(this.metadataService, this.requestManager, this.planCache, this.env);
    }

    private SchemaRequestProcessor createSchemaRequestProcessor() {
        return new SchemaRequestProcessor(this.metadataService);
    }

    private Message processCursorRequestMessage(CursorRequestMessage message) throws MetaMatrixComponentException {
        RequestID reqID = message.getRequestID();
        int batchFirst = message.getBatchFirst();
        int batchLast = message.getBatchLast();
        this.dqp.processCursorRequest(reqID, batchFirst, batchLast);
        return null;
    }

    public Message processAdminRequestMessage(AdminRequestMessage message) {
        switch (message.getRequestType()) {
            case 0: {
                ArrayList<Map> result = new ArrayList<Map>(1);
                result.add(this.dqp.getRequests());
                return new AdminResultsMessage(result);
            }
            case 1: {
                ArrayList<Map> result = new ArrayList<Map>(1);
                result.add(this.dqp.getRequestMapByClient(message.getClientConnection()));
                return new AdminResultsMessage(result);
            }
            case 2: {
                return new AdminResultsMessage(this.dqp.getQueueStatistics());
            }
            case 3: {
                return new AdminResultsMessage(this.dqp.getQueueStatistics(message.getMsgParam()));
            }
            case 4: {
                this.dqp.clearCodeTableCache();
                return null;
            }
            case 5: {
                this.dqp.clearPlanCache();
                return null;
            }
            case 6: {
                this.dqp.clearResultSetCache();
                return null;
            }
        }
        return null;
    }

    Message processCancelMessage(CancelMessage message) throws MetaMatrixComponentException {
        RequestID reqID = message.getRequestID();
        RequestMessage req = this.requestManager.getRequest(reqID);
        if (message.isAtomicQuery()) {
            this.dqp.cancelRequest(reqID, message.getNodeID(), message.getClientConnection());
        } else {
            this.dqp.cancelRequest(reqID, message.getClientConnection());
        }
        this.logMMCommand(req, false, true, 0);
        return null;
    }

    Message processCloseMessage(CloseMessage message) throws MetaMatrixComponentException {
        if (LogManager.isMessageToBeRecorded("DQP", 5)) {
            LogManager.logDetail("DQP", "Request \"" + message.getRequestID() + "\" finished");
        }
        RequestID requestID = message.getRequestID();
        int rowCount = -1;
        if (requestID != null) {
            rowCount = this.dqp.getFinalRowCount(requestID);
        }
        this.dqp.closeRequest(requestID, message.getClientConnection());
        this.logMMCommand(message, false, rowCount);
        return null;
    }

    void logMMCommand(DQPInboundMessage msg, boolean isBegin, int rowCount) {
        this.logMMCommand(msg, isBegin, false, rowCount);
    }

    void logMMCommand(DQPInboundMessage msg, boolean isBegin, boolean isCancel, int rowCount) {
        if (this.tracker == null || msg == null || !this.tracker.willRecordMMCmd()) {
            return;
        }
        RequestID rID = msg.getRequestID();
        if (rID == null) {
            return;
        }
        l command = null;
        String txnID = null;
        String appName = null;
        if (msg instanceof RequestMessage) {
            RequestMessage req = (RequestMessage)msg;
            if (isBegin && !isCancel) {
                command = req.getCommand();
            }
            if (req.isTransactional()) {
                TransactionContext context = req.getTransactionContext();
                txnID = context == null ? req.getUserTransactionId() : context.getTopLevelTxnID().asString();
            }
            appName = (String)req.getClientConnection().getConnectionProperty("ApplicationName");
        }
        short point = isBegin ? (short)1 : 2;
        short status = 1;
        if (!isBegin) {
            status = isCancel ? (short)3 : 2;
        }
        this.tracker.log(rID.toString(), txnID, point, status, msg.getRequestID().getConnectionID(), appName, msg.getUserName(), msg.getVdbName(), msg.getVdbVersion(), command, rowCount);
    }
}

