/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.query.i.g;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class CodeTableCache {
    private int maxCodeTables;
    private Map loadingCaches = new HashMap();
    private Map requestToCacheKeyMap = new HashMap();
    private Map codeTableCache = new HashMap();
    private Set cacheKeyDone = new HashSet();
    public static final int CACHE_EXISTS = 0;
    public static final int CACHE_LOADING = 1;
    public static final int CACHE_NOT_EXIST = 2;
    public static final int CACHE_OVERLOAD = 3;

    public CodeTableCache(int maxCodeTables) {
        this.maxCodeTables = maxCodeTables;
    }

    public synchronized int cacheExists(String codeTable, String returnElement, String keyElement, g context) {
        CacheKey cacheKey = new CacheKey(codeTable, returnElement, keyElement);
        if (this.cacheKeyDone.contains(cacheKey)) {
            return 0;
        }
        if (this.loadingCaches.containsKey(cacheKey)) {
            WaitingRequests wqr = (WaitingRequests)this.loadingCaches.get(cacheKey);
            wqr.addRequestID(context.getProcessorID());
            this.loadingCaches.put(cacheKey, wqr);
            return 1;
        }
        if (this.codeTableCache.size() + this.loadingCaches.size() >= this.maxCodeTables) {
            return 3;
        }
        WaitingRequests wqr = new WaitingRequests(context.getProcessorID());
        this.loadingCaches.put(cacheKey, wqr);
        return 2;
    }

    public synchronized void setRequestID(String codeTable, String returnElement, String keyElement, RequestID requestID, int nodeID) {
        CacheKey cacheKey = new CacheKey(codeTable, returnElement, keyElement);
        RequestKey requestKey = new RequestKey(requestID, nodeID);
        this.requestToCacheKeyMap.put(requestKey, cacheKey);
    }

    public synchronized boolean isCodeTableResponse(RequestID requestID, int nodeID) {
        RequestKey requestKey = new RequestKey(requestID, nodeID);
        return this.requestToCacheKeyMap.containsKey(requestKey);
    }

    public synchronized void loadTable(RequestID requestID, int nodeID, List[] records) {
        RequestKey requestKey = new RequestKey(requestID, nodeID);
        CacheKey cacheKey = (CacheKey)this.requestToCacheKeyMap.get(requestKey);
        HashMap existingMap = (HashMap)this.codeTableCache.get(cacheKey);
        if (existingMap == null) {
            existingMap = new HashMap();
            this.codeTableCache.put(cacheKey, existingMap);
        }
        for (int i2 = 0; i2 < records.length; ++i2) {
            List record = records[i2];
            Object keyValue = record.get(0);
            Object returnValue = record.get(1);
            existingMap.put(keyValue, returnValue);
        }
    }

    public synchronized Object lookupValue(String codeTable, String returnElement, String keyElement, Object keyValue) throws MetaMatrixComponentException {
        Object returnValue = null;
        CacheKey cacheKey = new CacheKey(codeTable, returnElement, keyElement);
        Map dataMap = (Map)this.codeTableCache.get(cacheKey);
        if (dataMap == null) {
            Object[] params = new Object[]{codeTable, keyElement, returnElement};
            throw new MetaMatrixComponentException(DQPPlugin.Util.getString("CodeTableCache.No_code_table", params));
        }
        returnValue = dataMap.get(keyValue);
        return returnValue;
    }

    public Set markCacheLoaded(RequestID requestID, int nodeID) {
        return this.markCacheDone(requestID, nodeID, false);
    }

    public Set errorLoadingCache(RequestID requestID, int nodeID) {
        return this.markCacheDone(requestID, nodeID, true);
    }

    private synchronized Set markCacheDone(RequestID requestID, int nodeID, boolean errorOccurred) {
        RequestKey requestKey = new RequestKey(requestID, nodeID);
        CacheKey cacheKey = (CacheKey)this.requestToCacheKeyMap.remove(requestKey);
        if (errorOccurred) {
            this.codeTableCache.remove(cacheKey);
        } else {
            this.cacheKeyDone.add(cacheKey);
        }
        WaitingRequests waitingRequests = (WaitingRequests)this.loadingCaches.remove(cacheKey);
        if (waitingRequests != null) {
            return waitingRequests.getWaitingRequestIDs();
        }
        return null;
    }

    public synchronized void clearAll() {
        int removedTables = 0;
        int removedRecords = 0;
        Iterator keyIter = this.cacheKeyDone.iterator();
        while (keyIter.hasNext()) {
            CacheKey cacheKey = (CacheKey)keyIter.next();
            Map codeTable = (Map)this.codeTableCache.remove(cacheKey);
            ++removedTables;
            removedRecords += codeTable.size();
        }
        this.cacheKeyDone.clear();
        LogManager.logInfo("DQP", DQPPlugin.Util.getString("CodeTableCache.Cleared_code_tables", new Object[]{new Integer(removedTables), new Integer(removedRecords)}));
    }

    private static class RequestKey {
        private RequestID requestID;
        private int nodeID;
        private int hashCode;

        public RequestKey(RequestID requestID, int nodeID) {
            this.requestID = requestID;
            this.nodeID = nodeID;
            this.hashCode = HashCodeUtil.hashCode(0, requestID);
            this.hashCode = HashCodeUtil.hashCode(this.hashCode, nodeID);
        }

        public RequestID getRequestID() {
            return this.requestID;
        }

        public int getNodeID() {
            return this.nodeID;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof RequestKey) {
                RequestKey other = (RequestKey)obj;
                return other.hashCode() == this.hashCode() && this.requestID.equals(other.requestID) && this.nodeID == other.nodeID;
            }
            return false;
        }
    }

    private static class WaitingRequests {
        Object primaryRequestID;
        Set additionalRequestIDs;

        public WaitingRequests(Object requestID) {
            this.primaryRequestID = requestID;
        }

        public void addRequestID(Object requestID) {
            if (this.additionalRequestIDs == null) {
                this.additionalRequestIDs = new HashSet(8, 0.9f);
            }
            this.additionalRequestIDs.add(requestID);
        }

        private Set getWaitingRequestIDs() {
            HashSet<Object> requestIDs = null;
            if (this.additionalRequestIDs != null) {
                requestIDs = new HashSet(this.additionalRequestIDs.size() + 1, 1.0f);
                requestIDs.addAll(this.additionalRequestIDs);
            } else {
                requestIDs = new HashSet<Object>(2, 1.0f);
            }
            if (this.primaryRequestID != null) {
                requestIDs.add(this.primaryRequestID);
            }
            return requestIDs;
        }
    }

    private static class CacheKey {
        private String codeTable;
        private String returnElement;
        private String keyElement;
        private int hashCode;

        public CacheKey(String codeTable, String returnElement, String keyElement) {
            this.codeTable = codeTable;
            this.returnElement = returnElement;
            this.keyElement = keyElement;
            this.hashCode = HashCodeUtil.hashCode(0, codeTable);
            this.hashCode = HashCodeUtil.hashCode(this.hashCode, returnElement);
            this.hashCode = HashCodeUtil.hashCode(this.hashCode, keyElement);
        }

        public String getCodeTable() {
            return this.codeTable;
        }

        public String getReturnElement() {
            return this.returnElement;
        }

        public String getKeyElement() {
            return this.keyElement;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (obj instanceof CacheKey) {
                CacheKey other = (CacheKey)obj;
                return other.hashCode() == this.hashCode() && this.codeTable.equals(other.codeTable) && this.returnElement.equals(other.returnElement) && this.keyElement.equals(other.keyElement);
            }
            return false;
        }
    }
}

