/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.datamgr.metadata;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.metadata.runtime.MetadataID;
import com.metamatrix.query.m.e;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MetadataIDImpl
implements MetadataID {
    private int type;
    private Object actualMetadataID;
    private String fullName;
    private e metadata;

    MetadataIDImpl(Object actualMetadataID, e metadata) throws MetaMatrixComponentException {
        this.actualMetadataID = actualMetadataID;
        this.metadata = metadata;
        try {
            this.fullName = metadata.getFullName(this.getActualMetadataID());
        }
        catch (QueryMetadataException ex) {
            throw new MetaMatrixComponentException((Throwable)ex, ex.getMessage());
        }
    }

    e getMetadata() {
        return this.metadata;
    }

    public int getType() {
        return this.type;
    }

    public List getChildIDs() throws ConnectorException {
        if (this.type == 1) {
            try {
                List children = this.metadata.getElementIDsInGroupID(this.actualMetadataID);
                ArrayList<MetadataIDImpl> childIDs = new ArrayList<MetadataIDImpl>(children.size());
                Iterator iter = children.iterator();
                while (iter.hasNext()) {
                    MetadataIDImpl id = new MetadataIDImpl(iter.next(), this.metadata);
                    id.setType(0);
                    childIDs.add(id);
                }
                return childIDs;
            }
            catch (QueryMetadataException e2) {
                throw new ConnectorException((Throwable)e2);
            }
            catch (MetaMatrixComponentException e3) {
                throw new ConnectorException((Throwable)e3);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public MetadataID getParentID() throws ConnectorException {
        if (this.type == 0) {
            try {
                MetadataIDImpl id = new MetadataIDImpl(this.metadata.getGroupIDForElementID(this.actualMetadataID), this.metadata);
                id.setType(1);
                return id;
            }
            catch (QueryMetadataException e2) {
                throw new ConnectorException((Throwable)e2);
            }
            catch (MetaMatrixComponentException e3) {
                throw new ConnectorException((Throwable)e3);
            }
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            MetadataIDImpl that = (MetadataIDImpl)obj;
            return this.actualMetadataID.equals(that.actualMetadataID);
        }
        return false;
    }

    public int hashCode() {
        return this.actualMetadataID.hashCode();
    }

    void setType(int type) {
        this.type = type;
    }

    Object getActualMetadataID() {
        return this.actualMetadataID;
    }

    public String getFullName() {
        return this.fullName;
    }

    public String getName() {
        String shortName = null;
        String fullName = this.getFullName();
        if (fullName != null && fullName.trim().length() != 0) {
            int index = fullName.lastIndexOf(".");
            shortName = index != -1 ? fullName.substring(index + 1) : fullName;
        }
        return shortName;
    }
}

