/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.datamgr.metadata;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.metadata.runtime.Element;
import com.metamatrix.dqp.internal.datamgr.metadata.MetadataIDImpl;
import com.metamatrix.dqp.internal.datamgr.metadata.TypeModelImpl;

public class ElementImpl
extends TypeModelImpl
implements Element {
    ElementImpl(MetadataIDImpl metadataID) {
        super(metadataID);
    }

    public Class getJavaType() throws ConnectorException {
        try {
            String elementType = this.getMetadata().getElementType(this.getActualID());
            return DataTypeManager.getDataTypeClass(elementType);
        }
        catch (QueryMetadataException e2) {
            throw new ConnectorException((Throwable)e2);
        }
        catch (MetaMatrixComponentException e3) {
            throw new ConnectorException((Throwable)e3);
        }
    }

    public int getPosition() throws ConnectorException {
        try {
            return this.getMetadata().getPosition(this.getActualID()) - 1;
        }
        catch (QueryMetadataException e2) {
            throw new ConnectorException((Throwable)e2);
        }
        catch (MetaMatrixComponentException e3) {
            throw new ConnectorException((Throwable)e3);
        }
    }

    public Object getMaximumValue() throws ConnectorException {
        try {
            return this.getMetadata().getMaximumValue(this.getActualID());
        }
        catch (QueryMetadataException e2) {
            throw new ConnectorException((Throwable)e2);
        }
        catch (MetaMatrixComponentException e3) {
            throw new ConnectorException((Throwable)e3);
        }
    }

    public Object getMinimumValue() throws ConnectorException {
        try {
            return this.getMetadata().getMinimumValue(this.getActualID());
        }
        catch (QueryMetadataException e2) {
            throw new ConnectorException((Throwable)e2);
        }
        catch (MetaMatrixComponentException e3) {
            throw new ConnectorException((Throwable)e3);
        }
    }

    public int getSearchability() throws ConnectorException {
        try {
            boolean comparable = this.getMetadata().elementSupports(this.getActualID(), 2);
            boolean likable = this.getMetadata().elementSupports(this.getActualID(), 1);
            if (comparable) {
                if (likable) {
                    return 3;
                }
                return 1;
            }
            if (likable) {
                return 2;
            }
            return 0;
        }
        catch (QueryMetadataException e2) {
            throw new ConnectorException((Throwable)e2);
        }
        catch (MetaMatrixComponentException e3) {
            throw new ConnectorException((Throwable)e3);
        }
    }

    public boolean isAutoIncremented() throws ConnectorException {
        try {
            return this.getMetadata().elementSupports(this.getActualID(), 8);
        }
        catch (QueryMetadataException e2) {
            throw new ConnectorException((Throwable)e2);
        }
        catch (MetaMatrixComponentException e3) {
            throw new ConnectorException((Throwable)e3);
        }
    }

    public boolean isCaseSensitive() throws ConnectorException {
        try {
            return this.getMetadata().elementSupports(this.getActualID(), 9);
        }
        catch (QueryMetadataException e2) {
            throw new ConnectorException((Throwable)e2);
        }
        catch (MetaMatrixComponentException e3) {
            throw new ConnectorException((Throwable)e3);
        }
    }

    public String getNativeType() throws ConnectorException {
        try {
            return this.getMetadata().getNativeType(this.getActualID());
        }
        catch (QueryMetadataException e2) {
            throw new ConnectorException((Throwable)e2);
        }
        catch (MetaMatrixComponentException e3) {
            throw new ConnectorException((Throwable)e3);
        }
    }
}

