/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.datamgr.impl;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.data.api.Connection;
import com.metamatrix.data.api.Connector;
import com.metamatrix.data.api.Execution;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IBatchedUpdates;
import com.metamatrix.data.language.IBulkInsert;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.xa.api.TransactionContext;
import com.metamatrix.data.xa.api.XAConnector;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.datamgr.ConnectorManager;
import com.metamatrix.dqp.internal.datamgr.impl.AtomicRequestID;
import com.metamatrix.dqp.internal.datamgr.impl.ConnectorEnvironmentImpl;
import com.metamatrix.dqp.internal.datamgr.impl.ExecutionContextImpl;
import com.metamatrix.dqp.internal.datamgr.impl.IConnectorStateManager;
import com.metamatrix.dqp.internal.datamgr.language.LanguageBridgeFactory;
import com.metamatrix.dqp.internal.datamgr.metadata.MetadataFactory;
import com.metamatrix.dqp.internal.datamgr.metadata.RuntimeMetadataImpl;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.query.m.e;
import com.metamatrix.query.o.j.l;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class ConnectorStateManager
implements IConnectorStateManager {
    private static final short IDLE = 0;
    private static final short PROCESSING = 1;
    Connector connector;
    ConnectorManager connectorManager;
    private Map requestStates;
    private Timer timer;

    public ConnectorStateManager(Connector connector, ConnectorManager connectorManager) {
        this.connector = connector;
        this.connectorManager = connectorManager;
        this.requestStates = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createAndAddRequestState(AtomicRequestMessage request) throws ConnectorException {
        AtomicRequestID requestID = new AtomicRequestID(request);
        ConnectorRequestState cState = new ConnectorRequestState(request);
        Map map = this.requestStates;
        synchronized (map) {
            this.requestStates.put(requestID, cState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectorRequestState getState(AtomicRequestMessage msg) {
        Map map = this.requestStates;
        synchronized (map) {
            return (ConnectorRequestState)this.requestStates.get(new AtomicRequestID(msg));
        }
    }

    public Execution getExecution(AtomicRequestMessage requestMsg) {
        ConnectorRequestState cState = this.getState(requestMsg);
        if (cState != null) {
            return cState.getExecution();
        }
        return null;
    }

    public Execution createExecution(AtomicRequestMessage requestMsg, e queryMetadata) throws ConnectorException {
        Execution execution = null;
        ConnectorRequestState cState = this.getState(requestMsg);
        if (cState != null) {
            execution = cState.createExecution(this.connector, requestMsg, queryMetadata);
        }
        return execution;
    }

    public ICommand getTranslatedCommand(AtomicRequestMessage requestMsg) {
        ConnectorRequestState cState = this.getState(requestMsg);
        if (cState != null) {
            return cState.getTranslatedCommand();
        }
        return null;
    }

    public int getExecutionMode(AtomicRequestMessage requestMsg) {
        ConnectorRequestState cState = this.getState(requestMsg);
        if (cState != null) {
            return cState.getExecutionMode();
        }
        return -1;
    }

    public Connection getConnection(AtomicRequestMessage requestMsg, boolean shouldCreate) throws ConnectorException {
        Connection connection = null;
        ConnectorRequestState cState = this.getState(requestMsg);
        if (cState != null) {
            connection = shouldCreate ? cState.getConnection(this.connector) : cState.getConnection();
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequestState(AtomicRequestMessage requestMsg) {
        Map map = this.requestStates;
        synchronized (map) {
            this.requestStates.remove(new AtomicRequestID(requestMsg));
            ConnectorEnvironmentImpl impl = (ConnectorEnvironmentImpl)this.connectorManager.getConnectorEnvironment();
            impl.removeValueReferences(new AtomicRequestID(requestMsg));
        }
    }

    public boolean hasValueReferences(AtomicRequestMessage requestMsg) {
        ConnectorEnvironmentImpl impl = (ConnectorEnvironmentImpl)this.connectorManager.getConnectorEnvironment();
        return impl.hasValueReferences(new AtomicRequestID(requestMsg));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled(AtomicRequestMessage requestMsg) {
        ConnectorRequestState cState = this.getState(requestMsg);
        if (cState == null) {
            return true;
        }
        Object object = cState.stateLock;
        synchronized (object) {
            return cState.isCancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setRequestCancelled(AtomicRequestMessage requestMsg) {
        ConnectorRequestState cState = this.getState(requestMsg);
        if (cState == null) {
            return false;
        }
        Object object = cState.stateLock;
        synchronized (object) {
            cState.isCancelled = true;
            return cState.processingState == 0;
        }
    }

    int size() {
        return this.requestStates.size();
    }

    public boolean isActive(AtomicRequestMessage requestMsg) {
        boolean active = false;
        ConnectorRequestState cState = this.getState(requestMsg);
        if (cState != null) {
            active = true;
        }
        return active;
    }

    public void addRowsProcessed(AtomicRequestMessage requestMsg, int rowCnt) {
        ConnectorRequestState cState = this.getState(requestMsg);
        if (cState != null) {
            cState.rowCount += rowCnt;
        }
    }

    public int getRowsProcessed(AtomicRequestMessage requestMsg) {
        ConnectorRequestState cState = this.getState(requestMsg);
        if (cState != null) {
            return cState.rowCount;
        }
        return 0;
    }

    public com.metamatrix.common.xa.TransactionContext getTransactionContext(AtomicRequestMessage requestMsg) {
        ConnectorRequestState cState = this.getState(requestMsg);
        if (cState != null) {
            return cState.requestMsg.getTransactionContext();
        }
        return null;
    }

    public boolean startProcessing(AtomicRequestMessage requestMessage) {
        ConnectorRequestState cState = this.getState(requestMessage);
        if (cState == null) {
            return false;
        }
        Object object = cState.stateLock;
        synchronized (object) {
            if (cState.isCancelled) {
                return false;
            }
            if (cState.processingState == 1) {
                throw new IllegalStateException(DQPPlugin.Util.getString("ConnectorStateManager.invalid_state_1", requestMessage.getRequestID()));
            }
            if (cState.processingState == 0) {
                cState.processingState = 1;
                return true;
            }
            throw new IllegalStateException(DQPPlugin.Util.getString("ConnectorStateManager.invalid_state_2", requestMessage.getRequestID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endProcessing(AtomicRequestMessage requestMessage) {
        ConnectorRequestState cState = this.getState(requestMessage);
        if (cState == null) {
            throw new IllegalStateException(DQPPlugin.Util.getString("ConnectorStateManager.invalid_state_3", requestMessage.getRequestID()));
        }
        Object object = cState.stateLock;
        synchronized (object) {
            if (cState.processingState == 0) {
                throw new IllegalStateException(DQPPlugin.Util.getString("ConnectorStateManager.invalid_state_4", requestMessage.getRequestID()));
            }
            if (cState.processingState != 1) {
                throw new IllegalStateException(DQPPlugin.Util.getString("ConnectorStateManager.invalid_state_5", requestMessage.getRequestID()));
            }
            cState.processingState = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask(TimerTask task, long delay) {
        ConnectorStateManager connectorStateManager = this;
        synchronized (connectorStateManager) {
            if (this.timer == null) {
                this.timer = new Timer();
            }
        }
        this.timer.schedule(task, delay);
    }

    public synchronized void shutdown() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    private static class ConnectorRequestState {
        Connection connection;
        private Object connectionLock = new Object();
        SecurityContext securityContext;
        int executionMode;
        Execution execution;
        private Object executionLock = new Object();
        AtomicRequestID requestID;
        AtomicRequestMessage requestMsg;
        ICommand translatedCommand;
        Object stateLock = new Object();
        short processingState = 0;
        boolean isCancelled = false;
        int rowCount = 0;

        ConnectorRequestState(AtomicRequestMessage requestMessage) {
            this.requestMsg = requestMessage;
            this.requestID = new AtomicRequestID(this.requestMsg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Connection getConnection() {
            Object object = this.connectionLock;
            synchronized (object) {
                return this.connection;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Connection getConnection(Connector connector) throws ConnectorException {
            Object object = this.connectionLock;
            synchronized (object) {
                if (this.connection == null) {
                    try {
                        this.securityContext = new ExecutionContextImpl(this.requestMsg.getVdbName(), this.requestMsg.getVdbVersion(), this.requestMsg.getUserName(), this.requestMsg.getTrustedPayload(), this.requestMsg.getExecutionPayload(), this.requestMsg.getConnectionID(), this.requestMsg.useResultSetCache() && this.requestMsg.getCommand().ga(), new AtomicRequestID(this.requestMsg));
                        if (this.requestMsg.isTransactional() && connector instanceof XAConnector) {
                            String txnID = this.requestMsg.getTransactionContext().getTopLevelTxnID().asString() + Thread.currentThread().getName();
                            this.connection = ((XAConnector)connector).getXAConnection(this.securityContext, new TransactionContext(this, txnID){
                                private final /* synthetic */ String val$txnID;
                                private final /* synthetic */ ConnectorRequestState this$0;
                                {
                                    this.this$0 = this$0;
                                    this.val$txnID = val$txnID;
                                }

                                public Object getTransactionId() {
                                    return this.val$txnID;
                                }
                            });
                        } else {
                            this.connection = connector.getConnection(this.securityContext);
                        }
                    }
                    catch (ConnectorException e2) {
                        LogManager.logError("CONNECTOR", (Throwable)e2, e2.getMessage());
                        throw e2;
                    }
                }
                return this.connection;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Execution getExecution() {
            Object object = this.executionLock;
            synchronized (object) {
                return this.execution;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Execution createExecution(Connector connector, AtomicRequestMessage aqrMsg, e queryMetadata) throws ConnectorException {
            Object object = this.executionLock;
            synchronized (object) {
                if (this.execution == null) {
                    this.getConnection(connector);
                    try {
                        l command = this.requestMsg.getCommand();
                        LanguageBridgeFactory factory = new LanguageBridgeFactory(queryMetadata);
                        this.translatedCommand = factory.translate(command);
                        RuntimeMetadataImpl rmd = new RuntimeMetadataImpl(new MetadataFactory(queryMetadata));
                        if (this.translatedCommand instanceof IQuery) {
                            if (this.connection.getCapabilities().supportsExecutionMode(0)) {
                                this.executionMode = 0;
                            } else if (this.connection.getCapabilities().supportsExecutionMode(5)) {
                                this.executionMode = 5;
                            }
                        } else {
                            this.executionMode = this.translatedCommand instanceof IProcedure ? 2 : (this.translatedCommand instanceof IBatchedUpdates ? 3 : (this.translatedCommand instanceof IBulkInsert ? 4 : 1));
                        }
                        this.execution = this.connection.createExecution(this.executionMode, this.securityContext, rmd);
                    }
                    catch (MetaMatrixComponentException e2) {
                        throw new ConnectorException((Throwable)e2);
                    }
                }
                return this.execution;
            }
        }

        AtomicRequestMessage getRequestMsg() {
            return this.requestMsg;
        }

        public ICommand getTranslatedCommand() {
            return this.translatedCommand;
        }

        public int getExecutionMode() {
            return this.executionMode;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (!(o2 instanceof ConnectorRequestState)) {
                return false;
            }
            ConnectorRequestState connectorRequestState = (ConnectorRequestState)o2;
            return this.requestID.equals(connectorRequestState.requestID);
        }

        public int hashCode() {
            return this.requestID.hashCode();
        }
    }
}

