/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.datamgr.impl;

import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.TypeFacility;
import com.metamatrix.data.api.ValueReference;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.dqp.datamgr.InternalConnectorEnvironment;
import com.metamatrix.dqp.internal.datamgr.ConnectorID;
import com.metamatrix.dqp.internal.datamgr.ExecutionContextInternal;
import com.metamatrix.dqp.internal.datamgr.impl.AtomicRequestID;
import com.metamatrix.dqp.internal.datamgr.impl.TypeFacilityImpl;
import com.metamatrix.dqp.internal.datamgr.impl.ValueIDImpl;
import com.metamatrix.dqp.internal.datamgr.language.LanguageFactoryImpl;
import com.metamatrix.query.i.e;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ConnectorEnvironmentImpl
implements ConnectorEnvironment,
InternalConnectorEnvironment {
    public static final String CONNECTOR_NAME_PROPERTY = "ServiceName";
    private static final TypeFacility TYPE_FACILITY = new TypeFacilityImpl();
    private ConnectorLogger logger;
    private Properties properties;
    private ConnectorID connectorID;
    private ApplicationEnvironment env;
    private Map atomicRequestMap = new HashMap();
    private int id = 0;

    public ConnectorEnvironmentImpl(Properties connectorProperties, ConnectorLogger logger, ConnectorID connectorID) {
        this(connectorProperties, logger, connectorID, null);
    }

    public ConnectorEnvironmentImpl(Properties connectorProperties, ConnectorLogger logger, ConnectorID connectorID, ApplicationEnvironment env) {
        this.properties = connectorProperties;
        this.logger = logger;
        this.connectorID = connectorID;
        this.env = env;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getConnectorName() {
        return this.properties.getProperty(CONNECTOR_NAME_PROPERTY);
    }

    public ConnectorLogger getLogger() {
        return this.logger;
    }

    public Object createValueReferenceReplacement(ValueReference valueReference, ExecutionContext context) {
        AtomicRequestID atomicID = ((ExecutionContextInternal)context).getAtomicRequestID();
        ValueIDImpl valueID = new ValueIDImpl(this.nextID(), valueReference.isBinary(), this.connectorID.getID(), atomicID.getID());
        this.putValueReference(valueID, valueReference, atomicID);
        return valueID;
    }

    private synchronized void putValueReference(e valueID, ValueReference valueReference, AtomicRequestID atomicID) {
        String requestID = atomicID.getID();
        HashMap<e, ValueReference> valueMap = (HashMap<e, ValueReference>)this.atomicRequestMap.get(requestID);
        if (valueMap == null) {
            valueMap = new HashMap<e, ValueReference>();
            this.atomicRequestMap.put(requestID, valueMap);
        }
        valueMap.put(valueID, valueReference);
    }

    public synchronized ValueReference getReference(e valueID) {
        String requestID = ((ValueIDImpl)valueID).getAtomicRequestID();
        Map valueMap = (Map)this.atomicRequestMap.get(requestID);
        if (valueMap == null) {
            return null;
        }
        return (ValueReference)valueMap.get(valueID);
    }

    public synchronized void removeValueReferences(AtomicRequestID atomicID) {
        String requestID = atomicID.getID();
        this.atomicRequestMap.remove(requestID);
    }

    public synchronized boolean hasValueReferences(AtomicRequestID atomicID) {
        String requestID = atomicID.getID();
        boolean result = this.atomicRequestMap.containsKey(requestID);
        return result;
    }

    private synchronized int nextID() {
        return this.id++;
    }

    public Object findResource(String resourceName) {
        return this.env.findService(resourceName);
    }

    public ILanguageFactory getLanguageFactory() {
        return LanguageFactoryImpl.INSTANCE;
    }

    public TypeFacility getTypeFacility() {
        return TYPE_FACILITY;
    }
}

