/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.cache.connector;

import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.api.ProcedureExecution;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.dqp.internal.cache.ResultSetCache;
import com.metamatrix.dqp.internal.cache.connector.CacheBaseExecution;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CacheProcedureExecution
extends CacheBaseExecution
implements ProcedureExecution {
    private ProcedureExecution actualExec;

    public CacheProcedureExecution(ProcedureExecution actualExec, ResultSetCache cache, ExecutionContext executionContext) {
        super(actualExec, cache, executionContext);
        this.actualExec = actualExec;
    }

    public void execute(IProcedure procedure, int maxBatchSize) throws ConnectorException {
        super.setMaxBatchSize(maxBatchSize);
        ArrayList<String> outParameter = new ArrayList<String>();
        List params = procedure.getParameters();
        if (params != null && !params.isEmpty()) {
            Iterator iter = params.iterator();
            while (iter.hasNext()) {
                IParameter param = (IParameter)iter.next();
                if (param.getDirection() != 3 && param.getDirection() != 1 && param.getDirection() != 2) continue;
                outParameter.add(param.getMetadataID().getFullName());
            }
        }
        super.setParameters(outParameter);
        if (!super.areResultsInCache(procedure.toString())) {
            this.actualExec.execute(procedure, maxBatchSize);
        }
    }

    public Object getOutputValue(IParameter parameter) throws ConnectorException {
        if (super.hasResults()) {
            return super.getOutputValue(parameter.getMetadataID().getFullName());
        }
        Object outValue = this.actualExec.getOutputValue(parameter);
        super.setOutputValue(parameter.getMetadataID().getFullName(), outValue);
        return outValue;
    }
}

