/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.cache;

import com.metamatrix.common.util.Intervals;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CursorReceiverWindowBuffer {
    Intervals bufferIntervals = new Intervals();
    private int[] currentIntervalsBoundingRange;
    private List[] currentIntervalsData;
    private Map buffer = new HashMap();

    public void add(int[] range, List[] data) {
        if (range[1] >= range[0]) {
            this.bufferIntervals.addInterval(range[0], range[1]);
            this.buffer.put(new Intervals(range[0], range[1]), data);
        }
    }

    public List getRow(int index) {
        if (this.currentIntervalsBoundingRange != null && this.currentIntervalsBoundingRange[0] <= index && this.currentIntervalsBoundingRange[1] >= index) {
            return this.currentIntervalsData[index - this.currentIntervalsBoundingRange[0]];
        }
        Iterator iterator = this.buffer.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Intervals i2 = (Intervals)entry.getKey();
            if (!i2.containsInterval(index, index)) continue;
            this.currentIntervalsData = (List[])entry.getValue();
            this.currentIntervalsBoundingRange = i2.getBoundingInterval();
            return this.currentIntervalsData[index - this.currentIntervalsBoundingRange[0]];
        }
        this.currentIntervalsData = null;
        this.currentIntervalsBoundingRange = null;
        throw new IndexOutOfBoundsException();
    }

    public Intervals getContents() {
        return this.bufferIntervals.copy();
    }

    public void removeFromCache(Intervals toRemove) {
        if (toRemove.hasIntervals()) {
            Iterator iterator = this.buffer.keySet().iterator();
            while (iterator.hasNext()) {
                Intervals i2 = (Intervals)iterator.next();
                int[] range = i2.getBoundingInterval();
                if (!toRemove.containsInterval(range[0], range[1])) continue;
                iterator.remove();
                this.bufferIntervals.removeInterval(range[0], range[1]);
            }
        }
    }

    public List[] getAllRows() {
        if (!this.bufferIntervals.isContiguous()) {
            throw new IndexOutOfBoundsException();
        }
        int baseIndex = this.bufferIntervals.getBoundingInterval()[0];
        int size = this.bufferIntervals.getBoundingInterval()[1] - baseIndex + 1;
        List[] result = new List[size];
        for (int i2 = 0; i2 < size; ++i2) {
            result[i2 + baseIndex] = this.getRow(i2);
        }
        return result;
    }

    public boolean containsInterval(int begin, int end) {
        if (this.currentIntervalsBoundingRange != null && this.currentIntervalsBoundingRange[0] <= begin && this.currentIntervalsBoundingRange[1] >= end) {
            return true;
        }
        return this.bufferIntervals.containsInterval(begin, end);
    }
}

