/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.application;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.basic.BasicApplication;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.api.ServerListener;
import com.metamatrix.common.comm.exception.ApplicationException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.xa.TransactionID;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.application.ClientConnectionListener;
import com.metamatrix.dqp.application.DQP;
import com.metamatrix.dqp.internal.process.DQPCore;
import com.metamatrix.dqp.message.CloseMessage;
import com.metamatrix.dqp.message.CursorRequestMessage;
import com.metamatrix.dqp.message.DQPInboundMessage;
import com.metamatrix.dqp.message.MetaDataMessage;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.dqp.message.TerminateConnectionMessage;
import com.metamatrix.dqp.message.TransactionMessage;
import com.metamatrix.dqp.message.XMLSchemaMessage;
import com.metamatrix.dqp.service.ConfigurationService;
import com.metamatrix.dqp.service.TrackingService;
import com.metamatrix.internal.core.text.MessageFormat;
import java.util.Properties;

public class DQPComponent
extends BasicApplication
implements DQP {
    DQPCore core;
    private ServerListener listenerFilter;
    private TrackingService tracker;
    private ClientConnectionListener connectionListener = null;
    private ClientConnectionListener internalConnectionListener = null;

    public DQPComponent() {
    }

    public DQPComponent(ClientConnectionListener listener) {
        this.connectionListener = listener;
    }

    public void initialize(Properties props) throws ApplicationInitializationException {
        super.initialize(props);
    }

    public void start() {
        this.core = new DQPCore(this.getEnvironment());
        this.listenerFilter = new InternalServerListener();
        this.tracker = (TrackingService)this.getEnvironment().findService("dqp.tracking");
        ConfigurationService configService = (ConfigurationService)this.getEnvironment().findService("dqp.configuration");
        if (configService != null) {
            try {
                this.internalConnectionListener = configService.getConnectionListener();
            }
            catch (MetaMatrixComponentException e2) {
                this.internalConnectionListener = null;
            }
        }
    }

    public void stop() throws ApplicationLifecycleException {
        super.stop();
        this.core.stop();
    }

    private Message processInternal(ClientConnection connection, DQPInboundMessage incomingMessage, String messageKey) {
        DQPInboundMessage message = incomingMessage;
        incomingMessage.assignToClientConnection(connection);
        incomingMessage.setUserParameters(connection);
        incomingMessage.setMessageKey(messageKey);
        if (DQPPlugin.DEBUG) {
            Object[] params = new Object[]{connection.getConnectionProperty("connectionID"), incomingMessage};
            LogManager.logInfo("DQP", MessageFormat.format("DQPComponent.processInternal - ClientConnection ID: {0} Message: {1}", params));
        }
        Message result = null;
        try {
            result = this.core.process(incomingMessage);
        }
        catch (Throwable e2) {
            String msg = DQPPlugin.Util.getString("DQPComponent.DQPComponent.processInternal__Received_exception_processing_request");
            LogManager.logError("DQP", e2, msg);
            if (message instanceof RequestMessage) {
                ResultsMessage failureMsg = new ResultsMessage((RequestMessage)message, false);
                failureMsg.setException(e2);
                result = failureMsg;
                this.logCommandError((RequestMessage)message);
            }
            if (message instanceof CursorRequestMessage) {
                ResultsMessage failureMsg = new ResultsMessage((CursorRequestMessage)message);
                failureMsg.setException(e2);
                result = failureMsg;
            }
            if (message instanceof MetaDataMessage) {
                MetaDataMessage failureMsg = new MetaDataMessage();
                failureMsg.setException(e2);
                result = failureMsg;
            }
            if (message instanceof XMLSchemaMessage) {
                XMLSchemaMessage failureMsg = new XMLSchemaMessage(((XMLSchemaMessage)message).getDocName());
                failureMsg.setException(e2);
                result = failureMsg;
            }
            if (message instanceof TransactionMessage) {
                TransactionMessage failureMsg = (TransactionMessage)message;
                failureMsg.setException(e2);
                result = failureMsg;
            }
            ResultsMessage failureMsg = new ResultsMessage();
            failureMsg.setException(e2);
            result = failureMsg;
        }
        return result;
    }

    protected void setListenerFilter(ServerListener serverListener) {
        this.listenerFilter = serverListener;
    }

    public void connectionAdded(ClientConnection connection) {
        if (this.connectionListener != null) {
            this.connectionListener.connectionAdded(connection);
        }
        if (this.internalConnectionListener != null) {
            this.internalConnectionListener.connectionAdded(connection);
        }
        this.listenerFilter.connectionAdded(connection);
    }

    public void connectionRemoved(ClientConnection connection) {
        this.listenerFilter.connectionRemoved(connection);
        if (this.internalConnectionListener != null) {
            this.internalConnectionListener.connectionRemoved(connection);
        }
        if (this.connectionListener != null) {
            this.connectionListener.connectionRemoved(connection);
        }
    }

    public void connectionTerminated(ClientConnection connection) {
        this.listenerFilter.connectionRemoved(connection);
        if (this.internalConnectionListener != null) {
            this.internalConnectionListener.connectionTerminated(connection);
        }
        if (this.connectionListener != null) {
            this.connectionListener.connectionTerminated(connection);
        }
    }

    public void receive(ClientConnection connection, Message message, String messageKey) {
        if (message instanceof TerminateConnectionMessage) {
            this.connectionTerminated(connection);
        } else {
            this.listenerFilter.receive(connection, message, messageKey);
        }
    }

    public Message receive(ClientConnection connection, Message message) throws ApplicationException {
        if (message instanceof TerminateConnectionMessage) {
            this.connectionTerminated(connection);
            return null;
        }
        return this.listenerFilter.receive(connection, message);
    }

    private void logCommandError(RequestMessage request) {
        if (this.tracker == null || !this.tracker.willRecordMMCmd()) {
            return;
        }
        RequestID rID = request.getRequestID();
        TransactionID transactionID = null;
        if (request.isTransactional() && request.getTransactionContext() != null) {
            transactionID = request.getTransactionContext().getTopLevelTxnID();
        }
        this.tracker.log(rID.toString(), transactionID == null ? null : transactionID.asString(), (short)2, (short)4, request.getRequestID().getConnectionID(), (String)request.getClientConnection().getConnectionProperty("ApplicationName"), request.getUserName(), request.getVdbName(), request.getVdbVersion(), null, -1);
    }

    class InternalServerListener
    implements ServerListener {
        InternalServerListener() {
        }

        public void connectionAdded(ClientConnection connection) {
        }

        public void connectionRemoved(ClientConnection connection) {
            CloseMessage closeMsg = new CloseMessage();
            closeMsg.assignToClientConnection(connection);
            closeMsg.setUserParameters(connection);
            DQPComponent.this.processInternal(connection, closeMsg, null);
        }

        public Message receive(ClientConnection connection, Message message) throws ApplicationException {
            if (message instanceof DQPInboundMessage) {
                return DQPComponent.this.processInternal(connection, (DQPInboundMessage)message, null);
            }
            return null;
        }

        public void receive(ClientConnection connection, Message message, String messageKey) {
            Message msg = DQPComponent.this.processInternal(connection, (DQPInboundMessage)message, messageKey);
            if (msg != null) {
                try {
                    connection.send(msg, messageKey);
                }
                catch (CommunicationException e2) {
                    Object[] params = new Object[]{connection.getConnectionProperty("user")};
                    String emsg = DQPPlugin.Util.getString("DQPComponent.DQPComponent.receive__Unable_to_deliver_message_to_client_[{0}].", params);
                    if (msg instanceof ResultsMessage && ((ResultsMessage)msg).getException() != null) {
                        params = new Object[]{connection.getConnectionProperty("user"), ((ResultsMessage)msg).getException()};
                        emsg = DQPPlugin.Util.getString("DQPComponent.DQPComponent.receive__Unable_to_deliver_message_to_client_[{0}]._Original_exception_was__{1}", params);
                    }
                    LogManager.logError("DQP", (Throwable)e2, emsg);
                }
            }
        }
    }
}

