/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.services;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.common.protocol.URLHelper;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.PasswordCryptoFactory;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.dqp.application.ClientConnectionListener;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.embedded.configuration.ExtensionModuleReader;
import com.metamatrix.dqp.embedded.configuration.ExtensionModuleWriter;
import com.metamatrix.dqp.embedded.configuration.ServerConfigFileReader;
import com.metamatrix.dqp.embedded.configuration.ServerConfigFileWriter;
import com.metamatrix.dqp.embedded.configuration.UDFSource;
import com.metamatrix.dqp.embedded.configuration.VDBConfigurationReader;
import com.metamatrix.dqp.embedded.configuration.VDBConfigurationWriter;
import com.metamatrix.dqp.embedded.services.EmbeddedBaseDQPService;
import com.metamatrix.dqp.service.ConfigurationService;
import com.metamatrix.dqp.service.DQPServiceRegistry;
import com.metamatrix.dqp.service.VDBLifeCycleListener;
import com.metamatrix.license.LicenseChecker;
import com.metamatrix.license.exception.LicenseException;
import com.metamatrix.query.function.g;
import com.metamatrix.vdb.internal.runtime.model.BasicVDBDefn;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class EmbeddedConfigurationService
extends EmbeddedBaseDQPService
implements ConfigurationService {
    private static final String VDB_LIST_SEPARATOR = ";";
    private static final String VDB = ".vdb";
    private static final String DEF = ".def";
    Properties userPreferences = null;
    Map loadedVDBs = new HashMap();
    Map loadedConnectorBindings = new HashMap();
    Map loadedConnectorTypes = new HashMap();
    Map availableVDBFiles = null;
    ConfigurationModelContainer configurationModel = null;
    Map inuseVDBs = new HashMap();
    ArrayList vdbLifeCycleListeners = new ArrayList();
    UDFSource udfSource = null;
    HashSet clientConnections = new HashSet();

    public EmbeddedConfigurationService(DQPServiceRegistry svcRegistry) throws MetaMatrixComponentException {
        super("dqp.configuration", svcRegistry);
    }

    boolean valid(String str) {
        if (str != null) {
            return (str = str.trim()).length() > 0;
        }
        return false;
    }

    public URL getSystemVdb() {
        String systemVDB = this.userPreferences.getProperty("dqp.metadata.systemURL");
        if (this.valid(systemVDB)) {
            return this.getFullyQualifiedPath(systemVDB);
        }
        return null;
    }

    public Properties getSystemProperties() throws MetaMatrixComponentException {
        return this.userPreferences;
    }

    public void setSystemProperty(String key, String value) throws MetaMatrixComponentException {
        this.userPreferences.setProperty(key, value);
        DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.add_system_property", new Object[]{key, value});
        this.configurationModel = ServerConfigFileWriter.addProperty(this.getSystemConfiguration(), key, value);
        this.saveSystemConfiguration(this.configurationModel);
    }

    public void updateSystemProperties(Properties properties) throws MetaMatrixComponentException {
        this.userPreferences.putAll((Map<?, ?>)properties);
        DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.update_system_properties", new Object[]{properties});
        this.configurationModel = ServerConfigFileWriter.addProperties(this.getSystemConfiguration(), properties);
        this.saveSystemConfiguration(this.configurationModel);
    }

    public ConfigurationModelContainer getSystemConfiguration() throws MetaMatrixComponentException {
        if (this.configurationModel == null) {
            try {
                URL configFile = this.getConfigFile();
                ServerConfigFileReader configReader = new ServerConfigFileReader(configFile);
                this.configurationModel = configReader.getConfiguration();
            }
            catch (IOException e2) {
                throw new MetaMatrixComponentException(e2);
            }
        }
        return this.configurationModel;
    }

    void saveSystemConfiguration(ConfigurationModelContainer model) throws MetaMatrixComponentException {
        DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.savingConfiguration", null);
        URL configFile = this.getConfigFile();
        ServerConfigFileWriter.write(model, configFile);
    }

    public URL getConfigFile() {
        String configFile = this.userPreferences.getProperty("dqp.configFile");
        if (this.valid(configFile)) {
            return this.getFullyQualifiedPath(configFile);
        }
        return null;
    }

    public URL getUDFFile() {
        String udfFile = this.userPreferences.getProperty("dqp.userDefinedFunctionsFile");
        if (this.valid(udfFile)) {
            return this.getFullyQualifiedPath(udfFile);
        }
        return null;
    }

    public URL[] getUDFClasspath() {
        String classpath = this.userPreferences.getProperty("dqp.userDefinedFunctionsClasspath");
        if (this.valid(classpath)) {
            try {
                URL context = this.getExtensionPath();
                return ExtensionModuleReader.resolveExtensionClasspath(classpath, context);
            }
            catch (IOException e2) {
                DQPEmbeddedPlugin.logError(e2, "EmbeddedConfigurationService.udf_classspath_failure", new Object[0]);
            }
        }
        return null;
    }

    public URL getLogFile() {
        String logFile = this.userPreferences.getProperty("dqp.logFile");
        if (this.valid(logFile)) {
            return this.getFullyQualifiedPath(logFile);
        }
        return null;
    }

    public String getLogLevel() {
        String level = this.userPreferences.getProperty("dqp.logLevel");
        if (level == null) {
            level = "3";
        }
        return level;
    }

    public String captureSystemStreams() throws MetaMatrixComponentException {
        return this.userPreferences.getProperty("dqp.captureSystemStreams");
    }

    public List getVDBs() throws MetaMatrixComponentException {
        return new ArrayList(this.loadedVDBs.values());
    }

    public VDBDefn getVDB(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        return (VDBDefn)this.loadedVDBs.get(this.vdbId(vdbName, vdbVersion));
    }

    URL getVDBLocation(VDBDefn vdb) throws MetaMatrixComponentException {
        URL vdbFile;
        if (this.availableVDBFiles != null && this.availableVDBFiles.size() > 0 && (vdbFile = (URL)this.availableVDBFiles.get(this.vdbId(vdb))) != null) {
            return vdbFile;
        }
        String vdbName = vdb.getName() + "_" + vdb.getVersion() + VDB;
        URL fileToSave = this.getFullyQualifiedPath(this.getVDBSaveLocation(), vdbName);
        ((BasicVDBDefn)vdb).setFileName(vdbName);
        return fileToSave;
    }

    URL getVDBSaveLocation() throws MetaMatrixComponentException {
        URL[] urls = this.getVDBLocations();
        for (int i2 = 0; i2 < urls.length; ++i2) {
            String vdblocation = urls[i2].toString().toLowerCase();
            if (vdblocation.endsWith(VDB) || vdblocation.endsWith(DEF)) continue;
            return urls[i2];
        }
        return urls[0];
    }

    public VDBDefn saveVDB(VDBDefn srcVdb, String version) throws MetaMatrixComponentException {
        if (srcVdb.getStatus() == 4 && this.canDeleteVDB(srcVdb)) {
            return this.deleteVDB(srcVdb.getName(), srcVdb.getVersion());
        }
        BasicVDBDefn vdb = (BasicVDBDefn)srcVdb;
        if (version.equals("NEXT_VDB_VERSION")) {
            String nextVersion = Integer.toString(this.getNextVdbVersion(vdb.getName()));
            vdb.setVersion(nextVersion);
            String archiveFileName = vdb.getFileName();
            int index = archiveFileName.indexOf(46);
            if (index != -1) {
                archiveFileName = archiveFileName.substring(0, index) + "_" + nextVersion + VDB;
            }
            vdb.setFileName(archiveFileName);
        }
        URL vdbFile = this.getVDBLocation(vdb);
        VDBConfigurationWriter.write(vdb, vdbFile);
        DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.vdb_saved", new Object[]{vdb.getName(), vdb.getVersion(), vdbFile});
        if (this.loadedVDBs.get(this.vdbId(vdb)) == null) {
            this.notifyVDBLoad(srcVdb.getName(), srcVdb.getVersion());
        }
        this.loadedVDBs.put(this.vdbId(vdb), vdb);
        this.availableVDBFiles.put(this.vdbId(vdb), vdbFile);
        return vdb;
    }

    int getNextVdbVersion(String vdbName) {
        int latestVersion = 0;
        Iterator i2 = this.loadedVDBs.values().iterator();
        while (i2.hasNext()) {
            VDBDefn v2 = (VDBDefn)i2.next();
            if (!v2.getName().equals(vdbName)) continue;
            latestVersion = Math.max(latestVersion, Integer.parseInt(v2.getVersion()));
        }
        return latestVersion + 1;
    }

    public VDBDefn deleteVDB(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        VDBDefn vdb = this.getVDB(vdbName, vdbVersion);
        if (vdb != null) {
            URL vdbFile = this.getVDBLocation(vdb);
            VDBConfigurationWriter.deleteVDB(vdb, vdbFile);
            this.notifyVDBUnLoad(vdbName, vdbVersion);
            this.loadedVDBs.remove(this.vdbId(vdbName, vdbVersion));
            this.availableVDBFiles.remove(this.vdbId(vdbName, vdbVersion));
            DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.vdb_delete", new Object[]{vdbName, vdbVersion});
            return vdb;
        }
        throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigurationService.vdb_delete_failed", new Object[]{vdbName, vdbVersion}));
    }

    public List getConnectorBindings() throws MetaMatrixComponentException {
        return new ArrayList(this.loadedConnectorBindings.values());
    }

    public ConnectorBinding getConnectorBinding(String connectorBindingName) throws MetaMatrixComponentException {
        return (ConnectorBinding)this.loadedConnectorBindings.get(connectorBindingName);
    }

    public Properties getDefaultProperties(ConnectorBinding binding) {
        ComponentTypeID id = binding.getComponentTypeID();
        return this.configurationModel.getDefaultPropertyValues(id);
    }

    List vdbsUsedConnectorBinding(ConnectorBinding binding) {
        ArrayList<BasicVDBDefn> list = new ArrayList<BasicVDBDefn>();
        Iterator i2 = this.loadedVDBs.values().iterator();
        while (i2.hasNext()) {
            BasicVDBDefn vdb = (BasicVDBDefn)i2.next();
            if (!vdb.isBindingInUse(binding)) continue;
            list.add(vdb);
        }
        return list;
    }

    public ConnectorBinding saveConnectorBinding(ConnectorBinding binding) throws MetaMatrixComponentException {
        if (binding != null) {
            boolean used;
            this.loadedConnectorBindings.put(binding.getName(), binding);
            DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.connector_save", new Object[]{binding.getName()});
            List usedVDBs = this.vdbsUsedConnectorBinding(binding);
            boolean bl = used = usedVDBs != null && !usedVDBs.isEmpty();
            if (used) {
                Iterator i2 = usedVDBs.iterator();
                while (i2.hasNext()) {
                    BasicVDBDefn vdb = (BasicVDBDefn)i2.next();
                    vdb.addConnectorBinding(binding);
                    this.saveVDB(vdb, vdb.getVersion());
                }
            }
            this.configurationModel = ServerConfigFileWriter.addConnectorBinding(this.configurationModel, binding);
            this.saveSystemConfiguration(this.configurationModel);
        }
        return binding;
    }

    public void deleteConnectorBinding(String connectorBindingName) throws MetaMatrixComponentException {
        ConnectorBinding binding = this.getConnectorBinding(connectorBindingName);
        if (binding != null) {
            boolean used;
            List usedVDBs = this.vdbsUsedConnectorBinding(binding);
            boolean bl = used = usedVDBs != null && !usedVDBs.isEmpty();
            if (used) {
                String vdbName = ((VDBDefn)usedVDBs.get(0)).getName();
                String vdbVersion = ((VDBDefn)usedVDBs.get(0)).getVersion();
                throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigurationService.ConnectorBinding_in_use_failed_delete", new Object[]{vdbName, vdbVersion}));
            }
        } else {
            throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigurationService.connector_binding_delete_failed", connectorBindingName));
        }
        DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.connector_delete", new Object[]{binding.getName()});
        this.loadedConnectorBindings.remove(connectorBindingName);
        this.configurationModel = ServerConfigFileWriter.deleteConnectorBinding(this.configurationModel, binding);
        this.saveSystemConfiguration(this.configurationModel);
    }

    public boolean isAssigned(ConnectorBinding binding) {
        List usedVDBs = this.vdbsUsedConnectorBinding(binding);
        return usedVDBs != null && !usedVDBs.isEmpty();
    }

    public List getConnectorTypes() throws MetaMatrixComponentException {
        return new ArrayList(this.loadedConnectorTypes.values());
    }

    public URL getExtensionPath() {
        String path = this.userPreferences.getProperty("dqp.extensions");
        if (this.valid(path)) {
            return this.getFullyQualifiedPath(path);
        }
        return null;
    }

    public boolean useExtensionClasspath() {
        return this.getExtensionPath() != null;
    }

    URL getDefaultExtensionPath() throws MetaMatrixComponentException {
        URL extPath = this.getExtensionPath();
        if (extPath != null) {
            return extPath;
        }
        return this.getFullyQualifiedPath("./extensions/");
    }

    public ExtensionModule getExtensionModule(String extModuleName) throws MetaMatrixComponentException {
        URL extModulePath = this.getFullyQualifiedPath(this.getDefaultExtensionPath(), extModuleName);
        return ExtensionModuleReader.loadExtensionModule(extModuleName, extModulePath);
    }

    public List getExtensionModules() throws MetaMatrixComponentException {
        URL extPath = this.getDefaultExtensionPath();
        return ExtensionModuleReader.loadExtensionModules(extPath);
    }

    public void saveExtensionModule(ExtensionModule extModule) throws MetaMatrixComponentException {
        URL extModuleURL = this.getFullyQualifiedPath(this.getDefaultExtensionPath(), extModule.getFullName());
        ExtensionModuleWriter.write(extModule, extModuleURL);
    }

    public void deleteExtensionModule(String extModuleName) throws MetaMatrixComponentException {
        URL extModuleURL = this.getFullyQualifiedPath(this.getDefaultExtensionPath(), extModuleName);
        ExtensionModuleWriter.deleteModule(extModuleURL);
    }

    public ConnectorBindingType getConnectorType(String connectorType) throws MetaMatrixComponentException {
        return (ConnectorBindingType)this.loadedConnectorTypes.get(connectorType);
    }

    public void saveConnectorType(ConnectorBindingType type) throws MetaMatrixComponentException {
        this.loadedConnectorTypes.put(type.getName(), type);
        DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.connector_type_save", new Object[]{type.getName()});
        this.configurationModel = ServerConfigFileWriter.addConnectorType(this.configurationModel, type);
        this.saveSystemConfiguration(this.configurationModel);
    }

    public void deleteConnectorType(String connectorType) throws MetaMatrixComponentException {
        ConnectorBindingType type = (ConnectorBindingType)this.loadedConnectorTypes.remove(connectorType);
        if (type != null) {
            if (this.isConnectorTypeInUse(type)) {
                throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigurationService.connector_type_in_use", connectorType));
            }
        } else {
            throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigurationService.connector_type_delete_failed", connectorType));
        }
        DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.connector_type_delete", new Object[]{connectorType});
        this.configurationModel = ServerConfigFileWriter.deleteConnectorType(this.configurationModel, type);
        this.saveSystemConfiguration(this.configurationModel);
    }

    boolean isConnectorTypeInUse(ConnectorBindingType type) {
        Iterator i2 = this.loadedConnectorBindings.values().iterator();
        while (i2.hasNext()) {
            ConnectorBinding binding = (ConnectorBinding)i2.next();
            if (!binding.getComponentTypeID().equals(type.getID())) continue;
            return true;
        }
        return false;
    }

    void loadUdfFile() throws ApplicationInitializationException {
        URL udfFile = this.getUDFFile();
        if (udfFile != null) {
            URL[] urls = this.getUDFClasspath();
            this.udfSource = new UDFSource(udfFile, urls);
            g.a(this.udfSource);
            DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.udf_load", new Object[]{udfFile, urls});
        }
    }

    void unloadUdfFile() {
        if (this.udfSource != null) {
            g.c(this.udfSource);
            this.udfSource = null;
            DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.udf_unload", new Object[0]);
        }
    }

    public void initializeService(Properties properties) throws ApplicationInitializationException {
        try {
            this.userPreferences = properties;
            DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.dqp_loading", new Object[]{this.getInstanceIdenifier()});
            this.initializeEncryption();
            this.configurationModel = this.getSystemConfiguration();
            ServerConfigFileReader configReader = this.loadServerConfigFile();
            this.userPreferences.putAll((Map<?, ?>)configReader.getSystemProperties());
            Map connectorBindings = configReader.getConnectorBindings();
            Map connectorTypes = configReader.getConnectorTypes();
            this.loadUdfFile();
            this.availableVDBFiles = this.loadVDBs();
            this.loadConnectorBindings(connectorBindings, connectorTypes);
            this.validateVDBs(this.loadedVDBs);
        }
        catch (MetaMatrixComponentException e2) {
            throw new ApplicationInitializationException(e2);
        }
    }

    public void startService(ApplicationEnvironment environment) throws ApplicationLifecycleException {
    }

    public void bindService() throws ApplicationLifecycleException {
    }

    public void unbindService() throws ApplicationLifecycleException {
    }

    public void stopService() throws ApplicationLifecycleException {
        this.loadedVDBs.clear();
        this.loadedConnectorBindings.clear();
        this.loadedConnectorTypes.clear();
        this.availableVDBFiles.clear();
        this.unloadUdfFile();
    }

    public URL[] getVDBLocations() {
        ArrayList<URL> vdbs = new ArrayList<URL>();
        String vdbProperty = this.userPreferences.getProperty("vdb.definition");
        if (vdbProperty != null && vdbProperty.length() != 0) {
            StringTokenizer st = new StringTokenizer(vdbProperty, VDB_LIST_SEPARATOR);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                String vdbLocation = token.toLowerCase();
                URL vdbURL = null;
                if (!(vdbLocation.endsWith(VDB) || vdbLocation.endsWith(DEF) || vdbLocation.endsWith("/"))) {
                    token = token + "/";
                }
                vdbURL = this.getFullyQualifiedPath(token);
                vdbs.add(vdbURL);
            }
        }
        return vdbs.toArray(new URL[vdbs.size()]);
    }

    void loadConnectorBindings(Map configBindings, Map configTypes) {
        this.loadedConnectorBindings = configBindings;
        this.loadedConnectorTypes = configTypes;
        Iterator i2 = this.loadedVDBs.keySet().iterator();
        while (i2.hasNext()) {
            VDBDefn vdb = (VDBDefn)this.loadedVDBs.get(i2.next());
            if (this.useConfigFileBindings()) {
                Iterator it = vdb.getConnectorTypes().values().iterator();
                while (it.hasNext()) {
                    ConnectorBindingType type = (ConnectorBindingType)it.next();
                    if (this.loadedConnectorTypes.containsKey(type.getName())) continue;
                    this.loadedConnectorTypes.put(type.getName(), type);
                }
                it = vdb.getConnectorBindings().values().iterator();
                while (it.hasNext()) {
                    ConnectorBinding binding = (ConnectorBinding)it.next();
                    if (this.loadedConnectorBindings.containsKey(binding.getName())) continue;
                    this.loadedConnectorBindings.put(binding.getName(), binding);
                }
                continue;
            }
            this.loadedConnectorBindings.putAll(vdb.getConnectorBindings());
            this.loadedConnectorTypes.putAll(vdb.getConnectorTypes());
        }
    }

    HashMap loadVDBs() throws ApplicationInitializationException {
        try {
            HashMap vdbFiles = VDBConfigurationReader.loadVDBS(this.getVDBLocations());
            HashMap<String, URL> loadedVDBFiles = new HashMap<String, URL>();
            Iterator i2 = vdbFiles.keySet().iterator();
            while (i2.hasNext()) {
                URL vdbURL = (URL)i2.next();
                VDBDefn vdb = (VDBDefn)vdbFiles.get(vdbURL);
                if (vdb == null) continue;
                if (this.loadedVDBs.get(this.vdbId(vdb)) != null) {
                    throw new MetaMatrixComponentException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigurationService.duplicate_vdb_found", new Object[]{vdbURL}));
                }
                if (this.vdbAllowed(vdb)) {
                    this.loadedVDBs.put(this.vdbId(vdb), vdb);
                    loadedVDBFiles.put(this.vdbId(vdb), vdbURL);
                    DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.loaded_vdb", new Object[]{vdbURL});
                    continue;
                }
                DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.not_loaded_vdb", new Object[]{vdbURL});
            }
            return loadedVDBFiles;
        }
        catch (MetaMatrixComponentException e2) {
            DQPEmbeddedPlugin.logError(e2, "EmbeddedConfigurationService.Failed_to_load_vdb", new Object[0]);
            throw new ApplicationInitializationException(e2);
        }
    }

    boolean vdbAllowed(VDBDefn vdb) {
        Map bindings = vdb.getConnectorBindings();
        try {
            LicenseChecker.checkProductLicense("Sources", "5.0", bindings.size());
            return true;
        }
        catch (LicenseException e2) {
            DQPEmbeddedPlugin.logWarning(e2, "EmbeddedConfigurationService.bindings_exceeded_limit", new Object[]{new Integer(bindings.size()), vdb.getName()});
            return false;
        }
    }

    ServerConfigFileReader loadServerConfigFile() throws ApplicationInitializationException {
        URL configFile = this.getConfigFile();
        try {
            if (configFile != null) {
                ServerConfigFileReader configReader = new ServerConfigFileReader(configFile);
                return configReader;
            }
            DQPEmbeddedPlugin.logError("EmbeddedConfigurationService.Server_Config_notdefined", null);
            throw new ApplicationInitializationException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigurationService.Server_Config_notdefined"));
        }
        catch (IOException e2) {
            DQPEmbeddedPlugin.logError("EmbeddedConfigurationService.Server_Config_failedload", new Object[]{configFile});
            throw new ApplicationInitializationException(DQPEmbeddedPlugin.Util.getString("EmbeddedConfigurationService.Server_Config_failedload", new Object[]{configFile}));
        }
    }

    URL getFullyQualifiedPath(String file) {
        if (file != null) {
            try {
                URL bootStrapURL = (URL)this.userPreferences.get("dqp.propertiesFile");
                return URLHelper.buildURL((URL)bootStrapURL, (String)file);
            }
            catch (MalformedURLException e2) {
                throw new MetaMatrixRuntimeException(e2);
            }
        }
        throw new MetaMatrixRuntimeException("bad configuration" + file);
    }

    URL getFullyQualifiedPath(URL context, String file) {
        if (file != null) {
            try {
                return URLHelper.buildURL((URL)context, (String)file);
            }
            catch (MalformedURLException e2) {
                throw new MetaMatrixRuntimeException(e2);
            }
        }
        throw new MetaMatrixRuntimeException("bad configuration" + file);
    }

    boolean useConfigFileBindings() {
        return Boolean.valueOf(this.userPreferences.getProperty("dqp.useServerConfigBindings"));
    }

    void initializeEncryption() throws ApplicationInitializationException {
        try {
            String encodedKeyStorePassword = this.getEncryptionPassword();
            URL keyStoreFile = this.getEncryptionKeyStore();
            if (encodedKeyStorePassword != null) {
                if (keyStoreFile != null) {
                    PasswordCryptoFactory.init(keyStoreFile, encodedKeyStorePassword.toCharArray());
                } else {
                    PasswordCryptoFactory.init(encodedKeyStorePassword.toCharArray());
                }
                DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.init_encryption", new Object[0]);
            }
        }
        catch (CryptoException ex) {
            throw new ApplicationInitializationException(ex);
        }
    }

    public String getEncryptionPassword() {
        return this.userPreferences.getProperty("metamatrix.security.password.PasswordKeyStore");
    }

    public URL getEncryptionKeyStore() {
        String keyStoreFile = this.userPreferences.getProperty("dqp.keystore");
        if (this.valid(keyStoreFile)) {
            return this.getFullyQualifiedPath(keyStoreFile);
        }
        return null;
    }

    public ClientConnectionListener getConnectionListener() throws MetaMatrixComponentException {
        return new ClientConnectionListener(){

            public void connectionAdded(ClientConnection connection) {
                EmbeddedConfigurationService.this.clientConnections.add(connection);
                String vdbName = (String)connection.getConnectionProperty("vdbName");
                String vdbVersion = (String)connection.getConnectionProperty("vdbVersion");
                String id = (String)connection.getConnectionProperty("connectionID");
                String key = EmbeddedConfigurationService.this.vdbId(vdbName, vdbVersion);
                DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.connectionAdded", new Object[]{vdbName, vdbVersion, id});
                Integer useCount = (Integer)EmbeddedConfigurationService.this.inuseVDBs.get(key);
                if (useCount == null) {
                    EmbeddedConfigurationService.this.inuseVDBs.put(key, new Integer(1));
                } else {
                    EmbeddedConfigurationService.this.inuseVDBs.put(key, new Integer(useCount + 1));
                }
            }

            public void connectionRemoved(ClientConnection connection) {
                EmbeddedConfigurationService.this.clientConnections.remove(connection);
                String vdbName = (String)connection.getConnectionProperty("vdbName");
                String vdbVersion = (String)connection.getConnectionProperty("vdbVersion");
                String id = (String)connection.getConnectionProperty("connectionID");
                String key = EmbeddedConfigurationService.this.vdbId(vdbName, vdbVersion);
                DQPEmbeddedPlugin.logInfo("EmbeddedConfigurationService.connectionRemoved", new Object[]{vdbName, vdbVersion, id});
                Integer useCount = (Integer)EmbeddedConfigurationService.this.inuseVDBs.get(key);
                if (useCount != null) {
                    if (useCount - 1 == 0) {
                        EmbeddedConfigurationService.this.runVDBCleanUp(vdbName, vdbVersion);
                        EmbeddedConfigurationService.this.inuseVDBs.remove(key);
                    } else {
                        EmbeddedConfigurationService.this.inuseVDBs.put(key, new Integer(useCount - 1));
                    }
                }
            }

            public void connectionTerminated(ClientConnection connection) {
                this.connectionRemoved(connection);
            }
        };
    }

    public Set getClientConnections() {
        return new HashSet(this.clientConnections);
    }

    boolean canDeleteVDB(VDBDefn vdb) {
        Integer useCount = (Integer)this.inuseVDBs.get(this.vdbId(vdb));
        return useCount == null || useCount == 0;
    }

    void runVDBCleanUp(String vdbName, String vdbVersion) {
        try {
            VDBDefn vdb = this.getVDB(vdbName, vdbVersion);
            if (vdb != null && vdb.getStatus() == 4) {
                vdb = this.deleteVDB(vdbName, vdbVersion);
                Collection bindings = vdb.getConnectorBindings().values();
                Iterator i2 = bindings.iterator();
                while (i2.hasNext()) {
                    ConnectorBinding binding = (ConnectorBinding)i2.next();
                    try {
                        this.getDataService().deleteConnectorBinding(binding.getName());
                    }
                    catch (Exception e2) {
                        DQPEmbeddedPlugin.logError(e2, "EmbeddedConfigurationService.ConnectorBinding_in_use_failed_delete", new Object[]{vdbName, vdbVersion});
                    }
                }
            }
        }
        catch (MetaMatrixComponentException e3) {
            DQPEmbeddedPlugin.logError(e3, "EmbeddedConfigurationService.vdb_delete_failed", new Object[]{vdbName, vdbVersion});
        }
    }

    boolean isValidVDB(VDBDefn vdb) throws MetaMatrixComponentException {
        Collection models = vdb.getModels();
        Iterator i2 = models.iterator();
        while (i2.hasNext()) {
            ModelInfo model = (ModelInfo)i2.next();
            if (!model.isPhysical()) continue;
            if (model.getConnectorBindingNames().isEmpty()) {
                return false;
            }
            String bindingName = (String)model.getConnectorBindingNames().get(0);
            if (this.getConnectorBinding(bindingName) != null) continue;
            return false;
        }
        return true;
    }

    void validateVDBs(Map vdbMap) throws MetaMatrixComponentException {
        Collection vdbs = vdbMap.values();
        Iterator i2 = vdbs.iterator();
        while (i2.hasNext()) {
            VDBDefn vdb = (VDBDefn)i2.next();
            if (vdb.getStatus() == 3 || !this.isValidVDB(vdb)) continue;
            ((BasicVDBDefn)vdb).setStatus((short)3);
            DQPEmbeddedPlugin.logInfo("VDBService.vdb_loded", new Object[]{vdb.getName(), vdb.getVersion()});
        }
    }

    public void register(VDBLifeCycleListener listener) {
        this.vdbLifeCycleListeners.add(listener);
    }

    void notifyVDBLoad(String vdbName, String vdbVersion) {
        Iterator i2 = this.vdbLifeCycleListeners.iterator();
        while (i2.hasNext()) {
            VDBLifeCycleListener listener = (VDBLifeCycleListener)i2.next();
            listener.loaded(vdbName, vdbVersion);
        }
    }

    void notifyVDBUnLoad(String vdbName, String vdbVersion) {
        Iterator i2 = this.vdbLifeCycleListeners.iterator();
        while (i2.hasNext()) {
            VDBLifeCycleListener listener = (VDBLifeCycleListener)i2.next();
            listener.unloaded(vdbName, vdbVersion);
        }
    }

    public boolean useDiskBuffering() {
        return Boolean.valueOf(this.userPreferences.getProperty("dqp.buffer.usedisk", "true"));
    }

    public File getDiskBufferDirectory() {
        File bufferDir = null;
        String bufferDirectory = this.userPreferences.getProperty("dqp.buffer.dir");
        if (this.valid(bufferDirectory)) {
            if (!bufferDirectory.endsWith("/")) {
                bufferDirectory = bufferDirectory + "/";
            }
            bufferDirectory = bufferDirectory + this.getInstanceIdenifier();
            URL bufferURL = this.getFullyQualifiedPath(bufferDirectory);
            bufferDir = new File(bufferURL.getPath());
        } else {
            bufferDir = new File(this.userPreferences.getProperty("mm.io.tmpdir"));
        }
        if (!bufferDir.exists()) {
            bufferDir.mkdirs();
        }
        return bufferDir;
    }

    public String getBufferMemorySize() {
        return this.userPreferences.getProperty("dqp.buffer.memory", "64");
    }

    public String getInstanceIdenifier() {
        return this.userPreferences.getProperty("dqp.identity");
    }

    public boolean useUnifiedClassLoader() {
        String val = this.userPreferences.getProperty("dqp.classpath");
        return val == null || val.length() == 0;
    }

    public String getProcessorBatchSize() {
        return this.userPreferences.getProperty("dqp.buffer.processorBatchSize", "2000");
    }

    public String getConnectorBatchSize() {
        return this.userPreferences.getProperty("dqp.buffer.connectorBatchSize", "2000");
    }
}

