/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.embedded.services;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.LocalLookup;
import com.metamatrix.common.buffer.impl.BufferManagerImpl;
import com.metamatrix.common.buffer.storage.file.FileStorageManager;
import com.metamatrix.common.buffer.storage.memory.MemoryStorageManager;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.dqp.embedded.DQPEmbeddedPlugin;
import com.metamatrix.dqp.embedded.services.EmbeddedBaseDQPService;
import com.metamatrix.dqp.service.BufferService;
import com.metamatrix.dqp.service.ConfigurationService;
import com.metamatrix.dqp.service.DQPServiceRegistry;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Properties;

public class EmbeddedBufferService
extends EmbeddedBaseDQPService
implements BufferService {
    private static final String DEFAULT_MANAGEMENT_INTERVAL = "0";
    private static final String DEFAULT_LOG_STATS_INTERVAL = "0";
    private static final String DEFAULT_SESSION_USE_PERCENTAGE = "100";
    private static final String DEFAULT_ID_CREATOR = "com.metamatrix.common.buffer.impl.LongIDCreator";
    private static final String DEFAULT_MAX_OPEN_FILES = "10";
    private BufferManager bufferMgr;

    public EmbeddedBufferService(DQPServiceRegistry svcRegistry) throws MetaMatrixComponentException {
        super("dqp.buffer", svcRegistry);
    }

    public void initializeService(Properties props) throws ApplicationInitializationException {
        try {
            ConfigurationService configurationSvc = this.getConfigurationService();
            boolean useDisk = configurationSvc.useDiskBuffering();
            File bufferDir = configurationSvc.getDiskBufferDirectory();
            String memAvail = configurationSvc.getBufferMemorySize();
            String processorBatchSize = configurationSvc.getProcessorBatchSize();
            String connectorBatchSize = configurationSvc.getConnectorBatchSize();
            Properties bufferProps = new Properties();
            bufferProps.setProperty("metamatrix.buffer.idCreator", DEFAULT_ID_CREATOR);
            bufferProps.setProperty("metamatrix.buffer.sessionUsePercentage", DEFAULT_SESSION_USE_PERCENTAGE);
            bufferProps.setProperty("metamatrix.buffer.logStatsInterval", "0");
            bufferProps.setProperty("metamatrix.buffer.managementInterval", "0");
            bufferProps.setProperty("metamatrix.buffer.memoryAvailable", memAvail);
            bufferProps.setProperty("metamatrix.buffer.storageDirectory", bufferDir.getCanonicalPath());
            bufferProps.setProperty("metamatrix.buffer.processorBatchSize", processorBatchSize);
            bufferProps.setProperty("metamatrix.buffer.connectorBatchSize", connectorBatchSize);
            this.bufferMgr = new BufferManagerImpl();
            this.bufferMgr.initialize(new LocalLookup(this.bufferMgr), bufferProps);
            if (useDisk) {
                Properties fsmProps = new Properties();
                fsmProps.setProperty("metamatrix.buffer.storageDirectory", bufferDir.getCanonicalPath());
                fsmProps.setProperty("metamatrix.buffer.maxOpenFiles", DEFAULT_MAX_OPEN_FILES);
                FileStorageManager fsm = new FileStorageManager();
                fsm.initialize(fsmProps);
                this.bufferMgr.addStorageManager(fsm);
                this.cleanDirectory(bufferDir);
            }
            this.bufferMgr.addStorageManager(new MemoryStorageManager());
        }
        catch (MetaMatrixComponentException e2) {
            throw new ApplicationInitializationException((Throwable)e2, DQPEmbeddedPlugin.Util.getString("LocalBufferService.Failed_initializing_buffer_manager._8"));
        }
        catch (IOException e3) {
            throw new ApplicationInitializationException((Throwable)e3, DQPEmbeddedPlugin.Util.getString("LocalBufferService.Failed_initializing_buffer_manager._8"));
        }
    }

    void cleanDirectory(File file) {
        if (file.exists()) {
            File[] files = file.listFiles();
            for (int i2 = 0; i2 < files.length; ++i2) {
                files[i2].delete();
            }
        }
    }

    public void startService(ApplicationEnvironment environment) throws ApplicationLifecycleException {
    }

    public void bindService() throws ApplicationLifecycleException {
    }

    public void unbindService() throws ApplicationLifecycleException {
    }

    public void stopService() throws ApplicationLifecycleException {
        try {
            this.bufferMgr.stop();
            ConfigurationService configurationSvc = this.getConfigurationService();
            File bufferDir = configurationSvc.getDiskBufferDirectory();
            this.cleanDirectory(bufferDir);
            bufferDir.delete();
        }
        catch (RemoteException ex) {
            throw new MetaMatrixRuntimeException(ex);
        }
        catch (MetaMatrixComponentException e2) {
            throw new ApplicationLifecycleException(e2);
        }
    }

    public BufferManager getBufferManager() {
        return this.bufferMgr;
    }
}

