/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.client.impl;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.data.api.ValueChunk;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.client.Results;
import com.metamatrix.dqp.client.impl.ResponseReceiver;
import com.metamatrix.dqp.client.impl.ServerFacadeImpl;
import com.metamatrix.dqp.message.ParameterInfo;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.query.i.e;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ResultBatch
implements Results {
    private static final int DEFAULT_LOB_CHUNK_SIZE = 102400;
    private static final String LOB_MESSAGE_KEY_PREFIX = "LOB_";
    private RequestID requestID;
    private ServerFacadeImpl.ConnectionHolder holder;
    private boolean isLast;
    private int beginRow;
    private int endRow;
    private int rowCount;
    private int columnCount;
    private List[] results;
    private ParameterInfo[] parameterInfo;
    private Map outputParameterMap = new HashMap();
    private boolean update;
    private Exception exception;
    private List warnings;

    ResultBatch(ResultsMessage results, boolean isUpdate, RequestID requestID, ServerFacadeImpl.ConnectionHolder holder) {
        this.requestID = requestID;
        this.holder = holder;
        this.beginRow = results.getFirstRow();
        this.endRow = results.getLastRow();
        this.results = results.getResults();
        this.rowCount = this.results == null ? 0 : this.results.length;
        this.isLast = results.getFinalRow() == this.endRow;
        this.columnCount = results.getColumnNames() == null ? 0 : results.getColumnNames().length;
        this.exception = results.getException();
        this.warnings = results.getWarnings() == null ? Collections.EMPTY_LIST : results.getWarnings();
        this.update = isUpdate;
        this.setParameters(results.getParameters());
    }

    public boolean isLast() {
        return this.isLast;
    }

    public int getBeginRow() {
        return this.beginRow;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public Object getValue(int row, int column) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        if (this.rowCount == 0) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ResultBatch.no_rows"));
        }
        if (row < this.beginRow || row > this.endRow) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ResultBatch.invalid_row", row));
        }
        if (column < 1 || column > this.columnCount) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ResultBatch.invalid_column", column));
        }
        Object val = this.getData(row, column);
        if (val != null && val instanceof e) {
            return this.getLOBValue((e)val);
        }
        return val;
    }

    private Object getData(int row, int column) {
        return this.results[row - this.beginRow].get(column - 1);
    }

    private Object getLOBValue(e lob) throws MetaMatrixComponentException {
        boolean isBLOB = lob.isBinary();
        ByteArrayOutputStream blobHolder = null;
        StringBuffer stringHolder = null;
        if (isBLOB) {
            blobHolder = new ByteArrayOutputStream();
        } else {
            stringHolder = new StringBuffer();
        }
        ValueChunk chunk = null;
        int startPos = 0;
        try {
            do {
                chunk = null;
                RequestMessage request = ResultBatch.createLOBRequest(lob, this.requestID, startPos, 102400);
                ResponseReceiver receiver = new ResponseReceiver();
                this.holder.getConnection().send(request, receiver, LOB_MESSAGE_KEY_PREFIX + request.getMessageKey(), this.holder.getInstance());
                ResultsMessage response = ResponseReceiver.waitForResponseMessage(receiver, 0L);
                if (response != null) {
                    if (response.getException() != null) {
                        throw new MetaMatrixComponentException((Throwable)response.getException());
                    }
                    chunk = response.getValueChunk();
                    startPos += chunk.size();
                    if (chunk.size() <= 0) continue;
                    if (isBLOB) {
                        blobHolder.write(chunk.getBytes());
                        continue;
                    }
                    stringHolder.append(chunk.getChars());
                    continue;
                }
                throw new MetaMatrixComponentException(DQPPlugin.Util.getString("ResultBatch.null_result"));
            } while (chunk != null && !chunk.isLast());
        }
        catch (CommunicationException e2) {
            throw new MetaMatrixComponentException((Throwable)e2);
        }
        catch (IOException e3) {
            throw new MetaMatrixComponentException(e3);
        }
        if (isBLOB) {
            return blobHolder.toByteArray();
        }
        return stringHolder.toString();
    }

    public int getParameterCount() {
        return this.parameterInfo.length;
    }

    public int getParameterType(int index) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        this.validateParameterIndex(index);
        int type = this.parameterInfo[index - 1].getType();
        switch (type) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
        }
        throw new MetaMatrixComponentException(DQPPlugin.Util.getString("ResultBatch.invalid_paramtype", type));
    }

    public Object getOutputParameter(int index) throws MetaMatrixComponentException, MetaMatrixProcessingException {
        if (!this.isLast) {
            return new MetaMatrixProcessingException(DQPPlugin.Util.getString("ResultBatch.not_last_batch"));
        }
        this.validateParameterIndex(index);
        Integer actualIndex = (Integer)this.outputParameterMap.get(new Integer(index));
        if (actualIndex == null) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ResultBatch.not_out_param", index));
        }
        int endOfRows = 0;
        int endOfColumns = 0;
        if (this.rowCount > 0) {
            endOfRows = this.endRow;
            endOfColumns = this.columnCount;
        }
        return this.getData(endOfRows + actualIndex, endOfColumns + actualIndex);
    }

    private void validateParameterIndex(int index) throws MetaMatrixProcessingException {
        if (this.parameterInfo.length == 0) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ResultBatch.no_params"));
        }
        if (index < 1 || index > this.parameterInfo.length) {
            throw new MetaMatrixProcessingException(DQPPlugin.Util.getString("ResultBatch.invalid_paramindex", index));
        }
    }

    public boolean isUpdate() {
        return this.update;
    }

    public int getUpdateCount() throws MetaMatrixComponentException {
        if (!this.update) {
            throw new MetaMatrixComponentException(DQPPlugin.Util.getString("ResultBatch.not_update"));
        }
        if (this.exception != null) {
            throw new MetaMatrixComponentException(DQPPlugin.Util.getString("ResultBatch.exception_exists"));
        }
        if (this.results == null || this.results.length != 1) {
            throw new MetaMatrixComponentException(DQPPlugin.Util.getString("ResultBatch.update_count_unavailable"));
        }
        Integer val = (Integer)this.getData(1, 1);
        if (val == null) {
            return 0;
        }
        return val;
    }

    public Exception getException() {
        return this.exception;
    }

    public Exception[] getWarnings() {
        return this.warnings.toArray(new Exception[this.warnings.size()]);
    }

    private void setParameters(List parameters) {
        if (parameters == null || parameters.isEmpty()) {
            this.parameterInfo = new ParameterInfo[0];
        } else {
            int outputParameterCount = 0;
            int nonResultSetParameterCount = 0;
            ArrayList<ParameterInfo> paramInfos = new ArrayList<ParameterInfo>(parameters.size());
            for (int i2 = 0; i2 < parameters.size(); ++i2) {
                ParameterInfo info = (ParameterInfo)parameters.get(i2);
                int parameterType = info.getType();
                if (parameterType != 5) {
                    paramInfos.add(info);
                    ++nonResultSetParameterCount;
                }
                if (parameterType != 4 && parameterType != 2 && parameterType != 3) continue;
                this.outputParameterMap.put(new Integer(nonResultSetParameterCount), new Integer(++outputParameterCount));
            }
            this.parameterInfo = paramInfos.toArray(new ParameterInfo[paramInfos.size()]);
        }
        int numOutputParameters = this.outputParameterMap.size();
        if (numOutputParameters > 0) {
            this.endRow -= numOutputParameters;
            this.rowCount -= numOutputParameters;
            this.columnCount -= numOutputParameters;
        }
    }

    private static RequestMessage createLOBRequest(e lob, RequestID id, int start, int chunkSize) {
        RequestMessage request = new RequestMessage();
        request.setLobRequest(true);
        request.setValueID(lob);
        request.setStartPosition(start);
        request.setChunkSize(chunkSize);
        request.setRequestID(id);
        request.setMessageKey(Long.toString(id.getExecutionID()));
        return request;
    }
}

