/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.selection;

import com.metamatrix.core.selection.TreeSelectionModel;
import com.metamatrix.core.selection.TreeSelectionProvider;
import com.metamatrix.core.selection.TreeSelectionState;
import com.metamatrix.core.util.ArgCheck;
import java.util.Iterator;
import java.util.List;

public class TreeSelectionImpl
implements TreeSelectionModel {
    private final TreeSelectionState state;
    private final TreeSelectionProvider provider;

    public TreeSelectionImpl(TreeSelectionProvider provider) {
        ArgCheck.isNotNull(provider);
        this.provider = provider;
        this.state = new TreeSelectionState(this.provider);
    }

    public TreeSelectionProvider getTreeSelectionProvider() {
        return this.provider;
    }

    public int getSelectionMode(Object node) {
        return this.state.getSelectionMode(node);
    }

    public void setSelected(Object node, boolean selected) {
        Object parent;
        int newMode;
        int currentMode = this.state.getSelectionMode(node);
        int n2 = newMode = selected ? 1 : 0;
        if (currentMode == newMode) {
            return;
        }
        this.doSetSelectionMode(node, newMode);
        List children = this.provider.getChildren(node);
        if (children != null) {
            Iterator iter;
            if (newMode == 0) {
                iter = children.iterator();
                while (iter.hasNext()) {
                    Object child = iter.next();
                    this.setSelected(child, false);
                }
            } else {
                iter = children.iterator();
                while (iter.hasNext()) {
                    Object child = iter.next();
                    this.setSelected(child, true);
                }
            }
        }
        if ((parent = this.provider.getParent(node)) != null) {
            this.doCheckSelectionMode(parent, node, newMode);
        }
    }

    protected void doSetSelectionMode(Object node, int mode) {
        this.state.setSelected(node, mode);
    }

    protected void doCheckSelectionMode(Object parent, Object childNodeWithChangedSelection, int newMode) {
        Object parentParent;
        int parentMode = this.state.getSelectionMode(parent);
        if (parentMode == newMode) {
            return;
        }
        List children = this.provider.getChildren(parent);
        if (children == null) {
            return;
        }
        int newParentMode = parentMode;
        boolean hasUnselected = false;
        boolean hasSelected = false;
        boolean hasPartiallySelected = false;
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            Object child = iter.next();
            int childMode = this.state.getSelectionMode(child);
            if (!hasSelected && childMode == 1) {
                hasSelected = true;
            }
            if (!hasUnselected && childMode == 0) {
                hasUnselected = true;
            }
            if (!hasPartiallySelected && childMode == 2) {
                hasPartiallySelected = true;
            }
            if (!hasPartiallySelected && (!hasSelected || !hasUnselected)) continue;
            hasPartiallySelected = true;
            this.doSetSelectionMode(parent, 2);
            newParentMode = 2;
            break;
        }
        if (!hasPartiallySelected) {
            if (hasSelected) {
                this.doSetSelectionMode(parent, 1);
                newParentMode = 1;
            }
            if (hasUnselected) {
                this.doSetSelectionMode(parent, 0);
                newParentMode = 0;
            }
        }
        if (newParentMode != parentMode && (parentParent = this.provider.getParent(parent)) != null) {
            this.doCheckSelectionMode(parentParent, parent, newParentMode);
        }
    }
}

