/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.plugin;

import com.metamatrix.core.plugin.ConfigContext;
import com.metamatrix.core.plugin.DebugContextListener;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class DebugContextManager {
    private List listener = new Vector();
    private ConfigContext configContext = null;
    private static DebugContextManager instance = null;

    private DebugContextManager() {
    }

    public static synchronized DebugContextManager getInstance() {
        if (instance == null) {
            instance = new DebugContextManager();
        }
        return instance;
    }

    public void shutdown() {
        this.removeAllListeners();
    }

    public synchronized void removeListener(DebugContextListener pluginLisener) {
        this.listener.remove(pluginLisener);
    }

    public synchronized void addListener(DebugContextListener pluginLisener) {
        this.listener.add(pluginLisener);
    }

    public List getListeners() {
        return this.listener;
    }

    public ConfigContext getLastConfigContext() {
        return this.configContext;
    }

    public synchronized void setConfigContext(ConfigContext debugContext) {
        if (this.configContext == null || !this.configContext.equals(debugContext)) {
            this.configContext = debugContext;
            this.notifyListeners();
        }
    }

    public void fire() {
        this.notifyListeners();
    }

    private void notifyListeners() {
        Iterator iter = this.listener.iterator();
        while (iter.hasNext()) {
            DebugContextListener listener = (DebugContextListener)iter.next();
            listener.notifyContextChange(this.configContext);
        }
    }

    private synchronized void removeAllListeners() {
        this.listener.clear();
    }
}

