/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.event;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.event.AbstractEventBroker;
import java.util.EventObject;
import java.util.LinkedList;

public class AsynchEventBroker
extends AbstractEventBroker {
    private BrokerThread brokerThread;
    private LinkedList queue = new LinkedList();
    private static final String DEFAULT_NAME = CorePlugin.Util.getString("AsynchEventBroker.DefaultName");
    private static final long SHUTDOWN_TIMEOUT_MILLIS = 10000L;

    public AsynchEventBroker() {
        this(null);
    }

    public AsynchEventBroker(String name) {
        if (name == null) {
            name = DEFAULT_NAME;
        }
        super.setName(name);
        this.brokerThread = new BrokerThread(name);
        this.brokerThread.start();
    }

    public synchronized boolean hasUnprocessedEvents() {
        return this.queue.size() > 0;
    }

    protected final synchronized void process(EventObject obj) {
        this.queue.addLast(obj);
        this.notifyAll();
    }

    private final synchronized EventObject dequeue() throws InterruptedException {
        while (this.queue.size() == 0) {
            this.wait();
        }
        return (EventObject)this.queue.removeFirst();
    }

    protected void waitToCompleteShutdown() {
        block2: while (!this.isShutdownComplete()) {
            this.process(null);
            if (Thread.currentThread() == this.brokerThread || !this.brokerThread.isAlive()) continue;
            long timeoutTime = System.currentTimeMillis() + 10000L;
            while (this.queue.size() != 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() <= timeoutTime) continue;
                continue block2;
            }
        }
    }

    private class BrokerThread
    extends Thread {
        BrokerThread(String name) {
            super(name);
        }

        public void run() {
            EventObject obj = null;
            while (true) {
                try {
                    obj = AsynchEventBroker.this.dequeue();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (obj == null) break;
                AsynchEventBroker.this.notifyListeners(obj);
            }
            AsynchEventBroker.this.setShutdownComplete(true);
        }
    }
}

