/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.core.event;

import com.metamatrix.core.CorePlugin;
import com.metamatrix.core.event.AbstractEventSource;
import com.metamatrix.core.event.EventBroker;
import com.metamatrix.core.event.EventBrokerException;
import com.metamatrix.core.event.EventObjectListener;
import com.metamatrix.core.event.EventSourceException;
import com.metamatrix.core.event.TargetableEvent;
import com.metamatrix.core.util.Assertion;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractEventBroker
extends AbstractEventSource
implements EventBroker {
    private static final String CANNOT_ADD_SELF_AS_LISTENER_MESSAGE = CorePlugin.Util.getString("AbstractEventBroker.CannotAddSelfAsListener");
    private boolean shutdownRequested = false;
    private boolean shutdownComplete = false;
    private String name = "";
    private static final boolean EVENT_PERF;
    private static final double EVENT_FLOOR;
    private StringBuffer eventPerfMsg = new StringBuffer();

    protected AbstractEventBroker() {
    }

    protected void setName(String name) {
        if (name == null) {
            Assertion.isNotNull(name, CorePlugin.Util.getString("AbstractEventBroker.The_name_of_the_event_broker_may_not_be_null"));
        }
        if (name.length() == 0) {
            Assertion.isNotZeroLength(name, CorePlugin.Util.getString("AbstractEventBroker.The_name_of_the_event_broker_may_not_be_zero-length"));
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public void addListener(Class eventClass, EventObjectListener listener) throws EventSourceException {
        Assertion.isNotNull(listener, CANNOT_ADD_SELF_AS_LISTENER_MESSAGE);
        this.assertReady();
        super.addListener(eventClass, listener);
    }

    public void addListener(EventObjectListener listener) throws EventSourceException {
        Assertion.isNotNull(listener, CANNOT_ADD_SELF_AS_LISTENER_MESSAGE);
        this.assertReady();
        super.addListener(listener);
    }

    public void processEvent(EventObject obj) {
        this.assertReady();
        if (obj != null) {
            this.process(obj);
        }
    }

    public boolean shutdown() throws EventBrokerException {
        this.shutdownRequested = true;
        this.waitToCompleteShutdown();
        try {
            super.removeAllListeners();
        }
        catch (EventSourceException eventSourceException) {
            // empty catch block
        }
        return this.shutdownComplete;
    }

    public boolean isShutdown() {
        return this.isShutdownComplete();
    }

    protected void notifyListeners(EventObject obj) {
        if (obj != null) {
            if (EVENT_PERF && this.eventPerfMsg.length() == 0) {
                this.eventPerfMsg.append('\n');
            }
            double eventTime = 0.0;
            int count = 0;
            List listeners = super.getListeners(obj.getClass());
            Iterator itr = listeners.iterator();
            while (itr.hasNext()) {
                EventObjectListener listener = (EventObjectListener)itr.next();
                if (listener == null) continue;
                try {
                    if (EVENT_PERF) {
                        double start = System.currentTimeMillis();
                        listener.processEvent(obj);
                        double totalTime = (double)System.currentTimeMillis() - start;
                        eventTime += totalTime;
                        ++count;
                        if (!(totalTime >= EVENT_FLOOR)) continue;
                        Object[] params = new Object[]{new Double(totalTime), AbstractEventBroker.getShortClassName(listener)};
                        this.eventPerfMsg.append(CorePlugin.Util.getString("AbstractEventBroker.eventFloorExceeded", params));
                        continue;
                    }
                    listener.processEvent(obj);
                }
                catch (Throwable t2) {
                    CorePlugin.Util.log(4, t2, CorePlugin.Util.getString("AbstractEventBroker.Error_during_event_processing", this.getName()));
                }
            }
            if (EVENT_PERF && eventTime >= EVENT_FLOOR) {
                Object[] params = new Object[]{new Double(eventTime), new Integer(count), AbstractEventBroker.getShortClassName(obj), AbstractEventBroker.getShortClassName(obj.getSource())};
                this.eventPerfMsg.append(CorePlugin.Util.getString("AbstractEventBroker.basePerformanceMessage", params));
                if (obj instanceof TargetableEvent) {
                    this.eventPerfMsg.append(CorePlugin.Util.getString("AbstractEventBroker.targetedPerformanceMessage", ((TargetableEvent)obj).getTarget()));
                }
                this.eventPerfMsg.append('\n');
                CorePlugin.Util.log(1, this.eventPerfMsg.toString());
                this.eventPerfMsg.setLength(0);
            }
        }
    }

    protected void assertReady() {
        if (this.shutdownRequested || this.shutdownComplete) {
            throw new IllegalStateException(CorePlugin.Util.getString("AbstractEventBroker.No_events_can_be_processed_EventBroker_is_shutdown", this.getName()));
        }
    }

    private static String getShortClassName(Object theObject) {
        String className = theObject.getClass().getName();
        int index = className.lastIndexOf(46);
        return index == -1 ? className : className.substring(index + 1);
    }

    protected abstract void process(EventObject var1);

    protected abstract void waitToCompleteShutdown();

    protected boolean isShutdownRequested() {
        return this.shutdownRequested;
    }

    protected boolean isShutdownComplete() {
        return this.shutdownComplete;
    }

    protected void setShutdownComplete(boolean shutdownComplete) {
        this.shutdownComplete = shutdownComplete;
    }

    static {
        boolean bl = EVENT_PERF = System.getProperty("eventPerf") != null;
        if (EVENT_PERF) {
            double DEFAULT = 10.0;
            double temp = 10.0;
            String txt = System.getProperty("eventFloor");
            if (txt != null) {
                try {
                    temp = Double.parseDouble(txt);
                    temp = temp < 0.0 ? 0.0 : temp;
                }
                catch (NumberFormatException theException) {
                    temp = 10.0;
                }
            }
            EVENT_FLOOR = temp;
        } else {
            EVENT_FLOOR = 0.0;
        }
    }
}

