/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.sysadmin.util;

import com.metamatrix.connector.sysadmin.extension.ISysAdminConnectionFactory;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IMetadataReference;
import com.metamatrix.data.metadata.runtime.MetadataID;
import com.metamatrix.data.metadata.runtime.MetadataObject;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.Properties;

public class SysAdminUtil {
    public static ISysAdminConnectionFactory createFactory(ConnectorEnvironment environment, ClassLoader loader) throws ConnectorException {
        if (environment == null || loader == null || environment.getProperties() == null) {
            return null;
        }
        Properties props = environment.getProperties();
        try {
            String scfClassName = props.getProperty("SysAdminConnectionFactoryClass", "com.metamatrix.connector.sysadmin.SysAdminConnectionFactory");
            Class<?> scfClass = loader.loadClass(scfClassName);
            ISysAdminConnectionFactory adminFactory = (ISysAdminConnectionFactory)scfClass.newInstance();
            adminFactory.init(environment);
            return adminFactory;
        }
        catch (ClassNotFoundException e1) {
            throw new ConnectorException(e1);
        }
        catch (InstantiationException e2) {
            throw new ConnectorException(e2);
        }
        catch (IllegalAccessException e3) {
            throw new ConnectorException(e3);
        }
    }

    public static String getExecutionName(RuntimeMetadata metadata, IMetadataReference reference) throws ConnectorException {
        if (reference == null) {
            return null;
        }
        String refName = SysAdminUtil.getMetadataObjectNameInSource(metadata, reference);
        if (refName == null) {
            MetadataID id = reference.getMetadataID();
            refName = id.getName();
        }
        return refName;
    }

    public static String getMetadataObjectNameInSource(RuntimeMetadata metadata, IMetadataReference reference) throws ConnectorException {
        if (reference == null) {
            return null;
        }
        MetadataID id = reference.getMetadataID();
        MetadataObject obj = metadata.getObject(id);
        if (obj != null && obj.getNameInSource() != null) {
            return obj.getNameInSource();
        }
        return null;
    }
}

