/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.sysadmin.util;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.common.types.MMJDBCSQLTypeInfo;
import com.metamatrix.common.types.Transform;
import com.metamatrix.common.util.TimestampWithTimezone;
import com.metamatrix.connector.sysadmin.SysAdminPlugin;
import com.metamatrix.connector.sysadmin.extension.IObjectCommand;
import com.metamatrix.connector.sysadmin.extension.ISourceTranslator;
import com.metamatrix.connector.sysadmin.extension.IValueTranslator;
import com.metamatrix.connector.sysadmin.extension.value.BasicValueTranslator;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.basic.BasicBatch;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.visitor.util.SQLReservedWords;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class SysAdminExecutionHelper
implements SQLReservedWords {
    private static final String ESCAPED_QUOTE = "''";
    private static final TimeZone LOCAL_TIME_ZONE = TimeZone.getDefault();
    static /* synthetic */ Class class$java$lang$String;

    protected String escapeString(String str) {
        return StringUtil.replaceAll(str, "'", ESCAPED_QUOTE);
    }

    protected String translateLiteralBoolean(Boolean booleanValue, TimeZone databaseTimeZone) {
        if (booleanValue.booleanValue()) {
            return "1";
        }
        return "0";
    }

    protected String translateLiteralDate(Date dateValue, TimeZone databaseTimeZone) {
        return "{d'" + this.formatDateValue(dateValue, databaseTimeZone) + "'}";
    }

    protected String translateLiteralTime(Time timeValue, TimeZone databaseTimeZone) {
        return "{t'" + this.formatDateValue(timeValue, databaseTimeZone) + "'}";
    }

    protected String translateLiteralTimestamp(Timestamp timestampValue, TimeZone databaseTimeZone) {
        return "{ts'" + this.formatDateValue(timestampValue, databaseTimeZone) + "'}";
    }

    protected String formatDateValue(Object dateObject, TimeZone databaseTimeZone) {
        if (databaseTimeZone == null) {
            return dateObject.toString();
        }
        if (dateObject instanceof Timestamp) {
            SimpleDateFormat timestampFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            timestampFormatter.setTimeZone(databaseTimeZone);
            Timestamp ts = (Timestamp)dateObject;
            String nanoStr = "" + (1000000000L + (long)ts.getNanos());
            while (nanoStr.length() > 2 && nanoStr.charAt(nanoStr.length() - 1) == '0') {
                nanoStr = nanoStr.substring(0, nanoStr.length() - 1);
            }
            String tsStr = timestampFormatter.format(ts) + "." + nanoStr.substring(1);
            return tsStr;
        }
        if (dateObject instanceof Date) {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
            dateFormatter.setTimeZone(databaseTimeZone);
            return dateFormatter.format((Date)dateObject);
        }
        if (dateObject instanceof Time) {
            SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");
            timeFormatter.setTimeZone(databaseTimeZone);
            return timeFormatter.format((Time)dateObject);
        }
        return dateObject.toString();
    }

    public static Batch createBatch(List spResults, IObjectCommand command, int maxBatchSize, boolean trimStrings, ISourceTranslator resultsTranslator, ExecutionContext context) throws ConnectorException {
        BasicBatch batch = new BasicBatch();
        SysAdminExecutionHelper.transferResults(batch, spResults, command, maxBatchSize, true, trimStrings, resultsTranslator, context);
        return batch;
    }

    protected static void transferResults(Batch batch, List spResults, IObjectCommand command, int maxBatchSize, boolean setLastBatch, boolean trimStrings, ISourceTranslator resultsTranslator, ExecutionContext context) throws ConnectorException {
        Class[] columnTypes = command.getResultColumnTypes();
        IValueTranslator transform = null;
        int rowCnt = 0;
        int rsize = spResults.size();
        TimeZone dbmsTimeZone = resultsTranslator.getDatabaseTimezone();
        Calendar cal = null;
        if (dbmsTimeZone != null) {
            cal = Calendar.getInstance(dbmsTimeZone);
        }
        try {
            while (rowCnt < maxBatchSize && rowCnt < rsize) {
                ArrayList l2;
                Object value = spResults.get(rowCnt);
                if (value == null) continue;
                Class<?> valueType = value.getClass();
                int javaType = MMJDBCSQLTypeInfo.getSQLTypeFromClass(valueType.getName());
                if (javaType == 2000) {
                    if (!(value instanceof Collection) && !(value instanceof List)) {
                        transform = SysAdminExecutionHelper.determineTransformation(valueType, valueType, resultsTranslator.getValueTranslators());
                        value = transform.translate(value, command, context);
                    }
                    if (value != null) {
                        ArrayList lresults;
                        ArrayList vt;
                        if (value instanceof List) {
                            vt = (ArrayList)value;
                            lresults = new ArrayList(1);
                            lresults.add(vt);
                            SysAdminExecutionHelper.transferObjectResults(batch, lresults, command, trimStrings, resultsTranslator, context);
                        } else if (value instanceof Collection) {
                            vt = new ArrayList((Collection)value);
                            lresults = new ArrayList(1);
                            lresults.add(vt);
                            SysAdminExecutionHelper.transferObjectResults(batch, lresults, command, trimStrings, resultsTranslator, context);
                        } else {
                            vt = new ArrayList(1);
                            vt.add(value);
                            lresults = new ArrayList(1);
                            lresults.add(vt);
                            SysAdminExecutionHelper.transferObjectResults(batch, lresults, command, trimStrings, resultsTranslator, context);
                        }
                    } else {
                        l2 = new ArrayList(1);
                        l2.add(value);
                        batch.addRow(l2);
                    }
                } else {
                    transform = SysAdminExecutionHelper.determineTransformation(valueType, columnTypes[0], resultsTranslator.getValueTranslators());
                    value = transform != null ? transform.translate(value, command, context) : SysAdminExecutionHelper.modifyTimeZone(value, dbmsTimeZone, cal);
                    if (trimStrings && value instanceof String) {
                        value = SysAdminExecutionHelper.trimString((String)value);
                    }
                    l2 = new ArrayList(1);
                    l2.add(value);
                    batch.addRow(l2);
                }
                ++rowCnt;
            }
            if ((rowCnt == maxBatchSize || rowCnt == rsize) && setLastBatch) {
                batch.setLast();
            }
        }
        catch (ConnectorException e2) {
            throw e2;
        }
        catch (Throwable e3) {
            throw new ConnectorException(e3, SysAdminPlugin.Util.getString("ObjectExecutionHelper.Unknown_error_translating_results___9", e3.getMessage()));
        }
    }

    protected static void transferObjectResults(Batch batch, List spResults, IObjectCommand command, boolean trimStrings, ISourceTranslator resultsTranslator, ExecutionContext context) throws ConnectorException {
        Class[] columnTypes = command.getResultColumnTypes();
        boolean[] trimColumn = new boolean[columnTypes.length];
        if (trimStrings) {
            for (int i2 = 0; i2 < columnTypes.length; ++i2) {
                if (!columnTypes[i2].equals(class$java$lang$String == null ? SysAdminExecutionHelper.class$("java.lang.String") : class$java$lang$String)) continue;
                trimColumn[i2] = true;
            }
        }
        boolean[] transformKnown = new boolean[columnTypes.length];
        IValueTranslator[] transforms = new IValueTranslator[columnTypes.length];
        ArrayList vals = null;
        int numCols = columnTypes.length;
        int rowCnt = 0;
        TimeZone dbmsTimeZone = resultsTranslator.getDatabaseTimezone();
        Calendar cal = null;
        if (dbmsTimeZone != null) {
            cal = Calendar.getInstance(dbmsTimeZone);
        }
        try {
            if (rowCnt < spResults.size()) {
                vals = new ArrayList(numCols);
                List valueList = (List)spResults.get(rowCnt);
                for (int i3 = 0; i3 < numCols; ++i3) {
                    Object value = valueList.get(i3);
                    if (value != null) {
                        if (!transformKnown[i3]) {
                            Class<?> valueType = value.getClass();
                            if (valueType != columnTypes[i3]) {
                                transforms[i3] = SysAdminExecutionHelper.determineTransformation(valueType, columnTypes[i3], resultsTranslator.getValueTranslators());
                            }
                            transformKnown[i3] = true;
                        }
                        if (transforms[i3] != null) {
                            value = transforms[i3].translate(value, command, context);
                        }
                        value = SysAdminExecutionHelper.modifyTimeZone(value, dbmsTimeZone, cal);
                        if (trimColumn[i3]) {
                            value = SysAdminExecutionHelper.trimString((String)value);
                        }
                    }
                    vals.add(value);
                }
                batch.addRow(vals);
                ++rowCnt;
            }
        }
        catch (ConnectorException e2) {
            throw e2;
        }
        catch (Throwable e3) {
            throw new ConnectorException(e3, SysAdminPlugin.Util.getString("ObjectExecutionHelper.Unknown_error_translating_results___9", e3.getMessage()));
        }
    }

    private static Object modifyTimeZone(Object value, TimeZone dbmsTimeZone, Calendar target) {
        if (value instanceof TimestampWithTimezone) {
            return value;
        }
        if (dbmsTimeZone != null && value instanceof java.util.Date) {
            if (value instanceof Timestamp) {
                return TimestampWithTimezone.createTimestamp((Timestamp)value, LOCAL_TIME_ZONE, target);
            }
            if (value instanceof Date) {
                return TimestampWithTimezone.createDate((Date)value, LOCAL_TIME_ZONE, target);
            }
            if (value instanceof Time) {
                return TimestampWithTimezone.createTime((Time)value, LOCAL_TIME_ZONE, target);
            }
            return TimestampWithTimezone.createDate((java.util.Date)value, LOCAL_TIME_ZONE, target);
        }
        return value;
    }

    protected static IValueTranslator determineTransformation(Class actualType, Class expectedType, List valueTranslators) throws ConnectorException {
        IValueTranslator valueTranslator = null;
        if (valueTranslators != null && !valueTranslators.isEmpty()) {
            Iterator iter = valueTranslators.iterator();
            while (iter.hasNext()) {
                IValueTranslator translator = (IValueTranslator)iter.next();
                boolean exactTarget = expectedType.equals(translator.getTargetType());
                boolean exactSource = actualType.equals(translator.getSourceType());
                if (exactTarget && exactSource) {
                    valueTranslator = translator;
                    break;
                }
                boolean assignableSource = translator.getSourceType().isAssignableFrom(actualType);
                if (exactTarget && assignableSource) {
                    valueTranslator = translator;
                    break;
                }
                boolean assignableTarget = translator.getTargetType().isAssignableFrom(expectedType);
                if (exactSource && assignableTarget) {
                    valueTranslator = translator;
                    break;
                }
                if (!assignableTarget || !assignableSource) continue;
                valueTranslator = translator;
                break;
            }
        }
        if (valueTranslator == null) {
            Transform transform = DataTypeManager.getTransform(actualType, expectedType);
            if (transform == null) {
                throw new ConnectorException(SysAdminPlugin.Util.getString("ExecutionHelper.Unable_to_translate_data_value__1", actualType.getName(), expectedType.getName()));
            }
            valueTranslator = new BasicValueTranslator(transform);
        }
        return valueTranslator;
    }

    static String trimString(String value) {
        for (int i2 = value.length() - 1; i2 >= 0; --i2) {
            if (value.charAt(i2) == ' ') continue;
            return value.substring(0, i2 + 1);
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

