/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.sysadmin.extension.value;

import com.metamatrix.connector.sysadmin.SysAdminMethodManager;
import com.metamatrix.connector.sysadmin.extension.IObjectCommand;
import com.metamatrix.connector.sysadmin.extension.IValueTranslator;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class SourceInterfaceValueTranslator
implements IValueTranslator {
    static final String METHOD_GETPROPERTIES = "Properties";
    static final String DELIM = ".";
    private static Map usedMethods = new HashMap();
    private Class sourceClass = null;
    private Class targetClass = null;
    static /* synthetic */ Class class$java$lang$String;

    public SourceInterfaceValueTranslator(Class sourceInterfaceClass) {
        this.sourceClass = sourceInterfaceClass;
        this.targetClass = sourceInterfaceClass;
    }

    public SourceInterfaceValueTranslator(Class sourceInterfaceClass, Class targetInterfaceClass) {
        this.sourceClass = sourceInterfaceClass;
        this.targetClass = targetInterfaceClass;
    }

    public void initialize(ConnectorEnvironment env) {
    }

    public Class getSourceType() {
        return this.sourceClass;
    }

    public Class getTargetType() {
        return this.targetClass;
    }

    public Object translate(Object object, IObjectCommand command, ExecutionContext context) throws ConnectorException {
        LinkedList<Object> row = new LinkedList<Object>();
        Method m2 = null;
        String[] resultColumnNames = command.getResultColumnNames();
        String[] resultNameInSource = command.getResultNamesInSource();
        int s2 = resultColumnNames.length;
        for (int i2 = 0; i2 < s2; ++i2) {
            String methodName = null;
            methodName = resultNameInSource[i2] != null ? resultNameInSource[i2] : resultColumnNames[i2];
            if (methodName.indexOf(DELIM) > 0) {
                List tokens = StringUtil.getTokens(methodName, DELIM);
                if (tokens.size() == 1) {
                    row.add("InvalidNameInSource:" + methodName);
                    continue;
                }
                String methodCall = (String)tokens.get(0);
                String methodParm = (String)tokens.get(1);
                if (methodCall.equalsIgnoreCase(METHOD_GETPROPERTIES)) {
                    m2 = this.getObjectMethod(object, methodCall, null);
                    Properties props = (Properties)this.executeMethod(m2, object, Collections.EMPTY_LIST);
                    String value = props.getProperty(methodParm);
                    row.add(value);
                    continue;
                }
                ArrayList<Class> args = new ArrayList<Class>(1);
                args.add(class$java$lang$String == null ? SourceInterfaceValueTranslator.class$("java.lang.String") : class$java$lang$String);
                m2 = this.getObjectMethod(object, methodCall, args);
                ArrayList<String> parms = new ArrayList<String>(1);
                parms.add(methodParm);
                String value = (String)this.executeMethod(m2, object, parms);
                row.add(value);
                continue;
            }
            String getMethodName = "get" + methodName;
            m2 = this.getObjectMethod(object, getMethodName, null);
            if (m2 == null) {
                m2 = this.getObjectMethod(object, methodName, null);
            }
            if (m2 != null) {
                Object result = this.executeMethod(m2, object, Collections.EMPTY_LIST);
                row.add(result);
                continue;
            }
            row.add(object.toString());
        }
        return row;
    }

    protected Object executeMethod(Method m2, Object api, List parms) throws ConnectorException {
        try {
            return m2.invoke(api, parms.toArray());
        }
        catch (Exception ite) {
            throw new ConnectorException(ite);
        }
    }

    protected Method getObjectMethod(Object object, String methodName, List parms) throws ConnectorException {
        String key = object.getClass().getName() + "_" + methodName;
        try {
            if (usedMethods.containsKey(key)) {
                Method m2 = (Method)usedMethods.get(key);
                return m2;
            }
            Method m3 = SysAdminMethodManager.getMethodFromObject(object.getClass(), methodName, parms);
            usedMethods.put(key, m3);
            return m3;
        }
        catch (NoSuchMethodException nsm) {
            usedMethods.put(key, null);
            return null;
        }
        catch (Exception err) {
            throw new ConnectorException(err);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

