/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.sysadmin.extension.command;

import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoFactory;
import com.metamatrix.common.util.crypto.Encryptor;
import com.metamatrix.connector.sysadmin.extension.command.BaseProcedureCommand;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PasswordCommand
extends BaseProcedureCommand {
    public static final String METHOD_ADDUSER_COMMAND = "addUser";
    public static final String METHOD_ADDGROUP_COMMAND = "addGroup";
    public static final String METHOD_SETPASSWORD_COMMAND = "setUserPassword";
    private static final String PASSWORD_PARM_NAME = "password";
    private static List SUPPORTED_COMMANDS = new ArrayList(3);

    public PasswordCommand(RuntimeMetadata metadata, IProcedure command) throws ConnectorException {
        super(metadata, command);
    }

    public static final boolean supportedCommand(String command) {
        return SUPPORTED_COMMANDS.contains(command);
    }

    void setCriteria() throws ConnectorException {
        List parms = this.getParameters();
        if (parms != null && parms.size() > 0) {
            Iterator it = parms.iterator();
            while (it.hasNext()) {
                IParameter iparm = (IParameter)it.next();
                String nameInSource = this.determineName(iparm);
                String nameInSourceLC = nameInSource.toLowerCase();
                if (nameInSourceLC.indexOf(PASSWORD_PARM_NAME) >= 0) {
                    String pw = iparm.getValue().toString();
                    try {
                        Encryptor encryptor = CryptoFactory.getEncryptor();
                        char[] newpw = encryptor.encrypt(pw.toCharArray());
                        this.addCriteria(iparm.getType(), new String(newpw), nameInSource);
                        continue;
                    }
                    catch (CryptoException err) {
                        ConnectorException ce = new ConnectorException(err.getMessage());
                        ce.setStackTrace(ce.getStackTrace());
                        throw ce;
                    }
                }
                this.addCriteria(iparm.getType(), iparm.getValue(), nameInSource);
            }
        }
    }

    static {
        SUPPORTED_COMMANDS.add(METHOD_ADDUSER_COMMAND);
        SUPPORTED_COMMANDS.add(METHOD_ADDGROUP_COMMAND);
        SUPPORTED_COMMANDS.add(METHOD_SETPASSWORD_COMMAND);
    }
}

