/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.sysadmin;

import com.metamatrix.connector.sysadmin.SysAdminPlugin;
import com.metamatrix.connector.sysadmin.extension.ICommandTranslator;
import com.metamatrix.connector.sysadmin.extension.IObjectCommand;
import com.metamatrix.connector.sysadmin.extension.ISourceTranslator;
import com.metamatrix.connector.sysadmin.extension.IValueRetriever;
import com.metamatrix.connector.sysadmin.extension.IValueTranslator;
import com.metamatrix.connector.sysadmin.extension.value.BasicValueRetriever;
import com.metamatrix.connector.sysadmin.extension.value.DefaultProcedureCommandTranslator;
import com.metamatrix.connector.sysadmin.extension.value.JavaUtilDateToSqlDateValueTranslator;
import com.metamatrix.connector.sysadmin.extension.value.JavaUtilDateToStringValueTranslator;
import com.metamatrix.connector.sysadmin.extension.value.JavaUtilDateToTimeStampValueTranslator;
import com.metamatrix.connector.sysadmin.extension.value.PasswordCommandTranslator;
import com.metamatrix.connector.sysadmin.extension.value.SourceInterfaceValueTranslator;
import com.metamatrix.connector.sysadmin.util.SysAdminUtil;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class SysAdminSourceTranslator
implements ISourceTranslator {
    private static final TimeZone LOCAL_TIME_ZONE = TimeZone.getDefault();
    private Class apiClazz = null;
    private List valueTranslators = new ArrayList(5);
    private IValueRetriever valueRetriever = new BasicValueRetriever();
    private List commandTranslators = new ArrayList(5);
    private static final ICommandTranslator defaultCommandTranslator = new DefaultProcedureCommandTranslator();
    private TimeZone dbmsTimeZone = null;

    SysAdminSourceTranslator(Class clazz) {
        this.apiClazz = clazz;
    }

    public void initialize(ConnectorEnvironment env) throws ConnectorException {
        IValueTranslator valueTranslator = new SourceInterfaceValueTranslator(this.apiClazz);
        valueTranslator.initialize(env);
        this.addValueTranslator(valueTranslator);
        valueTranslator = new JavaUtilDateToTimeStampValueTranslator();
        valueTranslator.initialize(env);
        this.addValueTranslator(valueTranslator);
        valueTranslator = new JavaUtilDateToSqlDateValueTranslator();
        valueTranslator.initialize(env);
        this.addValueTranslator(valueTranslator);
        valueTranslator = new JavaUtilDateToStringValueTranslator();
        valueTranslator.initialize(env);
        this.addValueTranslator(valueTranslator);
        PasswordCommandTranslator commandTranslator = new PasswordCommandTranslator();
        this.addCommandTranslator(commandTranslator);
        String timeZone = env.getProperties().getProperty("DatabaseTimeZone");
        if (timeZone != null && timeZone.trim().length() > 0) {
            this.dbmsTimeZone = TimeZone.getTimeZone(timeZone);
            if (LOCAL_TIME_ZONE.equals(timeZone)) {
                this.dbmsTimeZone = null;
            }
        }
    }

    public List getValueTranslators() {
        return this.valueTranslators;
    }

    public IValueRetriever getValueRetriever() {
        return this.valueRetriever;
    }

    public ICommandTranslator getCommandTranslator(String commandName) {
        Iterator it = this.commandTranslators.iterator();
        while (it.hasNext()) {
            ICommandTranslator oc = (ICommandTranslator)it.next();
            if (!oc.canTranslateCommand(commandName)) continue;
            return oc;
        }
        return defaultCommandTranslator;
    }

    protected void addCommandTranslator(ICommandTranslator objectCommand) {
        this.commandTranslators.add(objectCommand);
    }

    protected void addValueTranslator(IValueTranslator valueTranslator) {
        this.valueTranslators.add(valueTranslator);
    }

    public TimeZone getDatabaseTimezone() {
        return this.dbmsTimeZone;
    }

    public Batch modifyBatch(Batch batch, ExecutionContext context, ICommand command) {
        return batch;
    }

    public IObjectCommand createObjectCommand(RuntimeMetadata metadata, ICommand command) throws ConnectorException {
        if (command instanceof IProcedure) {
            String commandName = SysAdminUtil.getExecutionName(metadata, (IProcedure)command);
            ICommandTranslator ct = this.getCommandTranslator(commandName);
            return ct.getCommand(metadata, command);
        }
        throw new ConnectorException(SysAdminPlugin.Util.getString("SysAdminSourceTranslator.Command_type_not_supported", command.getClass().getName()));
    }
}

