/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.sysadmin;

import com.metamatrix.connector.sysadmin.SysAdminObjectSource;
import com.metamatrix.connector.sysadmin.extension.IObjectCommand;
import com.metamatrix.connector.sysadmin.extension.ISourceTranslator;
import com.metamatrix.connector.sysadmin.util.SysAdminExecutionHelper;
import com.metamatrix.data.api.Batch;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.api.ConnectorLogger;
import com.metamatrix.data.api.ProcedureExecution;
import com.metamatrix.data.basic.BasicBatch;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.language.IParameter;
import com.metamatrix.data.language.IProcedure;
import com.metamatrix.data.metadata.runtime.RuntimeMetadata;
import java.util.Collections;
import java.util.List;

public class SysAdminProcedureExecution
implements ProcedureExecution {
    private RuntimeMetadata metadata = null;
    private SysAdminObjectSource api;
    private ConnectorLogger logger = null;
    private List results = null;
    private ISourceTranslator translator = null;
    private int maxBatchSize;
    private IObjectCommand objectProcedure;
    protected boolean trimString;

    public SysAdminProcedureExecution(RuntimeMetadata metadata, Object objectSource, ConnectorEnvironment environment) {
        this.metadata = metadata;
        this.logger = environment.getLogger();
        this.api = (SysAdminObjectSource)objectSource;
        this.metadata = metadata;
        String propStr = environment.getProperties().getProperty("TrimStrings", "false");
        if (propStr != null) {
            this.trimString = Boolean.valueOf(propStr);
        }
        this.translator = this.api.getSourceTranslator();
    }

    public void execute(IProcedure procedure, int maxBatchSize) throws ConnectorException {
        this.maxBatchSize = maxBatchSize;
        this.objectProcedure = this.translator.createObjectCommand(this.metadata, procedure);
        this.results = this.api.getObjects(this.objectProcedure);
    }

    public Batch nextBatch() throws ConnectorException {
        if (this.results != null && this.results.size() > 0) {
            return SysAdminExecutionHelper.createBatch(this.results, this.objectProcedure, this.maxBatchSize, this.trimString, this.translator, null);
        }
        BasicBatch result = new BasicBatch(Collections.EMPTY_LIST);
        result.setLast();
        return result;
    }

    public Object getOutputValue(IParameter parameter) throws ConnectorException {
        return null;
    }

    public void cancel() {
    }

    public void close() {
        this.metadata = null;
        this.api = null;
        this.results = null;
        this.translator = null;
        this.objectProcedure = null;
        this.logger = null;
    }

    protected void logDetail(String msg) {
        if (this.logger != null) {
            this.logger.logDetail(msg);
        }
    }

    protected void logError(String msg, Throwable e2) {
        if (this.logger != null) {
            this.logger.logError(msg, e2);
        }
    }
}

