/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.sysadmin;

import com.metamatrix.connector.sysadmin.SysAdminPlugin;
import com.metamatrix.connector.sysadmin.extension.IObjectCommand;
import com.metamatrix.core.util.ReflectionHelper;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SysAdminMethodManager {
    private Class api = null;
    private Method[] apiMethods = null;

    public SysAdminMethodManager(Class api) throws SecurityException {
        this.api = api;
        this.apiMethods = SysAdminMethodManager.getMethodsFromAPI(this.api);
    }

    public Method getMethodFromAPI(IObjectCommand command) throws SecurityException, NoSuchMethodException {
        String methodName = command.getCommandName();
        return SysAdminMethodManager.getMethod(this.api, methodName, command.getCriteriaTypes(), this.apiMethods);
    }

    public static Method getMethodFromObject(Class object, String methodName, List argumentsClasses) throws SecurityException, NoSuchMethodException {
        Method[] methods = SysAdminMethodManager.getMethodsFromAPI(object);
        return SysAdminMethodManager.getMethod(object, methodName, argumentsClasses, methods);
    }

    public static Object executeMethod(Method m2, Object api, List parms) throws Exception {
        return m2.invoke(api, parms.toArray());
    }

    private static Method getMethod(Class api, String methodName, List argumentsClasses, Method[] methods) throws SecurityException, NoSuchMethodException {
        Method[] namedMethods = SysAdminMethodManager.findMethods(methodName, methods);
        if (namedMethods != null && namedMethods.length == 1) {
            return namedMethods[0];
        }
        Method m2 = SysAdminMethodManager.findBestMethod(api, methodName, argumentsClasses);
        if (m2 == null) {
            throw new NoSuchMethodException(SysAdminPlugin.Util.getString("SysAdminMethodManager.No_method_implemented_for", methodName));
        }
        return m2;
    }

    private static Method[] findMethods(String methodName, Method[] methods) {
        if (methods == null || methods.length == 0) {
            return null;
        }
        ArrayList<Method> result = new ArrayList<Method>();
        for (int i2 = 0; i2 < methods.length; ++i2) {
            Method m2 = methods[i2];
            if (!m2.getName().equals(methodName)) continue;
            result.add(m2);
        }
        return result.toArray(new Method[result.size()]);
    }

    private static Method findBestMethod(Class objectClass, String methodName, List argumentsClasses) throws SecurityException, NoSuchMethodException {
        ReflectionHelper rh = new ReflectionHelper(objectClass);
        if (argumentsClasses == null) {
            argumentsClasses = Collections.EMPTY_LIST;
        }
        Method m2 = rh.findBestMethodWithSignature(methodName, argumentsClasses);
        return m2;
    }

    public static Method[] getMethodsFromAPI(Class api) throws SecurityException {
        Method[] methods = api.getMethods();
        return methods;
    }
}

