/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.internal;

import com.metamatrix.connector.metadata.MetadataConnectorPlugin;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.data.api.ValueChunk;
import com.metamatrix.data.api.ValueReference;
import com.metamatrix.data.basic.BasicValueChunk;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.modeler.core.metadata.runtime.FileRecord;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class ValueReferenceImpl
implements ValueReference {
    private Reader charReader;
    private InputStream byteInputStream;
    private final boolean isBinary;
    private final Object value;
    private FileRecord fileRecord;
    private long size = 999999L;
    private long currentPos;

    public ValueReferenceImpl(Object value, boolean isBinary) {
        ArgCheck.isNotNull(value);
        this.isBinary = isBinary;
        this.value = value;
        if (value instanceof InputStream) {
            if (isBinary) {
                this.byteInputStream = (InputStream)value;
            } else {
                this.charReader = new InputStreamReader((InputStream)value);
            }
        } else if (value instanceof FileRecord) {
            this.fileRecord = (FileRecord)value;
            this.initFileRecord();
            this.size = this.fileRecord.getFileLength();
        }
    }

    private void initFileRecord() {
        if (this.isBinary) {
            this.byteInputStream = this.fileRecord.getContent();
        } else {
            this.charReader = new InputStreamReader(this.fileRecord.getContent());
        }
    }

    public Object getValue() {
        return this.value;
    }

    public long getSize() {
        return this.size;
    }

    public ValueChunk createChunk(long startPos, int chunkSize) throws ConnectorException {
        byte[] byteChunk = null;
        char[] charChunk = null;
        boolean isLast = false;
        if (startPos < this.currentPos) {
            this.initFileRecord();
        }
        if (this.size - startPos < (long)chunkSize) {
            isLast = true;
            if (this.isBinary) {
                byteChunk = new byte[(int)(this.size - startPos)];
            } else {
                charChunk = new char[(int)(this.size - startPos)];
            }
        } else if (this.isBinary) {
            byteChunk = new byte[chunkSize];
        } else {
            charChunk = new char[chunkSize];
        }
        try {
            int read = 0;
            if (this.isBinary) {
                if (this.byteInputStream != null) {
                    read = this.byteInputStream.read(byteChunk);
                }
                if (read <= 0) {
                    isLast = true;
                }
            } else {
                if (this.charReader != null) {
                    read = this.charReader.read(charChunk);
                }
                if (read <= 0) {
                    isLast = true;
                }
            }
            this.currentPos = startPos + (long)chunkSize;
        }
        catch (IOException ie) {
            throw new ConnectorException((Throwable)ie, MetadataConnectorPlugin.Util.getString("ValueReferenceImpl.0"));
        }
        if (this.isBinary) {
            return new BasicValueChunk(byteChunk, this.isBinary, isLast);
        }
        return new BasicValueChunk(charChunk, this.isBinary, isLast);
    }

    public boolean isBinary() {
        return this.isBinary;
    }
}

